/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.hibernate.HibernateException;
import org.hibernate.SharedSessionContract;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.ArrayBackedBinaryStream;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractArrayJavaType;
import org.hibernate.type.descriptor.java.FloatJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public class FloatPrimitiveArrayJavaType
extends AbstractArrayJavaType<float[], Float> {
    public static final FloatPrimitiveArrayJavaType INSTANCE = new FloatPrimitiveArrayJavaType();

    private FloatPrimitiveArrayJavaType() {
        this(FloatJavaType.INSTANCE);
    }

    protected FloatPrimitiveArrayJavaType(JavaType<Float> baseDescriptor) {
        super(float[].class, baseDescriptor, new ArrayMutabilityPlan());
    }

    @Override
    public String extractLoggableRepresentation(float[] value) {
        return value == null ? super.extractLoggableRepresentation(null) : Arrays.toString(value);
    }

    @Override
    public boolean areEqual(float[] one, float[] another) {
        return Arrays.equals(one, another);
    }

    @Override
    public int extractHashCode(float[] value) {
        return Arrays.hashCode(value);
    }

    @Override
    public String toString(float[] value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append(value[0]);
        for (int i = 1; i < value.length; ++i) {
            sb.append(value[i]);
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public float[] fromString(CharSequence charSequence) {
        int elementStart;
        if (charSequence == null) {
            return null;
        }
        ArrayList<Float> list = new ArrayList<Float>();
        char lastChar = charSequence.charAt(charSequence.length() - 1);
        char firstChar = charSequence.charAt(0);
        if (firstChar != '{' || lastChar != '}') {
            throw new IllegalArgumentException("Cannot parse given string into array of strings. First and last character must be { and }");
        }
        int len = charSequence.length();
        for (int i = elementStart = 1; i < len; ++i) {
            char c = charSequence.charAt(i);
            if (c != ',') continue;
            list.add(Float.valueOf(Float.parseFloat(charSequence.subSequence(elementStart, i).toString())));
            elementStart = i + 1;
        }
        float[] result = new float[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Float)list.get(i)).floatValue();
        }
        return result;
    }

    @Override
    public <X> X unwrap(float[] value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (X)value;
        }
        if (Object[].class.isAssignableFrom(type)) {
            Class<?> preferredJavaTypeClass = type.getComponentType();
            Object[] unwrapped = (Object[])Array.newInstance(preferredJavaTypeClass, value.length);
            for (int i = 0; i < value.length; ++i) {
                unwrapped[i] = this.getElementJavaType().unwrap(Float.valueOf(value[i]), preferredJavaTypeClass, options);
            }
            return (X)unwrapped;
        }
        if (type == byte[].class) {
            return (X)SerializationHelper.serialize((Serializable)value);
        }
        if (type == BinaryStream.class) {
            return (X)new ArrayBackedBinaryStream(SerializationHelper.serialize((Serializable)value));
        }
        if (type.isArray()) {
            Class<?> preferredJavaTypeClass = type.getComponentType();
            Object unwrapped = Array.newInstance(preferredJavaTypeClass, value.length);
            for (int i = 0; i < value.length; ++i) {
                Array.set(unwrapped, i, this.getElementJavaType().unwrap(Float.valueOf(value[i]), preferredJavaTypeClass, options));
            }
            return (X)unwrapped;
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> float[] wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Array) {
            java.sql.Array array = (java.sql.Array)value;
            try {
                value = array.getArray();
            }
            catch (SQLException ex) {
                throw new HibernateException(ex);
            }
        }
        if (value instanceof float[]) {
            float[] floats = (float[])value;
            return floats;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return (float[])SerializationHelper.deserialize(bytes);
        }
        if (value instanceof BinaryStream) {
            BinaryStream binaryStream = (BinaryStream)value;
            return (float[])SerializationHelper.deserialize(binaryStream.getBytes());
        }
        if (value.getClass().isArray()) {
            float[] wrapped = new float[Array.getLength(value)];
            for (int i = 0; i < wrapped.length; ++i) {
                wrapped[i] = ((Float)this.getElementJavaType().wrap(Array.get(value, i), options)).floatValue();
            }
            return wrapped;
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return new float[]{floatValue.floatValue()};
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            float[] wrapped = new float[collection.size()];
            int i = 0;
            for (Object e : collection) {
                wrapped[i++] = ((Float)this.getElementJavaType().wrap(e, options)).floatValue();
            }
            return wrapped;
        }
        throw this.unknownWrap(value.getClass());
    }

    private static class ArrayMutabilityPlan
    implements MutabilityPlan<float[]> {
        private ArrayMutabilityPlan() {
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public float[] deepCopy(float[] value) {
            return value == null ? null : (float[])value.clone();
        }

        @Override
        public Serializable disassemble(float[] value, SharedSessionContract session) {
            return this.deepCopy(value);
        }

        @Override
        public float[] assemble(Serializable cached, SharedSessionContract session) {
            return this.deepCopy((float[])cached);
        }
    }
}

