/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.AbstractType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.MappingContext;
import org.hibernate.type.Type;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class EntityType
extends AbstractType
implements AssociationType {
    private final TypeConfiguration typeConfiguration;
    private final String associatedEntityName;
    protected final String uniqueKeyPropertyName;
    private final boolean eager;
    private final boolean unwrapProxy;
    private final boolean referenceToPrimaryKey;
    private volatile transient Type associatedIdentifierType;
    private volatile transient EntityPersister associatedEntityPersister;
    private transient Class<?> returnedClass;

    protected EntityType(TypeConfiguration typeConfiguration, String entityName, boolean referenceToPrimaryKey, String uniqueKeyPropertyName, boolean eager, boolean unwrapProxy) {
        this.typeConfiguration = typeConfiguration;
        this.associatedEntityName = entityName;
        this.uniqueKeyPropertyName = uniqueKeyPropertyName;
        this.eager = eager;
        this.unwrapProxy = unwrapProxy;
        this.referenceToPrimaryKey = referenceToPrimaryKey;
    }

    protected EntityType(EntityType original, String superTypeEntityName) {
        this.typeConfiguration = original.typeConfiguration;
        this.associatedEntityName = superTypeEntityName;
        this.uniqueKeyPropertyName = original.uniqueKeyPropertyName;
        this.eager = original.eager;
        this.unwrapProxy = original.unwrapProxy;
        this.referenceToPrimaryKey = original.referenceToPrimaryKey;
    }

    protected TypeConfiguration scope() {
        return this.typeConfiguration;
    }

    @Override
    public boolean isAssociationType() {
        return true;
    }

    @Override
    public final boolean isEntityType() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getAssociatedEntityName() + ")";
    }

    @Override
    public String getName() {
        return this.associatedEntityName;
    }

    public boolean isReferenceToPrimaryKey() {
        return this.referenceToPrimaryKey;
    }

    @Override
    public String getRHSUniqueKeyPropertyName() {
        return this.referenceToPrimaryKey ? null : this.uniqueKeyPropertyName;
    }

    @Override
    public String getLHSPropertyName() {
        return null;
    }

    public String getPropertyName() {
        return null;
    }

    public final String getAssociatedEntityName() {
        return this.associatedEntityName;
    }

    @Override
    public String getAssociatedEntityName(SessionFactoryImplementor factory) {
        return this.getAssociatedEntityName();
    }

    @Override
    public Joinable getAssociatedJoinable(SessionFactoryImplementor factory) throws MappingException {
        return (Joinable)((Object)this.getAssociatedEntityPersister(factory));
    }

    @Override
    public final Class<?> getReturnedClass() {
        if (this.returnedClass == null) {
            this.returnedClass = this.determineAssociatedEntityClass();
        }
        return this.returnedClass;
    }

    private Class<?> determineAssociatedEntityClass() {
        String entityName = this.getAssociatedEntityName();
        try {
            return ReflectHelper.classForName(entityName);
        }
        catch (ClassNotFoundException cnfe) {
            return this.typeConfiguration.entityClassForEntityName(entityName);
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SharedSessionContractImplementor session) throws SQLException {
        if (settable.length > 0) {
            this.requireIdentifierOrUniqueKeyType(session.getFactory()).nullSafeSet(st, this.getIdentifier(value, session), index, settable, session);
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws SQLException {
        this.requireIdentifierOrUniqueKeyType(session.getFactory()).nullSafeSet(st, this.getIdentifier(value, session), index, session);
    }

    @Override
    public final boolean isSame(Object x, Object y) {
        return x == y;
    }

    @Override
    public int compare(Object x, Object y) {
        throw new UnsupportedOperationException("compare() not implemented for EntityType");
    }

    @Override
    public int compare(Object x, Object y, SessionFactoryImplementor factory) {
        if (x == null) {
            return y == null ? 0 : -1;
        }
        if (y == null) {
            return 1;
        }
        Object xId = this.extractIdentifier(x, factory);
        Object yId = this.extractIdentifier(y, factory);
        return this.getIdentifierType(factory).compare(xId, yId);
    }

    private Object extractIdentifier(Object entity, SessionFactoryImplementor factory) {
        EntityPersister concretePersister = this.getAssociatedEntityPersister(factory);
        return concretePersister == null ? null : concretePersister.getIdentifier(entity);
    }

    @Override
    public Object deepCopy(Object value, SessionFactoryImplementor factory) {
        return value;
    }

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache) throws HibernateException {
        if (original == null) {
            return null;
        }
        Object cached = copyCache.get(original);
        if (cached != null) {
            return cached;
        }
        if (original == target) {
            return target;
        }
        if (session.getContextEntityIdentifier(original) == null && ForeignKeys.isTransient(this.associatedEntityName, original, Boolean.FALSE, session)) {
            if (copyCache.containsValue(original)) {
                return original;
            }
            Object copy = session.getEntityPersister(this.associatedEntityName, original).instantiate(null, session);
            copyCache.put(original, copy);
            return copy;
        }
        Object id = this.getIdentifier(original, session);
        if (id == null) {
            throw new AssertionFailure("non-transient entity has a null id: " + original.getClass().getName());
        }
        id = this.getIdentifierOrUniqueKeyType(session.getFactory()).replace(id, null, session, owner, copyCache);
        return this.resolve(id, session, owner);
    }

    @Override
    public int getHashCode(Object x, SessionFactoryImplementor factory) {
        EntityPersister persister = this.getAssociatedEntityPersister(factory);
        if (this.isReferenceToPrimaryKey()) {
            Class<?> mappedClass;
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(x);
            Object id = lazyInitializer != null ? lazyInitializer.getInternalIdentifier() : ((mappedClass = persister.getMappedClass()).isInstance(x) ? persister.getIdentifier(x) : x);
            return persister.getIdentifierType().getHashCode(id, factory);
        }
        assert (this.uniqueKeyPropertyName != null);
        Type keyType = persister.getPropertyType(this.uniqueKeyPropertyName);
        Object uniqueKey = keyType.getReturnedClass().isInstance(x) ? x : persister.getPropertyValue(x, this.uniqueKeyPropertyName);
        return keyType.getHashCode(uniqueKey, factory);
    }

    @Override
    public boolean isEqual(Object x, Object y, SessionFactoryImplementor factory) {
        if (x == null || y == null) {
            return x == y;
        }
        if (x == y) {
            return true;
        }
        EntityPersister persister = this.getAssociatedEntityPersister(factory);
        if (this.isReferenceToPrimaryKey()) {
            Class<?> mappedClass = persister.getMappedClass();
            LazyInitializer lazyInitializerX = HibernateProxy.extractLazyInitializer(x);
            Object xid = lazyInitializerX != null ? lazyInitializerX.getInternalIdentifier() : (mappedClass.isInstance(x) ? persister.getIdentifier(x) : x);
            LazyInitializer lazyInitializerY = HibernateProxy.extractLazyInitializer(y);
            Object yid = lazyInitializerY != null ? lazyInitializerY.getInternalIdentifier() : (mappedClass.isInstance(y) ? persister.getIdentifier(y) : y);
            return xid == yid || persister.getIdentifierType().isEqual(xid, yid, factory);
        }
        assert (this.uniqueKeyPropertyName != null);
        Type keyType = persister.getPropertyType(this.uniqueKeyPropertyName);
        Object xUniqueKey = keyType.getReturnedClass().isInstance(x) ? x : persister.getPropertyValue(x, this.uniqueKeyPropertyName);
        Object yUniqueKey = keyType.getReturnedClass().isInstance(y) ? y : persister.getPropertyValue(y, this.uniqueKeyPropertyName);
        return xUniqueKey == yUniqueKey || keyType.isEqual(xUniqueKey, yUniqueKey, factory);
    }

    protected Object resolve(Object value, SharedSessionContractImplementor session, Object owner) {
        if (value != null && !this.isNull(owner, session)) {
            if (this.isReferenceToPrimaryKey()) {
                return this.resolveIdentifier(value, session, null);
            }
            if (this.uniqueKeyPropertyName != null) {
                return this.loadByUniqueKey(this.getAssociatedEntityName(), this.uniqueKeyPropertyName, value, session);
            }
        }
        return null;
    }

    public boolean isEager(Boolean overridingEager) {
        return overridingEager != null ? overridingEager : this.eager;
    }

    public EntityPersister getAssociatedEntityPersister(SessionFactoryImplementor factory) {
        EntityPersister persister = this.associatedEntityPersister;
        if (persister == null) {
            this.associatedEntityPersister = factory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(this.getAssociatedEntityName());
            return this.associatedEntityPersister;
        }
        return persister;
    }

    protected final Object getIdentifier(Object value, SharedSessionContractImplementor session) throws HibernateException {
        PersistentAttributeInterceptor interceptor;
        if (this.isReferenceToIdentifierProperty()) {
            return ForeignKeys.getEntityIdentifierIfNotUnsaved(this.getAssociatedEntityName(), value, session);
        }
        if (value == null) {
            return null;
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(value);
        if (lazyInitializer != null) {
            value = lazyInitializer.getImplementation();
        } else if (ManagedTypeHelper.isPersistentAttributeInterceptable(value) && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(value).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor) {
            ((EnhancementAsProxyLazinessInterceptor)interceptor).forceInitialize(value, null);
        }
        EntityPersister entityPersister = this.getAssociatedEntityPersister(session.getFactory());
        Object propertyValue = entityPersister.getPropertyValue(value, this.uniqueKeyPropertyName);
        Type type = entityPersister.getPropertyType(this.uniqueKeyPropertyName);
        if (type instanceof EntityType) {
            return ((EntityType)type).getIdentifier(propertyValue, session);
        }
        return propertyValue;
    }

    protected final Object getIdentifier(Object value, SessionFactoryImplementor sessionFactory) throws HibernateException {
        if (this.isReferenceToIdentifierProperty()) {
            return this.getAssociatedEntityPersister(sessionFactory).getIdentifierMapping().getIdentifier(value);
        }
        if (value == null) {
            return null;
        }
        EntityPersister entityPersister = this.getAssociatedEntityPersister(sessionFactory);
        Object propertyValue = entityPersister.getPropertyValue(value, this.uniqueKeyPropertyName);
        Type type = entityPersister.getPropertyType(this.uniqueKeyPropertyName);
        if (type instanceof EntityType) {
            return ((EntityType)type).getIdentifier(propertyValue, sessionFactory);
        }
        return propertyValue;
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) {
        if (value == null) {
            return "null";
        }
        EntityPersister persister = this.getAssociatedEntityPersister(factory);
        if (!persister.isInstance(value) && persister.getIdentifierType().getReturnedClass().isInstance(value)) {
            return this.associatedEntityName + "#" + value;
        }
        StringBuilder result = new StringBuilder().append(this.associatedEntityName);
        if (persister.hasIdentifierProperty()) {
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(value);
            Object id = lazyInitializer != null ? lazyInitializer.getInternalIdentifier() : persister.getIdentifier(value);
            result.append('#').append(persister.getIdentifierType().toLoggableString(id, factory));
        }
        return result.toString();
    }

    public abstract boolean isOneToOne();

    public boolean isLogicalOneToOne() {
        return this.isOneToOne();
    }

    @Deprecated(since="7.0")
    Type getIdentifierType(Mapping factory) {
        return this.getIdentifierType((MappingContext)factory);
    }

    Type getIdentifierType(MappingContext mappingContext) {
        Type type = this.associatedIdentifierType;
        if (type == null) {
            this.associatedIdentifierType = mappingContext.getIdentifierType(this.getAssociatedEntityName());
            return this.associatedIdentifierType;
        }
        return type;
    }

    Type getIdentifierType(SharedSessionContractImplementor session) {
        Type type = this.associatedIdentifierType;
        if (type == null) {
            this.associatedIdentifierType = this.getIdentifierType(session.getFactory());
            return this.associatedIdentifierType;
        }
        return type;
    }

    @Deprecated(since="7.0")
    public final Type getIdentifierOrUniqueKeyType(Mapping factory) throws MappingException {
        return this.getIdentifierOrUniqueKeyType((MappingContext)factory);
    }

    public final Type getIdentifierOrUniqueKeyType(MappingContext mappingContext) throws MappingException {
        if (this.isReferenceToIdentifierProperty()) {
            return this.getIdentifierType(mappingContext);
        }
        Type type = mappingContext.getReferencedPropertyType(this.getAssociatedEntityName(), this.uniqueKeyPropertyName);
        if (type instanceof EntityType) {
            EntityType entityType = (EntityType)type;
            return entityType.getIdentifierOrUniqueKeyType(mappingContext);
        }
        return type;
    }

    public final String getIdentifierOrUniqueKeyPropertyName(Mapping factory) throws MappingException {
        return this.getIdentifierOrUniqueKeyPropertyName((MappingContext)factory);
    }

    public final String getIdentifierOrUniqueKeyPropertyName(MappingContext mappingContext) throws MappingException {
        return this.isReferenceToIdentifierProperty() ? mappingContext.getIdentifierPropertyName(this.getAssociatedEntityName()) : this.uniqueKeyPropertyName;
    }

    public boolean isReferenceToIdentifierProperty() {
        return this.isReferenceToPrimaryKey() || this.uniqueKeyPropertyName == null;
    }

    public abstract boolean isNullable();

    protected final Object resolveIdentifier(Object id, SharedSessionContractImplementor session, Boolean overridingEager) throws HibernateException {
        boolean isProxyUnwrapEnabled = this.unwrapProxy && this.getAssociatedEntityPersister(session.getFactory()).isInstrumented();
        Object proxyOrEntity = session.internalLoad(this.getAssociatedEntityName(), id, this.isEager(overridingEager), this.isNullable());
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(proxyOrEntity);
        if (lazyInitializer != null) {
            lazyInitializer.setUnwrap(isProxyUnwrapEnabled);
        }
        return proxyOrEntity;
    }

    protected final Object resolveIdentifier(Object id, SharedSessionContractImplementor session) throws HibernateException {
        return this.resolveIdentifier(id, session, null);
    }

    protected boolean isNull(Object owner, SharedSessionContractImplementor session) {
        return false;
    }

    public Object loadByUniqueKey(String entityName, String uniqueKeyPropertyName, Object key, SharedSessionContractImplementor session) throws HibernateException {
        SessionFactoryImplementor factory = session.getFactory();
        EntityPersister persister = factory.getMappingMetamodel().getEntityDescriptor(entityName);
        EntityUniqueKey euk = new EntityUniqueKey(entityName, uniqueKeyPropertyName, key, this.getIdentifierOrUniqueKeyType(factory), session.getFactory());
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        Object result = persistenceContext.getEntity(euk);
        if (result == null && (result = persister.loadByUniqueKey(uniqueKeyPropertyName, key, session)) != null) {
            persistenceContext.addEntity(euk, result);
        }
        return result == null ? null : persistenceContext.proxyFor(result);
    }

    protected Type requireIdentifierOrUniqueKeyType(MappingContext mapping) {
        Type fkTargetType = this.getIdentifierOrUniqueKeyType(mapping);
        if (fkTargetType == null) {
            throw new MappingException("Unable to determine FK target Type for many-to-one or one-to-one mapping: referenced-entity-name=[" + this.getAssociatedEntityName() + "], referenced-entity-attribute-name=[" + this.getLHSPropertyName() + "]");
        }
        return fkTargetType;
    }
}

