/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.sqm.CastType;
import org.hibernate.type.BasicType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.MappingContext;
import org.hibernate.type.ProcedureParameterExtractionAware;
import org.hibernate.type.ProcedureParameterNamedBinder;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public abstract class AbstractStandardBasicType<T>
implements BasicType<T>,
ProcedureParameterExtractionAware<T>,
ProcedureParameterNamedBinder<T> {
    private final JdbcType jdbcType;
    private final JavaType<T> javaType;
    private final int[] sqlTypes;
    private final ValueBinder<T> jdbcValueBinder;
    private final ValueExtractor<T> jdbcValueExtractor;
    private final JdbcLiteralFormatter<T> jdbcLiteralFormatter;
    private final @Nullable Type typeForEqualsHashCode;
    private final Class<?> javaTypeClass;
    private final MutabilityPlan<T> mutabilityPlan;
    private final Comparator<T> javatypeComparator;

    public AbstractStandardBasicType(JdbcType jdbcType, JavaType<T> javaType) {
        this.jdbcType = jdbcType;
        this.sqlTypes = new int[]{jdbcType.getDdlTypeCode()};
        this.javaType = javaType;
        this.jdbcValueBinder = jdbcType.getBinder(javaType);
        this.jdbcValueExtractor = jdbcType.getExtractor(javaType);
        this.jdbcLiteralFormatter = jdbcType.getJdbcLiteralFormatter(javaType);
        this.javaTypeClass = javaType.getJavaTypeClass();
        this.mutabilityPlan = javaType.getMutabilityPlan();
        this.javatypeComparator = javaType.getComparator();
        this.typeForEqualsHashCode = javaType.useObjectEqualsHashCode() ? null : this;
    }

    @Override
    public ValueExtractor<T> getJdbcValueExtractor() {
        return this.jdbcValueExtractor;
    }

    @Override
    public ValueBinder<T> getJdbcValueBinder() {
        return this.jdbcValueBinder;
    }

    @Override
    public JdbcLiteralFormatter<T> getJdbcLiteralFormatter() {
        return this.jdbcLiteralFormatter;
    }

    public Class<T> getJavaType() {
        return this.getExpressibleJavaType().getJavaTypeClass();
    }

    public T fromString(CharSequence string) {
        return this.javaType.fromString(string);
    }

    protected MutabilityPlan<T> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public boolean[] toColumnNullness(Object value, MappingContext mapping) {
        return value == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }

    @Override
    public String[] getRegistrationKeys() {
        String[] stringArray;
        if (this.registerUnderJavaType()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = this.getName();
            stringArray = stringArray2;
            stringArray2[1] = this.javaType.getTypeName();
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = this.getName();
        }
        return stringArray;
    }

    protected boolean registerUnderJavaType() {
        return false;
    }

    @Override
    public final JavaType<T> getJavaTypeDescriptor() {
        return this.javaType;
    }

    @Override
    public final JdbcType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    public final Class<?> getReturnedClass() {
        return this.javaTypeClass;
    }

    @Override
    public final int getColumnSpan(MappingContext mapping) throws MappingException {
        return 1;
    }

    @Override
    public final int[] getSqlTypeCodes(MappingContext mappingContext) throws MappingException {
        return this.sqlTypes;
    }

    @Override
    public final boolean isAssociationType() {
        return false;
    }

    @Override
    public final boolean isCollectionType() {
        return false;
    }

    @Override
    public final boolean isComponentType() {
        return false;
    }

    @Override
    public final boolean isEntityType() {
        return false;
    }

    @Override
    public final boolean isAnyType() {
        return false;
    }

    @Override
    public final boolean isSame(Object x, Object y) {
        return this.isEqual(x, y);
    }

    @Override
    public final boolean isEqual(Object x, Object y, SessionFactoryImplementor factory) {
        return this.isEqual(x, y);
    }

    @Override
    public boolean isEqual(Object one, Object another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        if (this.typeForEqualsHashCode == null) {
            return one.equals(another);
        }
        return this.javaType.areEqual(one, another);
    }

    @Override
    public int getHashCode(Object x) {
        if (this.typeForEqualsHashCode == null) {
            return x.hashCode();
        }
        return this.javaType.extractHashCode(x);
    }

    @Override
    public final int getHashCode(Object x, SessionFactoryImplementor factory) {
        return this.getHashCode(x);
    }

    @Override
    public @Nullable Type getTypeForEqualsHashCode() {
        return this.typeForEqualsHashCode;
    }

    @Override
    public final int compare(Object x, Object y) {
        return this.javatypeComparator.compare(x, y);
    }

    @Override
    public final boolean isDirty(Object old, Object current, SharedSessionContractImplementor session) {
        return this.isDirty(old, current);
    }

    @Override
    public final boolean isDirty(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) {
        return checkable[0] && this.isDirty(old, current);
    }

    protected final boolean isDirty(Object old, Object current) {
        return this.getMutabilityPlan() == MutableMutabilityPlan.INSTANCE || !this.isSame(old, current);
    }

    @Override
    public final boolean isModified(Object oldHydratedState, Object currentState, boolean[] checkable, SharedSessionContractImplementor session) {
        return this.isDirty(oldHydratedState, currentState);
    }

    @Override
    public final void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws SQLException {
        this.nullSafeSet(st, value, index, (WrapperOptions)session);
    }

    protected void nullSafeSet(PreparedStatement st, T value, int index, WrapperOptions options) throws SQLException {
        this.getJdbcValueBinder().bind(st, value, index, options);
    }

    @Override
    public final String toLoggableString(Object value, SessionFactoryImplementor factory) {
        if (value == LazyPropertyInitializer.UNFETCHED_PROPERTY || !Hibernate.isInitialized(value)) {
            return "<uninitialized>";
        }
        return this.javaType.extractLoggableRepresentation(value);
    }

    @Override
    public final boolean isMutable() {
        return this.getMutabilityPlan().isMutable();
    }

    @Override
    public final Object deepCopy(Object value, SessionFactoryImplementor factory) {
        return this.deepCopy(value);
    }

    protected final T deepCopy(T value) {
        return this.getMutabilityPlan().deepCopy(value);
    }

    @Override
    public final Serializable disassemble(Object value, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return this.getMutabilityPlan().disassemble(value, session);
    }

    @Override
    public final Object assemble(Serializable cached, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return this.getMutabilityPlan().assemble(cached, session);
    }

    @Override
    public final void beforeAssemble(Serializable cached, SharedSessionContractImplementor session) {
    }

    @Override
    public final Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache) {
        if (original == null && target == null) {
            return null;
        }
        return this.javaType.getReplacement(original, target, session);
    }

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache, ForeignKeyDirection foreignKeyDirection) {
        return ForeignKeyDirection.FROM_PARENT == foreignKeyDirection ? this.javaType.getReplacement(original, target, session) : target;
    }

    @Override
    public boolean canDoExtraction() {
        return true;
    }

    @Override
    public T extract(CallableStatement statement, int startIndex, SharedSessionContractImplementor session) throws SQLException {
        return this.getJdbcValueExtractor().extract(statement, startIndex, (WrapperOptions)session);
    }

    @Override
    public T extract(CallableStatement statement, String paramName, SharedSessionContractImplementor session) throws SQLException {
        return this.getJdbcValueExtractor().extract(statement, paramName, (WrapperOptions)session);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SharedSessionContractImplementor session) throws SQLException {
    }

    @Override
    public void nullSafeSet(CallableStatement st, T value, String name, SharedSessionContractImplementor session) throws SQLException {
        this.nullSafeSet(st, value, name, (WrapperOptions)session);
    }

    protected final void nullSafeSet(CallableStatement st, Object value, String name, WrapperOptions options) throws SQLException {
        this.getJdbcValueBinder().bind(st, value, name, options);
    }

    @Override
    public boolean canDoSetting() {
        return true;
    }

    @Override
    public CastType getCastType() {
        JdbcType jdbcType = this.getJdbcType();
        int jdbcTypeCode = jdbcType.getDdlTypeCode();
        switch (jdbcTypeCode) {
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                if (this.getJavaType() != Boolean.class) break;
                return CastType.INTEGER_BOOLEAN;
            }
            case -15: 
            case 1: {
                if (this.getJavaType() != Boolean.class) break;
                return CastType.YN_BOOLEAN;
            }
            case 2014: {
                if (this.getJavaType() != ZonedDateTime.class) break;
                return CastType.ZONE_TIMESTAMP;
            }
        }
        return jdbcType.getCastType();
    }
}

