/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementHelper;
import org.hibernate.bytecode.internal.BytecodeEnhancementMetadataNonPojoImpl;
import org.hibernate.bytecode.internal.BytecodeEnhancementMetadataPojoImpl;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.Generator;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.GeneratorCreator;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.NonIdentifierAttribute;
import org.hibernate.tuple.PropertyFactory;
import org.hibernate.tuple.entity.CompositeGeneratorBuilder;
import org.hibernate.tuple.entity.VersionProperty;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;

@Deprecated(since="6", forRemoval=true)
public class EntityMetamodel
implements Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EntityMetamodel.class);
    public static final int NO_VERSION_INDX = -66;
    private final SessionFactoryImplementor sessionFactory;
    private final String name;
    private final String rootName;
    private EntityType entityType;
    private final int subclassId;
    private final IdentifierProperty identifierAttribute;
    private final boolean versioned;
    private final int propertySpan;
    private final int versionPropertyIndex;
    private final NonIdentifierAttribute[] properties;
    private final String[] propertyNames;
    private final Type[] propertyTypes;
    private final @Nullable Type[] dirtyCheckablePropertyTypes;
    private final boolean[] propertyLaziness;
    private final boolean[] propertyUpdateability;
    private final boolean[] nonlazyPropertyUpdateability;
    private final boolean[] propertyCheckability;
    private final boolean[] propertyInsertability;
    private final boolean[] propertyNullability;
    private final boolean[] propertyVersionability;
    private final CascadeStyle[] cascadeStyles;
    private final boolean hasPreInsertGeneratedValues;
    private final boolean hasPreUpdateGeneratedValues;
    private final boolean hasInsertGeneratedValues;
    private final boolean hasUpdateGeneratedValues;
    private final Generator[] generators;
    private final Map<String, Integer> propertyIndexes = new HashMap<String, Integer>();
    private final boolean hasCollections;
    private final boolean hasOwnedCollections;
    private final BitSet mutablePropertiesIndexes;
    private final boolean hasLazyProperties;
    private final boolean hasNonIdentifierPropertyNamedId;
    private final int[] naturalIdPropertyNumbers;
    private final boolean hasImmutableNaturalId;
    private final boolean hasCacheableNaturalId;
    private boolean lazy;
    private final boolean hasCascades;
    private final boolean hasCascadeDelete;
    private final boolean mutable;
    private final boolean isAbstract;
    private final boolean selectBeforeUpdate;
    private final boolean dynamicUpdate;
    private final boolean dynamicInsert;
    private final OptimisticLockStyle optimisticLockStyle;
    private final boolean polymorphic;
    private final String superclass;
    private final boolean inherited;
    private final boolean hasSubclasses;
    private final Set<String> subclassEntityNames;
    private final BeforeExecutionGenerator versionGenerator;
    private final BytecodeEnhancementMetadata bytecodeEnhancementMetadata;

    public EntityMetamodel(PersistentClass persistentClass, EntityPersister persister, RuntimeModelCreationContext creationContext) {
        this.sessionFactory = creationContext.getSessionFactory();
        this.name = persistentClass.getEntityName().intern();
        this.rootName = persistentClass.getRootClass().getEntityName().intern();
        this.name.hashCode();
        this.rootName.hashCode();
        this.subclassId = persistentClass.getSubclassId();
        Generator idgenerator = this.buildIdGenerator(persistentClass, creationContext);
        this.identifierAttribute = PropertyFactory.buildIdentifierAttribute(persistentClass, idgenerator);
        this.versioned = persistentClass.isVersioned();
        boolean collectionsInDefaultFetchGroupEnabled = creationContext.getSessionFactoryOptions().isCollectionsInDefaultFetchGroupEnabled();
        if (persistentClass.hasPojoRepresentation()) {
            HashSet<String> idAttributeNames;
            CompositeType nonAggregatedCidMapper;
            Component identifierMapperComponent = persistentClass.getIdentifierMapper();
            if (identifierMapperComponent != null) {
                nonAggregatedCidMapper = identifierMapperComponent.getType();
                idAttributeNames = new HashSet();
                for (Property property : identifierMapperComponent.getProperties()) {
                    idAttributeNames.add(property.getName());
                }
            } else {
                nonAggregatedCidMapper = null;
                idAttributeNames = Collections.singleton(this.identifierAttribute.getName());
            }
            this.bytecodeEnhancementMetadata = BytecodeEnhancementMetadataPojoImpl.from(persistentClass, idAttributeNames, nonAggregatedCidMapper, collectionsInDefaultFetchGroupEnabled, creationContext.getMetadata());
        } else {
            this.bytecodeEnhancementMetadata = new BytecodeEnhancementMetadataNonPojoImpl(persistentClass.getEntityName());
        }
        boolean hasLazy = false;
        this.propertySpan = persistentClass.getPropertyClosureSpan();
        this.properties = new NonIdentifierAttribute[this.propertySpan];
        ArrayList<Integer> naturalIdNumbers = new ArrayList<Integer>();
        this.propertyNames = new String[this.propertySpan];
        this.propertyTypes = new Type[this.propertySpan];
        this.dirtyCheckablePropertyTypes = new Type[this.propertySpan];
        this.propertyUpdateability = new boolean[this.propertySpan];
        this.propertyInsertability = new boolean[this.propertySpan];
        this.nonlazyPropertyUpdateability = new boolean[this.propertySpan];
        this.propertyCheckability = new boolean[this.propertySpan];
        this.propertyNullability = new boolean[this.propertySpan];
        this.propertyVersionability = new boolean[this.propertySpan];
        this.propertyLaziness = new boolean[this.propertySpan];
        this.cascadeStyles = new CascadeStyle[this.propertySpan];
        this.generators = new Generator[this.propertySpan];
        boolean foundPreInsertGeneratedValues = false;
        boolean foundPreUpdateGeneratedValues = false;
        boolean foundPostInsertGeneratedValues = false;
        boolean foundPostUpdateGeneratedValues = false;
        int tempVersionProperty = -66;
        boolean foundCascade = false;
        boolean foundCascadeDelete = false;
        boolean foundCollection = false;
        boolean foundOwnedCollection = false;
        BitSet mutableIndexes = new BitSet();
        boolean foundNonIdentifierPropertyNamedId = false;
        boolean foundUpdateableNaturalIdProperty = false;
        BeforeExecutionGenerator tempVersionGenerator = null;
        List<Property> props = persistentClass.getPropertyClosure();
        for (int i = 0; i < props.size(); ++i) {
            Type propertyType;
            boolean lazy;
            NonIdentifierAttribute attribute;
            Property property = props.get(i);
            if (property == persistentClass.getVersion()) {
                tempVersionProperty = i;
                attribute = PropertyFactory.buildVersionProperty(persister, this.sessionFactory, i, property, this.bytecodeEnhancementMetadata.isEnhancedForLazyLoading());
            } else {
                attribute = PropertyFactory.buildEntityBasedAttribute(persister, this.sessionFactory, i, property, this.bytecodeEnhancementMetadata.isEnhancedForLazyLoading(), creationContext);
            }
            this.properties[i] = attribute;
            if (property.isNaturalIdentifier()) {
                this.verifyNaturalIdProperty(property);
                naturalIdNumbers.add(i);
                if (property.isUpdateable()) {
                    foundUpdateableNaturalIdProperty = true;
                }
            }
            if ("id".equals(property.getName())) {
                foundNonIdentifierPropertyNamedId = true;
            }
            boolean bl = lazy = !EnhancementHelper.includeInBaseFetchGroup(property, this.bytecodeEnhancementMetadata.isEnhancedForLazyLoading(), entityName -> {
                MetadataImplementor metadata = creationContext.getMetadata();
                PersistentClass entityBinding = metadata.getEntityBinding(entityName);
                assert (entityBinding != null);
                return entityBinding.hasSubclasses();
            }, collectionsInDefaultFetchGroupEnabled);
            if (lazy) {
                hasLazy = true;
            }
            this.propertyLaziness[i] = lazy;
            this.propertyNames[i] = attribute.getName();
            this.propertyTypes[i] = propertyType = attribute.getType();
            if (attribute.isDirtyCheckable() && !(propertyType instanceof OneToOneType)) {
                this.dirtyCheckablePropertyTypes[i] = propertyType;
            }
            this.propertyNullability[i] = attribute.isNullable();
            this.propertyUpdateability[i] = attribute.isUpdateable();
            this.propertyInsertability[i] = attribute.isInsertable();
            this.propertyVersionability[i] = attribute.isVersionable();
            this.nonlazyPropertyUpdateability[i] = attribute.isUpdateable() && !lazy;
            this.propertyCheckability[i] = this.propertyUpdateability[i] || propertyType.isAssociationType() && ((AssociationType)propertyType).isAlwaysDirtyChecked();
            this.cascadeStyles[i] = attribute.getCascadeStyle();
            Generator generator = EntityMetamodel.buildGenerator(this.name, property, creationContext);
            if (generator != null) {
                boolean generatedOnExecution = generator.generatedOnExecution();
                if (i == tempVersionProperty && !generatedOnExecution) {
                    tempVersionGenerator = (BeforeExecutionGenerator)generator;
                } else {
                    this.generators[i] = generator;
                    boolean allowMutation = generator.allowMutation();
                    if (!allowMutation) {
                        this.propertyCheckability[i] = false;
                    }
                    if (generator.generatesOnInsert()) {
                        if (generatedOnExecution) {
                            this.propertyInsertability[i] = EntityMetamodel.writePropertyValue((OnExecutionGenerator)generator);
                        }
                        foundPostInsertGeneratedValues = foundPostInsertGeneratedValues || generator instanceof OnExecutionGenerator;
                        foundPreInsertGeneratedValues = foundPreInsertGeneratedValues || generator instanceof BeforeExecutionGenerator;
                    } else if (!allowMutation) {
                        this.propertyInsertability[i] = false;
                    }
                    if (generator.generatesOnUpdate()) {
                        if (generatedOnExecution) {
                            this.propertyUpdateability[i] = EntityMetamodel.writePropertyValue((OnExecutionGenerator)generator);
                        }
                        foundPostUpdateGeneratedValues = foundPostUpdateGeneratedValues || generator instanceof OnExecutionGenerator;
                        foundPreUpdateGeneratedValues = foundPreUpdateGeneratedValues || generator instanceof BeforeExecutionGenerator;
                    } else if (!allowMutation) {
                        this.propertyUpdateability[i] = false;
                    }
                }
            }
            if (attribute.isLazy()) {
                hasLazy = true;
            }
            if (this.cascadeStyles[i] != CascadeStyles.NONE) {
                foundCascade = true;
            }
            if (this.cascadeStyles[i].doCascade(CascadingActions.REMOVE)) {
                foundCascadeDelete = true;
            }
            if (EntityMetamodel.indicatesCollection(attribute.getType())) {
                foundCollection = true;
            }
            if (EntityMetamodel.indicatesOwnedCollection(attribute.getType(), creationContext.getMetadata())) {
                foundOwnedCollection = true;
            }
            if (propertyType.isMutable() && this.propertyCheckability[i] && !(propertyType instanceof ComponentType)) {
                mutableIndexes.set(i);
            }
            this.mapPropertyToIndex(property, i);
        }
        if (naturalIdNumbers.isEmpty()) {
            this.naturalIdPropertyNumbers = null;
            this.hasImmutableNaturalId = false;
            this.hasCacheableNaturalId = false;
        } else {
            this.naturalIdPropertyNumbers = ArrayHelper.toIntArray(naturalIdNumbers);
            this.hasImmutableNaturalId = !foundUpdateableNaturalIdProperty;
            this.hasCacheableNaturalId = persistentClass.getNaturalIdCacheRegionName() != null;
        }
        this.hasPreInsertGeneratedValues = foundPreInsertGeneratedValues;
        this.hasPreUpdateGeneratedValues = foundPreUpdateGeneratedValues;
        this.hasInsertGeneratedValues = foundPostInsertGeneratedValues;
        this.hasUpdateGeneratedValues = foundPostUpdateGeneratedValues;
        this.versionGenerator = tempVersionGenerator;
        this.hasCascades = foundCascade;
        this.hasCascadeDelete = foundCascadeDelete;
        this.hasNonIdentifierPropertyNamedId = foundNonIdentifierPropertyNamedId;
        this.versionPropertyIndex = tempVersionProperty;
        this.hasLazyProperties = hasLazy;
        if (this.hasLazyProperties) {
            LOG.lazyPropertyFetchingAvailable(this.name);
        }
        this.lazy = persistentClass.isLazy() && (!persistentClass.hasPojoRepresentation() || !ReflectHelper.isFinalClass(persistentClass.getProxyInterface())) || this.bytecodeEnhancementMetadata.isEnhancedForLazyLoading();
        this.mutable = persistentClass.isMutable();
        if (persistentClass.isAbstract() == null) {
            this.isAbstract = persistentClass.hasPojoRepresentation() && ReflectHelper.isAbstractClass(persistentClass.getMappedClass());
        } else {
            this.isAbstract = persistentClass.isAbstract();
            if (!this.isAbstract && persistentClass.hasPojoRepresentation() && ReflectHelper.isAbstractClass(persistentClass.getMappedClass())) {
                LOG.entityMappedAsNonAbstract(this.name);
            }
        }
        this.selectBeforeUpdate = persistentClass.hasSelectBeforeUpdate();
        this.dynamicUpdate = persistentClass.useDynamicUpdate() || this.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading() && this.getBytecodeEnhancementMetadata().getLazyAttributesMetadata().getFetchGroupNames().size() > 1;
        this.dynamicInsert = persistentClass.useDynamicInsert();
        this.polymorphic = persistentClass.isPolymorphic();
        this.inherited = persistentClass.isInherited();
        this.superclass = this.inherited ? persistentClass.getSuperclass().getEntityName() : null;
        this.hasSubclasses = persistentClass.hasSubclasses();
        this.optimisticLockStyle = persistentClass.getOptimisticLockStyle();
        boolean isAllOrDirty = this.optimisticLockStyle.isAllOrDirty();
        if (isAllOrDirty && !this.dynamicUpdate) {
            throw new MappingException("optimistic-lock=all|dirty requires dynamic-update=\"true\": " + this.name);
        }
        if (this.versionPropertyIndex != -66 && isAllOrDirty) {
            throw new MappingException("version and optimistic-lock=all|dirty are not a valid combination : " + this.name);
        }
        this.hasCollections = foundCollection;
        this.hasOwnedCollections = foundOwnedCollection;
        this.mutablePropertiesIndexes = mutableIndexes;
        LinkedHashSet<String> subclassEntityNamesLocal = new LinkedHashSet<String>();
        subclassEntityNamesLocal.add(this.name);
        for (Subclass subclass : persistentClass.getSubclasses()) {
            subclassEntityNamesLocal.add(subclass.getEntityName());
        }
        this.subclassEntityNames = CollectionHelper.toSmallSet(subclassEntityNamesLocal);
    }

    private static boolean writePropertyValue(OnExecutionGenerator generator) {
        boolean writePropertyValue = generator.writePropertyValue();
        return writePropertyValue;
    }

    private Generator buildIdGenerator(PersistentClass persistentClass, RuntimeModelCreationContext creationContext) {
        Generator existing = creationContext.getGenerators().get(this.rootName);
        if (existing != null) {
            return existing;
        }
        Generator idgenerator = persistentClass.getIdentifier().createGenerator(creationContext.getDialect(), persistentClass.getRootClass(), persistentClass.getIdentifierProperty(), creationContext.getGeneratorSettings());
        creationContext.getGenerators().put(this.rootName, idgenerator);
        return idgenerator;
    }

    private void verifyNaturalIdProperty(Property property) {
        Value value = property.getValue();
        if (value instanceof ManyToOne) {
            ManyToOne toOne = (ManyToOne)value;
            if (toOne.getNotFoundAction() == NotFoundAction.IGNORE) {
                throw new MappingException("Attribute marked as natural-id can not also be a not-found association - " + this.propertyName(property));
            }
        } else if (value instanceof Component) {
            Component component = (Component)value;
            for (Property componentProperty : component.getProperties()) {
                this.verifyNaturalIdProperty(componentProperty);
            }
        }
    }

    private String propertyName(Property property) {
        return this.getName() + "." + property.getName();
    }

    private static Generator buildGenerator(String entityName, Property mappingProperty, RuntimeModelCreationContext context) {
        Generator generator;
        GeneratorCreator generatorCreator = mappingProperty.getValueGeneratorCreator();
        if (generatorCreator != null && (generator = mappingProperty.createGenerator(context)).generatesSometimes()) {
            return generator;
        }
        Value value = mappingProperty.getValue();
        if (value instanceof Component) {
            Component component = (Component)value;
            CompositeGeneratorBuilder builder = new CompositeGeneratorBuilder(entityName, mappingProperty, context.getDialect());
            for (Property property : component.getProperties()) {
                builder.add(property.createGenerator(context));
            }
            return builder.build();
        }
        return null;
    }

    public Generator[] getGenerators() {
        return this.generators;
    }

    public BeforeExecutionGenerator getVersionGenerator() {
        return this.versionGenerator;
    }

    private void mapPropertyToIndex(Property property, int i) {
        this.propertyIndexes.put(property.getName(), i);
        Value value = property.getValue();
        if (value instanceof Component) {
            Component composite = (Component)value;
            for (Property subproperty : composite.getProperties()) {
                this.propertyIndexes.put(property.getName() + "." + subproperty.getName(), i);
            }
        }
    }

    public boolean isNaturalIdentifierInsertGenerated() {
        if (this.naturalIdPropertyNumbers.length == 0) {
            throw new IllegalStateException("entity does not have a natural id: " + this.name);
        }
        for (int i = 0; i < this.naturalIdPropertyNumbers.length; ++i) {
            Generator strategy = this.generators[this.naturalIdPropertyNumbers[i]];
            if (strategy == null || !strategy.generatesOnInsert() || !strategy.generatedOnExecution()) continue;
            return true;
        }
        return false;
    }

    public int[] getNaturalIdentifierProperties() {
        return this.naturalIdPropertyNumbers;
    }

    public boolean hasNaturalIdentifier() {
        return this.naturalIdPropertyNumbers != null;
    }

    public boolean isNaturalIdentifierCached() {
        return this.hasNaturalIdentifier() && this.hasCacheableNaturalId;
    }

    public boolean hasImmutableNaturalId() {
        return this.hasImmutableNaturalId;
    }

    public Set<String> getSubclassEntityNames() {
        return this.subclassEntityNames;
    }

    private static boolean indicatesCollection(Type type) {
        if (type instanceof CollectionType) {
            return true;
        }
        if (type.isComponentType()) {
            Type[] subtypes;
            for (Type subtype : subtypes = ((CompositeType)type).getSubtypes()) {
                if (!EntityMetamodel.indicatesCollection(subtype)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean indicatesOwnedCollection(Type type, MetadataImplementor metadata) {
        if (type instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)type;
            return !metadata.getCollectionBinding(collectionType.getRole()).isInverse();
        }
        if (type.isComponentType()) {
            CompositeType compositeType = (CompositeType)type;
            for (Type subtype : compositeType.getSubtypes()) {
                if (!EntityMetamodel.indicatesOwnedCollection(subtype, metadata)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public String getName() {
        return this.name;
    }

    public String getRootName() {
        return this.rootName;
    }

    public int getSubclassId() {
        return this.subclassId;
    }

    public EntityType getEntityType() {
        if (this.entityType == null) {
            this.entityType = new ManyToOneType(this.name, this.getSessionFactory().getTypeConfiguration());
        }
        return this.entityType;
    }

    public IdentifierProperty getIdentifierProperty() {
        return this.identifierAttribute;
    }

    public int getPropertySpan() {
        return this.propertySpan;
    }

    public int getVersionPropertyIndex() {
        return this.versionPropertyIndex;
    }

    public VersionProperty getVersionProperty() {
        if (-66 == this.versionPropertyIndex) {
            return null;
        }
        return (VersionProperty)this.properties[this.versionPropertyIndex];
    }

    public NonIdentifierAttribute[] getProperties() {
        return this.properties;
    }

    public int getPropertyIndex(String propertyName) {
        Integer index = this.getPropertyIndexOrNull(propertyName);
        if (index == null) {
            throw new HibernateException("Unable to resolve property: " + propertyName);
        }
        return index;
    }

    public Integer getPropertyIndexOrNull(String propertyName) {
        return this.propertyIndexes.get(propertyName);
    }

    public boolean hasCollections() {
        return this.hasCollections;
    }

    public boolean hasOwnedCollections() {
        return this.hasOwnedCollections;
    }

    public boolean hasMutableProperties() {
        return !this.mutablePropertiesIndexes.isEmpty();
    }

    public BitSet getMutablePropertiesIndexes() {
        return this.mutablePropertiesIndexes;
    }

    public boolean hasNonIdentifierPropertyNamedId() {
        return this.hasNonIdentifierPropertyNamedId;
    }

    public boolean hasLazyProperties() {
        return this.hasLazyProperties;
    }

    public boolean hasCascades() {
        return this.hasCascades;
    }

    public boolean hasCascadeDelete() {
        return this.hasCascadeDelete;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    public OptimisticLockStyle getOptimisticLockStyle() {
        return this.optimisticLockStyle;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    @Deprecated
    public boolean isExplicitPolymorphism() {
        return false;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean hasSubclasses() {
        return this.hasSubclasses;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public String toString() {
        return "EntityMetamodel(" + this.name + ":" + ArrayHelper.toString(this.properties) + ")";
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Type[] getPropertyTypes() {
        return this.propertyTypes;
    }

    public @Nullable Type[] getDirtyCheckablePropertyTypes() {
        return this.dirtyCheckablePropertyTypes;
    }

    public boolean[] getPropertyLaziness() {
        return this.propertyLaziness;
    }

    public boolean[] getPropertyUpdateability() {
        return this.propertyUpdateability;
    }

    public boolean[] getPropertyCheckability() {
        return this.propertyCheckability;
    }

    public boolean[] getNonlazyPropertyUpdateability() {
        return this.nonlazyPropertyUpdateability;
    }

    public boolean[] getPropertyInsertability() {
        return this.propertyInsertability;
    }

    public boolean[] getPropertyNullability() {
        return this.propertyNullability;
    }

    public boolean[] getPropertyVersionability() {
        return this.propertyVersionability;
    }

    public CascadeStyle[] getCascadeStyles() {
        return this.cascadeStyles;
    }

    public boolean hasPreInsertGeneratedValues() {
        return this.hasPreInsertGeneratedValues;
    }

    public boolean hasPreUpdateGeneratedValues() {
        return this.hasPreUpdateGeneratedValues;
    }

    public boolean hasInsertGeneratedValues() {
        return this.hasInsertGeneratedValues;
    }

    public boolean hasUpdateGeneratedValues() {
        return this.hasUpdateGeneratedValues;
    }

    public boolean isInstrumented() {
        return this.bytecodeEnhancementMetadata.isEnhancedForLazyLoading();
    }

    public BytecodeEnhancementMetadata getBytecodeEnhancementMetadata() {
        return this.bytecodeEnhancementMetadata;
    }
}

