/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.hibernate.Internal;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.EventTypeSets;
import org.hibernate.generator.Generator;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.tuple.entity.CompositeValueGenerationException;

@Internal
class CompositeGeneratorBuilder {
    private final String entityName;
    private final Property mappingProperty;
    private final Dialect dialect;
    private boolean hadBeforeExecutionGeneration;
    private boolean hadOnExecutionGeneration;
    private final List<Generator> generators = new ArrayList<Generator>();

    public CompositeGeneratorBuilder(String entityName, Property mappingProperty, Dialect dialect) {
        this.entityName = entityName;
        this.mappingProperty = mappingProperty;
        this.dialect = dialect;
    }

    public void add(Generator generator) {
        this.generators.add(generator);
        if (generator != null && generator.generatesSometimes()) {
            if (generator.generatedOnExecution()) {
                this.hadOnExecutionGeneration = true;
            } else {
                this.hadBeforeExecutionGeneration = true;
            }
        }
    }

    public Generator build() {
        if (this.hadBeforeExecutionGeneration && this.hadOnExecutionGeneration) {
            throw new CompositeValueGenerationException("Composite attribute contained both on-execution and before-execution generators: " + this.mappingProperty.getName());
        }
        if (this.hadBeforeExecutionGeneration) {
            return this.createCompositeBeforeExecutionGenerator();
        }
        if (this.hadOnExecutionGeneration) {
            return this.createCompositeOnExecutionGenerator();
        }
        return DummyGenerator.INSTANCE;
    }

    private OnExecutionGenerator createCompositeOnExecutionGenerator() {
        Component composite = (Component)this.mappingProperty.getValue();
        EnumSet<EventType> eventTypes = EnumSet.noneOf(EventType.class);
        boolean referenceColumns = false;
        boolean writable = false;
        boolean mutable = false;
        String[] columnValues = new String[composite.getColumnSpan()];
        int columnIndex = 0;
        List<Property> properties = composite.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            Property property = properties.get(i);
            OnExecutionGenerator generator = (OnExecutionGenerator)this.generators.get(i);
            if (generator == null) {
                throw new CompositeValueGenerationException("Property of on-execution generated embeddable is not generated: " + this.mappingProperty.getName() + "." + property.getName());
            }
            eventTypes.addAll(generator.getEventTypes());
            if (generator.referenceColumnsInSql(this.dialect)) {
                referenceColumns = true;
                String[] referencedColumnValues = generator.getReferencedColumnValues(this.dialect);
                if (referencedColumnValues != null) {
                    int span = property.getColumnSpan();
                    if (referencedColumnValues.length != span) {
                        throw new CompositeValueGenerationException("Mismatch between number of collected generated column values and number of columns for composite attribute: " + this.mappingProperty.getName() + "." + property.getName());
                    }
                    System.arraycopy(referencedColumnValues, 0, columnValues, columnIndex, span);
                    columnIndex += span;
                }
            }
            if (generator.writePropertyValue()) {
                writable = true;
            }
            if (!generator.allowMutation()) continue;
            mutable = true;
        }
        return new CompositeOnExecutionGenerator(eventTypes, referenceColumns, columnValues, writable, mutable);
    }

    private BeforeExecutionGenerator createCompositeBeforeExecutionGenerator() {
        Component composite = (Component)this.mappingProperty.getValue();
        EnumSet<EventType> eventTypes = EnumSet.noneOf(EventType.class);
        List<Property> properties = composite.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            Generator generator = this.generators.get(i);
            if (generator == null) continue;
            eventTypes.addAll(generator.getEventTypes());
        }
        return new CompositeBeforeExecutionGenerator(this.entityName, this.generators, this.mappingProperty, properties, eventTypes);
    }

    private record DummyGenerator() implements Generator
    {
        private static final Generator INSTANCE = new DummyGenerator();

        @Override
        public EnumSet<EventType> getEventTypes() {
            return EventTypeSets.NONE;
        }

        @Override
        public boolean generatedOnExecution() {
            return false;
        }

        @Override
        public boolean allowMutation() {
            return true;
        }

        @Override
        public boolean allowAssignedIdentifiers() {
            return true;
        }
    }

    private record CompositeOnExecutionGenerator(EnumSet<EventType> eventTypes, boolean referenceColumnsInSql, String[] columnValues, boolean writePropertyValue, boolean allowMutation) implements OnExecutionGenerator
    {
        @Override
        public boolean referenceColumnsInSql(Dialect dialect) {
            return this.referenceColumnsInSql;
        }

        @Override
        public String[] getReferencedColumnValues(Dialect dialect) {
            return this.columnValues;
        }

        @Override
        public EnumSet<EventType> getEventTypes() {
            return this.eventTypes;
        }
    }

    private record CompositeBeforeExecutionGenerator(String entityName, List<Generator> generators, Property mappingProperty, List<Property> properties, EnumSet<EventType> eventTypes) implements BeforeExecutionGenerator
    {
        @Override
        public EnumSet<EventType> getEventTypes() {
            return this.eventTypes;
        }

        @Override
        public Object generate(SharedSessionContractImplementor session, Object owner, Object currentValue, EventType eventType) {
            EntityPersister persister = session.getEntityPersister(this.entityName, owner);
            int index = persister.getPropertyIndex(this.mappingProperty.getName());
            EmbeddableMappingType descriptor = persister.getAttributeMapping(index).asEmbeddedAttributeMapping().getEmbeddableTypeDescriptor();
            int size = this.properties.size();
            if (currentValue == null) {
                Object[] generatedValues = new Object[size];
                for (int i = 0; i < size; ++i) {
                    Generator generator = this.generators.get(i);
                    if (generator == null) continue;
                    generatedValues[i] = ((BeforeExecutionGenerator)generator).generate(session, owner, null, eventType);
                }
                return descriptor.getRepresentationStrategy().getInstantiator().instantiate(() -> generatedValues, session.getFactory());
            }
            for (int i = 0; i < size; ++i) {
                Generator generator = this.generators.get(i);
                if (generator == null) continue;
                Object value = descriptor.getValue(currentValue, i);
                Object generatedValue = ((BeforeExecutionGenerator)generator).generate(session, owner, value, eventType);
                descriptor.setValue(currentValue, i, generatedValue);
            }
            return currentValue;
        }
    }
}

