/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema;

import java.util.Locale;
import java.util.Map;
import org.hibernate.internal.util.config.ConfigurationHelper;

public enum JdbcMetadaAccessStrategy {
    INDIVIDUALLY,
    GROUPED;


    public String toString() {
        return super.toString().toLowerCase(Locale.ROOT);
    }

    public static JdbcMetadaAccessStrategy interpretSetting(Map<String, Object> options) {
        if (options == null) {
            return JdbcMetadaAccessStrategy.interpretHbm2ddlSetting(null);
        }
        if (ConfigurationHelper.getBoolean("hibernate.synonyms", options)) {
            return INDIVIDUALLY;
        }
        return JdbcMetadaAccessStrategy.interpretHbm2ddlSetting(options.get("hibernate.hbm2ddl.jdbc_metadata_extraction_strategy"));
    }

    public static JdbcMetadaAccessStrategy interpretHbm2ddlSetting(Object value) {
        if (value == null) {
            return GROUPED;
        }
        String name = value.toString().trim();
        if (name.isEmpty()) {
            return GROUPED;
        }
        for (JdbcMetadaAccessStrategy strategy : JdbcMetadaAccessStrategy.values()) {
            if (!strategy.toString().equalsIgnoreCase(name)) continue;
            return strategy;
        }
        throw new IllegalArgumentException("Unrecognized 'hibernate.hbm2ddl.jdbc_metadata_extraction_strategy' value: '" + value + "'");
    }
}

