/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.select;

import jakarta.persistence.criteria.Nulls;
import org.hibernate.query.NullPrecedence;
import org.hibernate.query.SortDirection;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class SortSpecification
implements SqlAstNode {
    private final Expression sortExpression;
    private final SortDirection sortOrder;
    private final Nulls nullPrecedence;
    private final boolean ignoreCase;

    public SortSpecification(Expression sortExpression, SortDirection sortOrder) {
        this(sortExpression, sortOrder, Nulls.NONE, false);
    }

    public SortSpecification(Expression sortExpression, SortDirection sortOrder, Nulls nullPrecedence) {
        this(sortExpression, sortOrder, nullPrecedence, false);
    }

    @Deprecated
    public SortSpecification(Expression sortExpression, SortDirection sortOrder, NullPrecedence nullPrecedence) {
        this(sortExpression, sortOrder, nullPrecedence.getJpaValue());
    }

    public SortSpecification(Expression sortExpression, SortDirection sortOrder, Nulls nullPrecedence, boolean ignoreCase) {
        assert (sortExpression != null);
        assert (sortOrder != null);
        assert (nullPrecedence != null);
        this.sortExpression = sortExpression;
        this.sortOrder = sortOrder;
        this.nullPrecedence = nullPrecedence;
        this.ignoreCase = ignoreCase;
    }

    public Expression getSortExpression() {
        return this.sortExpression;
    }

    public SortDirection getSortOrder() {
        return this.sortOrder;
    }

    public Nulls getNullPrecedence() {
        return this.nullPrecedence;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitSortSpecification(this);
    }
}

