/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.internal.TypecheckUtil;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;

public class SqmBetweenPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression<?> expression;
    private final SqmExpression<?> lowerBound;
    private final SqmExpression<?> upperBound;

    public SqmBetweenPredicate(SqmExpression<?> expression, SqmExpression<?> lowerBound, SqmExpression<?> upperBound, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.expression = expression;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        TypecheckUtil.assertComparable(expression, lowerBound, nodeBuilder);
        TypecheckUtil.assertComparable(expression, upperBound, nodeBuilder);
        SqmExpressible expressibleType = QueryHelper.highestPrecedenceType(expression.getExpressible(), lowerBound.getExpressible(), upperBound.getExpressible());
        expression.applyInferableType(expressibleType);
        lowerBound.applyInferableType(expressibleType);
        upperBound.applyInferableType(expressibleType);
    }

    @Override
    public SqmBetweenPredicate copy(SqmCopyContext context) {
        SqmBetweenPredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmBetweenPredicate predicate = context.registerCopy(this, new SqmBetweenPredicate((SqmExpression<?>)this.expression.copy(context), (SqmExpression<?>)this.lowerBound.copy(context), (SqmExpression<?>)this.upperBound.copy(context), this.isNegated(), this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    public SqmExpression<?> getExpression() {
        return this.expression;
    }

    public SqmExpression<?> getLowerBound() {
        return this.lowerBound;
    }

    public SqmExpression<?> getUpperBound() {
        return this.upperBound;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitBetweenPredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.expression.appendHqlString(sb);
        if (this.isNegated()) {
            sb.append(" not");
        }
        sb.append(" between ");
        this.lowerBound.appendHqlString(sb);
        sb.append(" and ");
        this.upperBound.appendHqlString(sb);
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmBetweenPredicate(this.expression, this.lowerBound, this.upperBound, !this.isNegated(), this.nodeBuilder());
    }
}

