/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.from;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.EntityType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.query.criteria.JpaEntityJoin;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedEntityJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmSingularValuedJoin;
import org.hibernate.query.sqm.tree.domain.SqmTreatedEntityJoin;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.spi.NavigablePath;

public class SqmEntityJoin<L, R>
extends AbstractSqmJoin<L, R>
implements SqmSingularValuedJoin<L, R>,
JpaEntityJoin<L, R> {
    private final SqmRoot<L> sqmRoot;

    public SqmEntityJoin(EntityDomainType<R> joinedEntityDescriptor, String alias, SqmJoinType joinType, SqmRoot<L> sqmRoot) {
        this(SqmCreationHelper.buildRootNavigablePath(joinedEntityDescriptor.getHibernateEntityName(), alias), joinedEntityDescriptor, alias, joinType, sqmRoot);
    }

    protected SqmEntityJoin(NavigablePath navigablePath, EntityDomainType<R> joinedEntityDescriptor, String alias, SqmJoinType joinType, SqmRoot<L> sqmRoot) {
        super(navigablePath, joinedEntityDescriptor, sqmRoot, alias, joinType, sqmRoot.nodeBuilder());
        this.sqmRoot = sqmRoot;
    }

    public SqmEntityJoin(EntityType<R> entity, String alias, JoinType joinType, SqmRoot<L> root) {
        this((EntityDomainType)entity, alias, SqmJoinType.from(joinType), root);
    }

    @Override
    public boolean isImplicitlySelectable() {
        return true;
    }

    @Override
    public SqmEntityJoin<L, R> copy(SqmCopyContext context) {
        SqmEntityJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmEntityJoin<L, R> path = context.registerCopy(this, new SqmEntityJoin<L, R>(this.getNavigablePath(), this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), this.getRoot().copy(context)));
        this.copyTo(path, context);
        return path;
    }

    public SqmRoot<L> getRoot() {
        return this.sqmRoot;
    }

    @Override
    public SqmFrom<?, L> getParent() {
        return this.getRoot();
    }

    @Override
    public SqmRoot<?> findRoot() {
        return this.getRoot();
    }

    @Override
    public JoinType getJoinType() {
        return this.getSqmJoinType().getCorrespondingJpaJoinType();
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        return null;
    }

    @Override
    public EntityDomainType<R> getModel() {
        return (EntityDomainType)super.getModel();
    }

    @Override
    public SqmFrom<?, L> getLhs() {
        return null;
    }

    @Override
    public EntityDomainType<R> getReferencedPathSource() {
        return (EntityDomainType)super.getReferencedPathSource();
    }

    public String getEntityName() {
        return this.getReferencedPathSource().getHibernateEntityName();
    }

    @Override
    public SqmEntityJoin<L, R> on(JpaExpression<Boolean> restriction) {
        return (SqmEntityJoin)super.on((JpaExpression)restriction);
    }

    @Override
    public SqmEntityJoin<L, R> on(Expression<Boolean> restriction) {
        return (SqmEntityJoin)super.on((Expression)restriction);
    }

    @Override
    public SqmEntityJoin<L, R> on(JpaPredicate ... restrictions) {
        return (SqmEntityJoin)super.on(restrictions);
    }

    @Override
    public SqmEntityJoin<L, R> on(Predicate ... restrictions) {
        return (SqmEntityJoin)super.on(restrictions);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitQualifiedEntityJoin(this);
    }

    @Override
    public <S extends R> SqmTreatedEntityJoin<L, R, S> treatAs(Class<S> treatAsType) {
        return this.treatAs((EntityDomainType)this.nodeBuilder().getDomainModel().entity(treatAsType));
    }

    @Override
    public <S extends R> SqmTreatedEntityJoin<L, R, S> treatAs(EntityDomainType<S> treatAsType) {
        SqmTreatedEntityJoin treat = (SqmTreatedEntityJoin)this.findTreat(treatAsType, null);
        if (treat == null) {
            return this.addTreat(new SqmTreatedEntityJoin(this, treatAsType, null));
        }
        return treat;
    }

    @Override
    public <S extends R> SqmTreatedEntityJoin<L, R, S> treatAs(Class<S> treatJavaType, String alias) {
        throw new UnsupportedOperationException("Entity join treats can not be aliased");
    }

    @Override
    public <S extends R> SqmTreatedEntityJoin<L, R, S> treatAs(EntityDomainType<S> treatTarget, String alias) {
        throw new UnsupportedOperationException("Entity join treats can not be aliased");
    }

    @Override
    public <S extends R> SqmTreatedEntityJoin<L, R, S> treatAs(Class<S> treatJavaType, String alias, boolean fetched) {
        throw new UnsupportedOperationException("Entity join treats can not be aliased");
    }

    @Override
    public <S extends R> SqmTreatedEntityJoin<L, R, S> treatAs(EntityDomainType<S> treatTarget, String alias, boolean fetched) {
        throw new UnsupportedOperationException("Entity join treats can not be aliased");
    }

    @Override
    public PersistentAttribute<? super L, ?> getAttribute() {
        return null;
    }

    @Override
    public SqmCorrelatedEntityJoin<L, R> createCorrelation() {
        return new SqmCorrelatedEntityJoin(this);
    }

    public SqmEntityJoin<L, R> makeCopy(SqmCreationProcessingState creationProcessingState) {
        SqmPathRegistry pathRegistry = creationProcessingState.getPathRegistry();
        return new SqmEntityJoin<L, R>(this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), (SqmRoot)pathRegistry.findFromByPath(this.getRoot().getNavigablePath()));
    }
}

