/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.from;

import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.JoinType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.query.criteria.JpaCrossJoin;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedCrossJoin;
import org.hibernate.query.sqm.tree.domain.SqmTreatedCrossJoin;
import org.hibernate.query.sqm.tree.domain.SqmTreatedFrom;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicateCollection;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.spi.NavigablePath;

public class SqmCrossJoin<T>
extends AbstractSqmFrom<T, T>
implements JpaCrossJoin<T>,
SqmJoin<T, T> {
    private final SqmRoot<?> sqmRoot;
    private final SqmPredicateCollection sqmJoinPredicates;

    public SqmCrossJoin(EntityDomainType<T> joinedEntityDescriptor, String alias, SqmRoot<?> sqmRoot) {
        this(SqmCreationHelper.buildRootNavigablePath(joinedEntityDescriptor.getHibernateEntityName(), alias), joinedEntityDescriptor, alias, sqmRoot);
    }

    protected SqmCrossJoin(NavigablePath navigablePath, EntityDomainType<T> joinedEntityDescriptor, String alias, SqmRoot<?> sqmRoot) {
        super(navigablePath, joinedEntityDescriptor, sqmRoot, alias, sqmRoot.nodeBuilder());
        this.sqmRoot = sqmRoot;
        this.sqmJoinPredicates = new SqmWhereClause(this.nodeBuilder());
    }

    @Override
    public boolean isImplicitlySelectable() {
        return true;
    }

    public JoinType getJoinType() {
        return null;
    }

    @Override
    public SqmJoinType getSqmJoinType() {
        return SqmJoinType.CROSS;
    }

    @Override
    public SqmCrossJoin<T> copy(SqmCopyContext context) {
        SqmCrossJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmCrossJoin<T> path = context.registerCopy(this, new SqmCrossJoin<T>(this.getNavigablePath(), this.getReferencedPathSource(), this.getExplicitAlias(), (SqmRoot<?>)this.getRoot().copy(context)));
        this.copyTo(path, context);
        return path;
    }

    public SqmRoot<?> getRoot() {
        return this.sqmRoot;
    }

    @Override
    public SqmFrom<?, T> getLhs() {
        return null;
    }

    @Override
    public EntityDomainType<T> getReferencedPathSource() {
        return (EntityDomainType)super.getReferencedPathSource();
    }

    public String getEntityName() {
        return this.getReferencedPathSource().getHibernateEntityName();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitCrossJoin(this);
    }

    @Override
    public SqmRoot<?> findRoot() {
        return this.getRoot();
    }

    public SqmCorrelatedCrossJoin<T> createCorrelation() {
        return new SqmCorrelatedCrossJoin(this);
    }

    public SqmCrossJoin<T> makeCopy(SqmCreationProcessingState creationProcessingState) {
        SqmPathRegistry pathRegistry = creationProcessingState.getPathRegistry();
        return new SqmCrossJoin<T>(this.getReferencedPathSource(), this.getExplicitAlias(), (SqmRoot)pathRegistry.findFromByPath(this.getRoot().getNavigablePath()));
    }

    @Override
    public PersistentAttribute<? super T, ?> getAttribute() {
        return null;
    }

    @Override
    public SqmPredicate getJoinPredicate() {
        return this.sqmJoinPredicates.getPredicate();
    }

    @Override
    public void setJoinPredicate(SqmPredicate predicate) {
        this.sqmJoinPredicates.setPredicate(predicate);
    }

    public From<?, T> getParent() {
        return this.getLhs();
    }

    public <S extends T> SqmTreatedCrossJoin treatAs(Class<S> treatJavaType, String alias) {
        throw new UnsupportedOperationException("Cross join treats can not be aliased");
    }

    public <S extends T> SqmTreatedCrossJoin treatAs(EntityDomainType<S> treatTarget, String alias) {
        throw new UnsupportedOperationException("Cross join treats can not be aliased");
    }

    @Override
    public <S extends T> SqmTreatedFrom<T, T, S> treatAs(Class<S> treatJavaType, String alias, boolean fetch) {
        return null;
    }

    @Override
    public <S extends T> SqmTreatedFrom<T, T, S> treatAs(EntityDomainType<S> treatTarget, String alias, boolean fetch) {
        return null;
    }

    public <S extends T> SqmTreatedCrossJoin treatAs(Class<S> treatAsType) {
        return this.treatAs((Class)treatAsType, (String)null);
    }

    public <S extends T> SqmTreatedCrossJoin treatAs(EntityDomainType<S> treatAsType) {
        return this.treatAs((EntityDomainType)treatAsType, (String)null);
    }
}

