/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.criteria.JpaJsonQueryExpression;
import org.hibernate.query.criteria.JpaJsonQueryNode;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.AbstractSqmJsonPathExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonQueryEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryWrapMode;

@Incubating
public class SqmJsonQueryExpression
extends AbstractSqmJsonPathExpression<String>
implements JpaJsonQueryExpression {
    private JpaJsonQueryNode.WrapMode wrapMode = JpaJsonQueryNode.WrapMode.UNSPECIFIED;
    private JpaJsonQueryNode.ErrorBehavior errorBehavior = JpaJsonQueryNode.ErrorBehavior.UNSPECIFIED;
    private JpaJsonQueryNode.EmptyBehavior emptyBehavior = JpaJsonQueryNode.EmptyBehavior.UNSPECIFIED;

    public SqmJsonQueryExpression(SqmFunctionDescriptor descriptor, FunctionRenderer renderer, List<? extends SqmTypedNode<?>> arguments, @Nullable ReturnableType<String> impliedResultType, @Nullable ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
        super(descriptor, renderer, arguments, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name);
    }

    private SqmJsonQueryExpression(SqmFunctionDescriptor descriptor, FunctionRenderer renderer, List<? extends SqmTypedNode<?>> arguments, @Nullable ReturnableType<String> impliedResultType, @Nullable ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name, @Nullable Map<String, SqmExpression<?>> passingExpressions, JpaJsonQueryNode.WrapMode wrapMode, JpaJsonQueryNode.ErrorBehavior errorBehavior, JpaJsonQueryNode.EmptyBehavior emptyBehavior) {
        super(descriptor, renderer, arguments, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name, passingExpressions);
        this.wrapMode = wrapMode;
        this.errorBehavior = errorBehavior;
        this.emptyBehavior = emptyBehavior;
    }

    @Override
    public SqmJsonQueryExpression copy(SqmCopyContext context) {
        SqmJsonQueryExpression existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmNode> arguments = new ArrayList<SqmNode>(this.getArguments().size());
        for (SqmTypedNode<?> argument : this.getArguments()) {
            arguments.add(argument.copy(context));
        }
        return context.registerCopy(this, new SqmJsonQueryExpression(this.getFunctionDescriptor(), this.getFunctionRenderer(), arguments, this.getImpliedResultType(), this.getArgumentsValidator(), this.getReturnTypeResolver(), this.nodeBuilder(), this.getFunctionName(), this.copyPassingExpressions(context), this.wrapMode, this.errorBehavior, this.emptyBehavior));
    }

    @Override
    public JpaJsonQueryNode.WrapMode getWrapMode() {
        return this.wrapMode;
    }

    @Override
    public JpaJsonQueryNode.ErrorBehavior getErrorBehavior() {
        return this.errorBehavior;
    }

    @Override
    public JpaJsonQueryNode.EmptyBehavior getEmptyBehavior() {
        return this.emptyBehavior;
    }

    @Override
    public SqmJsonQueryExpression withoutWrapper() {
        this.wrapMode = JpaJsonQueryNode.WrapMode.WITHOUT_WRAPPER;
        return this;
    }

    @Override
    public SqmJsonQueryExpression withWrapper() {
        this.wrapMode = JpaJsonQueryNode.WrapMode.WITH_WRAPPER;
        return this;
    }

    @Override
    public SqmJsonQueryExpression withConditionalWrapper() {
        this.wrapMode = JpaJsonQueryNode.WrapMode.WITH_CONDITIONAL_WRAPPER;
        return this;
    }

    @Override
    public SqmJsonQueryExpression unspecifiedWrapper() {
        this.wrapMode = JpaJsonQueryNode.WrapMode.UNSPECIFIED;
        return this;
    }

    @Override
    public SqmJsonQueryExpression unspecifiedOnError() {
        this.errorBehavior = JpaJsonQueryNode.ErrorBehavior.UNSPECIFIED;
        return this;
    }

    @Override
    public SqmJsonQueryExpression errorOnError() {
        this.errorBehavior = JpaJsonQueryNode.ErrorBehavior.ERROR;
        return this;
    }

    @Override
    public SqmJsonQueryExpression nullOnError() {
        this.errorBehavior = JpaJsonQueryNode.ErrorBehavior.NULL;
        return this;
    }

    @Override
    public SqmJsonQueryExpression emptyArrayOnError() {
        this.errorBehavior = JpaJsonQueryNode.ErrorBehavior.EMPTY_ARRAY;
        return this;
    }

    @Override
    public SqmJsonQueryExpression emptyObjectOnError() {
        this.errorBehavior = JpaJsonQueryNode.ErrorBehavior.EMPTY_OBJECT;
        return this;
    }

    @Override
    public SqmJsonQueryExpression unspecifiedOnEmpty() {
        this.errorBehavior = JpaJsonQueryNode.ErrorBehavior.UNSPECIFIED;
        return this;
    }

    @Override
    public SqmJsonQueryExpression errorOnEmpty() {
        this.emptyBehavior = JpaJsonQueryNode.EmptyBehavior.ERROR;
        return this;
    }

    @Override
    public SqmJsonQueryExpression nullOnEmpty() {
        this.emptyBehavior = JpaJsonQueryNode.EmptyBehavior.NULL;
        return this;
    }

    @Override
    public SqmJsonQueryExpression emptyArrayOnEmpty() {
        this.emptyBehavior = JpaJsonQueryNode.EmptyBehavior.EMPTY_ARRAY;
        return this;
    }

    @Override
    public SqmJsonQueryExpression emptyObjectOnEmpty() {
        this.emptyBehavior = JpaJsonQueryNode.EmptyBehavior.EMPTY_OBJECT;
        return this;
    }

    @Override
    public SqmJsonQueryExpression passing(String parameterName, jakarta.persistence.criteria.Expression<?> expression) {
        this.addPassingExpression(parameterName, (SqmExpression)expression);
        return this;
    }

    @Override
    public Expression convertToSqlAst(SqmToSqlAstConverter walker) {
        JsonPathPassingClause jsonPathPassingClause;
        @Nullable ReturnableType<?> resultType = this.resolveResultType(walker);
        List<SqlAstNode> arguments = this.resolveSqlAstArguments(this.getArguments(), walker);
        ArgumentsValidator validator = this.getArgumentsValidator();
        if (validator != null) {
            validator.validateSqlTypes(arguments, this.getFunctionName());
        }
        if ((jsonPathPassingClause = this.createJsonPathPassingClause(walker)) != null) {
            arguments.add(jsonPathPassingClause);
        }
        switch (this.wrapMode) {
            case WITH_WRAPPER: {
                arguments.add(JsonQueryWrapMode.WITH_WRAPPER);
                break;
            }
            case WITHOUT_WRAPPER: {
                arguments.add(JsonQueryWrapMode.WITHOUT_WRAPPER);
                break;
            }
            case WITH_CONDITIONAL_WRAPPER: {
                arguments.add(JsonQueryWrapMode.WITH_CONDITIONAL_WRAPPER);
            }
        }
        switch (this.errorBehavior) {
            case NULL: {
                arguments.add(JsonQueryErrorBehavior.NULL);
                break;
            }
            case ERROR: {
                arguments.add(JsonQueryErrorBehavior.ERROR);
                break;
            }
            case EMPTY_OBJECT: {
                arguments.add(JsonQueryErrorBehavior.EMPTY_OBJECT);
                break;
            }
            case EMPTY_ARRAY: {
                arguments.add(JsonQueryErrorBehavior.EMPTY_ARRAY);
            }
        }
        switch (this.emptyBehavior) {
            case NULL: {
                arguments.add(JsonQueryEmptyBehavior.NULL);
                break;
            }
            case ERROR: {
                arguments.add(JsonQueryEmptyBehavior.ERROR);
                break;
            }
            case EMPTY_OBJECT: {
                arguments.add(JsonQueryEmptyBehavior.EMPTY_OBJECT);
                break;
            }
            case EMPTY_ARRAY: {
                arguments.add(JsonQueryEmptyBehavior.EMPTY_ARRAY);
            }
        }
        return new SelfRenderingFunctionSqlAstExpression(this.getFunctionName(), this.getFunctionRenderer(), arguments, resultType, resultType == null ? null : this.getMappingModelExpressible(walker, resultType, arguments));
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("json_query(");
        this.getArguments().get(0).appendHqlString(sb);
        sb.append(',');
        this.getArguments().get(1).appendHqlString(sb);
        this.appendPassingExpressionHqlString(sb);
        switch (this.wrapMode) {
            case WITH_WRAPPER: {
                sb.append(" with wrapper");
                break;
            }
            case WITHOUT_WRAPPER: {
                sb.append(" without wrapper");
                break;
            }
            case WITH_CONDITIONAL_WRAPPER: {
                sb.append(" with conditional wrapper");
            }
        }
        switch (this.errorBehavior) {
            case NULL: {
                sb.append(" null on error");
                break;
            }
            case ERROR: {
                sb.append(" error on error");
                break;
            }
            case EMPTY_ARRAY: {
                sb.append(" empty array on error");
                break;
            }
            case EMPTY_OBJECT: {
                sb.append(" empty object on error");
            }
        }
        switch (this.emptyBehavior) {
            case NULL: {
                sb.append(" null on empty");
                break;
            }
            case ERROR: {
                sb.append(" error on empty");
                break;
            }
            case EMPTY_ARRAY: {
                sb.append(" empty array on empty");
                break;
            }
            case EMPTY_OBJECT: {
                sb.append(" empty object on empty");
            }
        }
        sb.append(')');
    }
}

