/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import org.hibernate.metamodel.model.domain.internal.EmbeddedSqmPathSource;
import org.hibernate.query.BindableType;
import org.hibernate.query.BindingContext;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.descriptor.java.JdbcDateJavaType;
import org.hibernate.type.descriptor.java.JdbcTimeJavaType;
import org.hibernate.type.descriptor.java.JdbcTimestampJavaType;

public class SqmExpressionHelper {
    public static <T> SqmExpressible<T> toSqmType(BindableType<T> parameterType, SqmCreationState creationState) {
        return SqmExpressionHelper.toSqmType(parameterType, creationState.getCreationContext());
    }

    public static <T> SqmExpressible<T> toSqmType(BindableType<T> anticipatedType, BindingContext bindingContext) {
        if (anticipatedType == null) {
            return null;
        }
        SqmExpressible<T> sqmExpressible = anticipatedType.resolveExpressible(bindingContext);
        assert (sqmExpressible != null);
        return sqmExpressible;
    }

    public static SqmLiteral<Timestamp> timestampLiteralFrom(String literalText, SqmCreationState creationState) {
        Timestamp literal = Timestamp.valueOf(LocalDateTime.from(JdbcTimestampJavaType.LITERAL_FORMATTER.parse(literalText)));
        return new SqmLiteral<Timestamp>(literal, creationState.getCreationContext().getTypeConfiguration().standardBasicTypeForJavaType(Timestamp.class), creationState.getCreationContext().getNodeBuilder());
    }

    public static SqmLiteral<Integer> integerLiteral(String literalText, SqmCreationState creationState) {
        return SqmExpressionHelper.integerLiteral(literalText, creationState.getCreationContext().getQueryEngine());
    }

    public static SqmLiteral<Integer> integerLiteral(String literalText, QueryEngine queryEngine) {
        return SqmExpressionHelper.integerLiteral(Integer.parseInt(literalText), queryEngine);
    }

    public static SqmLiteral<Integer> integerLiteral(int value, QueryEngine queryEngine) {
        return new SqmLiteral<Integer>(value, queryEngine.getCriteriaBuilder().getIntegerType(), queryEngine.getCriteriaBuilder());
    }

    public static SqmLiteral<Date> dateLiteralFrom(String literalText, SqmCreationState creationState) {
        LocalDate localDate = LocalDate.from(JdbcDateJavaType.LITERAL_FORMATTER.parse(literalText));
        Date literal = new Date(localDate.toEpochDay());
        return new SqmLiteral<Date>(literal, creationState.getCreationContext().getTypeConfiguration().standardBasicTypeForJavaType(Date.class), creationState.getCreationContext().getNodeBuilder());
    }

    public static SqmLiteral<Time> timeLiteralFrom(String literalText, SqmCreationState creationState) {
        LocalTime localTime = LocalTime.from(JdbcTimeJavaType.LITERAL_FORMATTER.parse(literalText));
        Time literal = Time.valueOf(localTime);
        return new SqmLiteral<Time>(literal, creationState.getCreationContext().getTypeConfiguration().standardBasicTypeForJavaType(Time.class), creationState.getCreationContext().getNodeBuilder());
    }

    public static boolean isCompositeTemporal(SqmExpression<?> expression) {
        return expression instanceof SqmPath && expression.getNodeType() instanceof EmbeddedSqmPathSource && JavaTypeHelper.isTemporal(expression.getJavaTypeDescriptor());
    }

    public static SqmExpression<?> getActualExpression(SqmExpression<?> expression) {
        if (SqmExpressionHelper.isCompositeTemporal(expression)) {
            if (expression.getJavaTypeDescriptor().getJavaTypeClass() == OffsetTime.class) {
                return ((SqmPath)expression).get("utcTime");
            }
            return ((SqmPath)expression).get("instant");
        }
        return expression;
    }

    public static SqmExpression<?> getOffsetAdjustedExpression(SqmExpression<?> expression) {
        if (SqmExpressionHelper.isCompositeTemporal(expression)) {
            SqmPath compositePath = (SqmPath)expression;
            JpaPath temporalPath = expression.getJavaTypeDescriptor().getJavaTypeClass() == OffsetTime.class ? compositePath.get("utcTime") : compositePath.get("instant");
            NodeBuilder nodeBuilder = temporalPath.nodeBuilder();
            return new SqmBinaryArithmetic(BinaryArithmeticOperator.ADD, (SqmExpression<?>)((Object)temporalPath), (SqmExpression<?>)new SqmToDuration<Duration>((SqmExpression<?>)((Object)compositePath.get("zoneOffset")), new SqmDurationUnit<Integer>(TemporalUnit.SECOND, nodeBuilder.getIntegerType(), nodeBuilder), (ReturnableType<Duration>)nodeBuilder.getTypeConfiguration().getBasicTypeForJavaType(Duration.class), nodeBuilder), temporalPath.getNodeType(), nodeBuilder);
        }
        return expression;
    }

    public static SqmPath<?> findPath(SqmExpression<?> expression, SqmExpressible<?> nodeType) {
        if (nodeType != expression.getNodeType()) {
            return null;
        }
        if (expression instanceof SqmPath) {
            return (SqmPath)expression;
        }
        if (expression instanceof SqmBinaryArithmetic) {
            SqmBinaryArithmetic binaryArithmetic = (SqmBinaryArithmetic)expression;
            SqmPath<?> lhs = SqmExpressionHelper.findPath(binaryArithmetic.getLeftHandOperand(), nodeType);
            if (lhs != null) {
                return lhs;
            }
            SqmPath<?> rhs = SqmExpressionHelper.findPath(binaryArithmetic.getRightHandOperand(), nodeType);
            return rhs;
        }
        return null;
    }
}

