/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedFrom;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedRoot
extends SqmRoot
implements SqmTreatedFrom {
    private final SqmRoot wrappedPath;
    private final EntityDomainType treatTarget;

    public SqmTreatedRoot(SqmRoot wrappedPath, EntityDomainType treatTarget) {
        super(wrappedPath.getNavigablePath().treatAs(treatTarget.getHibernateEntityName()), (EntityDomainType)wrappedPath.getReferencedPathSource(), (String)null, (NodeBuilder)wrappedPath.nodeBuilder());
        this.wrappedPath = wrappedPath;
        this.treatTarget = treatTarget;
    }

    private SqmTreatedRoot(NavigablePath navigablePath, SqmRoot wrappedPath, EntityDomainType treatTarget) {
        super(navigablePath, (EntityDomainType)wrappedPath.getReferencedPathSource(), (String)null, (NodeBuilder)wrappedPath.nodeBuilder());
        this.wrappedPath = wrappedPath;
        this.treatTarget = treatTarget;
    }

    @Override
    public SqmTreatedRoot copy(SqmCopyContext context) {
        SqmTreatedRoot existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedRoot path = context.registerCopy(this, new SqmTreatedRoot(this.getNavigablePath(), (SqmRoot)this.wrappedPath.copy(context), this.treatTarget));
        this.copyTo(path, context);
        return path;
    }

    public EntityDomainType getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public EntityDomainType getManagedType() {
        return this.getTreatTarget();
    }

    @Override
    public SqmPath getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public SqmPathSource getNodeType() {
        return this.treatTarget;
    }

    public EntityDomainType getReferencedPathSource() {
        return this.getTreatTarget();
    }

    @Override
    public SqmPath<?> getLhs() {
        return this.wrappedPath.getLhs();
    }

    public Object accept(SemanticQueryWalker walker) {
        return walker.visitTreatedPath(this);
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        SqmPath sqmPath = this.get(name, true);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register(sqmPath);
        return sqmPath;
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("treat(");
        this.wrappedPath.appendHqlString(sb);
        sb.append(" as ");
        sb.append(this.treatTarget.getName());
        sb.append(')');
    }
}

