/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedEntityJoin<L, R, S extends R>
extends SqmEntityJoin<L, S>
implements SqmTreatedJoin<L, R, S> {
    private final SqmEntityJoin<L, R> wrappedPath;
    private final EntityDomainType<S> treatTarget;

    public SqmTreatedEntityJoin(SqmEntityJoin<L, R> wrappedPath, EntityDomainType<S> treatTarget, String alias) {
        super(wrappedPath.getNavigablePath().treatAs(treatTarget.getHibernateEntityName(), alias), treatTarget, alias, wrappedPath.getSqmJoinType(), wrappedPath.getRoot());
        this.wrappedPath = wrappedPath;
        this.treatTarget = treatTarget;
    }

    private SqmTreatedEntityJoin(NavigablePath navigablePath, SqmEntityJoin<L, R> wrappedPath, EntityDomainType<S> treatTarget, String alias) {
        super(navigablePath, treatTarget, alias, wrappedPath.getSqmJoinType(), wrappedPath.getRoot());
        this.wrappedPath = wrappedPath;
        this.treatTarget = treatTarget;
    }

    @Override
    public SqmTreatedEntityJoin<L, R, S> copy(SqmCopyContext context) {
        SqmTreatedEntityJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedEntityJoin<L, R, S> path = context.registerCopy(this, new SqmTreatedEntityJoin<L, R, S>(this.getNavigablePath(), this.wrappedPath.copy(context), this.treatTarget, this.getExplicitAlias()));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public EntityDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public EntityDomainType<S> getModel() {
        return this.getTreatTarget();
    }

    @Override
    public SqmPath<R> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public SqmPathSource<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public EntityDomainType<S> getReferencedPathSource() {
        return this.treatTarget;
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("treat(");
        this.wrappedPath.appendHqlString(sb);
        sb.append(" as ");
        sb.append(this.treatTarget.getName());
        sb.append(')');
    }
}

