/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedEmbeddedValuedSimplePath<T, S extends T>
extends SqmEmbeddedValuedSimplePath<S>
implements SqmTreatedPath<T, S> {
    private final SqmPath<T> wrappedPath;
    private final EmbeddableDomainType<S> treatTarget;

    public SqmTreatedEmbeddedValuedSimplePath(SqmPath<T> wrappedPath, EmbeddableDomainType<S> treatTarget) {
        super(wrappedPath.getNavigablePath().treatAs(treatTarget.getTypeName()), wrappedPath.getReferencedPathSource(), null, wrappedPath.nodeBuilder());
        this.wrappedPath = wrappedPath;
        this.treatTarget = treatTarget;
    }

    private SqmTreatedEmbeddedValuedSimplePath(NavigablePath navigablePath, SqmPath<T> wrappedPath, EmbeddableDomainType<S> treatTarget) {
        super(navigablePath, wrappedPath.getReferencedPathSource(), null, wrappedPath.nodeBuilder());
        this.wrappedPath = wrappedPath;
        this.treatTarget = treatTarget;
    }

    @Override
    public SqmTreatedEmbeddedValuedSimplePath<T, S> copy(SqmCopyContext context) {
        SqmTreatedEmbeddedValuedSimplePath existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedEmbeddedValuedSimplePath<T, S> path = context.registerCopy(this, new SqmTreatedEmbeddedValuedSimplePath<T, S>(this.getNavigablePath(), this.wrappedPath.copy(context), this.treatTarget));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public EmbeddableDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmPath<T> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public SqmPathSource<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<?> getResolvedModel() {
        return this.treatTarget;
    }

    @Override
    public EmbeddableDomainType<S> getReferencedPathSource() {
        return this.getTreatTarget();
    }

    @Override
    public SqmPath<?> getLhs() {
        return this.wrappedPath.getLhs();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitTreatedPath(this);
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        SqmPath sqmPath = this.get(name, true);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register(sqmPath);
        return sqmPath;
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("treat(");
        this.wrappedPath.appendHqlString(sb);
        sb.append(" as ");
        sb.append(this.treatTarget.getTypeName());
        sb.append(')');
    }
}

