/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.List;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSpecificPluralPartPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmElementAggregateFunction<T>
extends AbstractSqmSpecificPluralPartPath<T> {
    private final String functionName;
    private final ReturnableType<T> returnableType;

    public SqmElementAggregateFunction(SqmPath<?> pluralDomainPath, String functionName) {
        super(pluralDomainPath.getNavigablePath().getParent().append(pluralDomainPath.getNavigablePath().getLocalName(), "{" + functionName + "-element}"), pluralDomainPath, (PluralPersistentAttribute)pluralDomainPath.getReferencedPathSource(), ((PluralPersistentAttribute)pluralDomainPath.getReferencedPathSource()).getElementPathSource());
        this.functionName = functionName;
        switch (functionName) {
            case "sum": {
                this.returnableType = this.nodeBuilder().getSumReturnTypeResolver().resolveFunctionReturnType(null, (SqmToSqlAstConverter)null, List.of(pluralDomainPath), this.nodeBuilder().getTypeConfiguration());
                break;
            }
            case "avg": {
                this.returnableType = this.nodeBuilder().getAvgReturnTypeResolver().resolveFunctionReturnType(null, (SqmToSqlAstConverter)null, List.of(pluralDomainPath), this.nodeBuilder().getTypeConfiguration());
                break;
            }
            default: {
                this.returnableType = null;
            }
        }
    }

    @Override
    public SqmExpressible<T> getExpressible() {
        return this.returnableType == null ? super.getExpressible() : this.returnableType;
    }

    @Override
    public JavaType<T> getJavaTypeDescriptor() {
        return this.returnableType == null ? super.getJavaTypeDescriptor() : this.returnableType.getExpressibleJavaType();
    }

    @Override
    public JavaType<T> getNodeJavaType() {
        return this.returnableType == null ? super.getNodeJavaType() : this.returnableType.getExpressibleJavaType();
    }

    @Override
    public SqmElementAggregateFunction<T> copy(SqmCopyContext context) {
        SqmElementAggregateFunction existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmElementAggregateFunction<T> path = context.registerCopy(this, new SqmElementAggregateFunction<T>((SqmPath<?>)this.getLhs().copy(context), this.functionName));
        this.copyTo(path, context);
        return path;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        SqmPath sqmPath = this.get(name, true);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register(sqmPath);
        return sqmPath;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitElementAggregateFunction(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append(this.functionName).append("(");
        this.getLhs().appendHqlString(sb);
        sb.append(')');
    }
}

