/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree;

import org.hibernate.query.common.JoinType;
import org.hibernate.sql.ast.SqlAstJoinType;

public enum SqmJoinType {
    INNER,
    LEFT,
    RIGHT,
    CROSS,
    FULL;


    public String toString() {
        return this.getText();
    }

    public String getText() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case RIGHT -> "right outer";
            case LEFT -> "left outer";
            case INNER -> "inner";
            case FULL -> "full";
            case CROSS -> "cross";
        };
    }

    public SqlAstJoinType getCorrespondingSqlJoinType() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case RIGHT -> SqlAstJoinType.RIGHT;
            case LEFT -> SqlAstJoinType.LEFT;
            case INNER -> SqlAstJoinType.INNER;
            case FULL -> SqlAstJoinType.FULL;
            case CROSS -> SqlAstJoinType.CROSS;
        };
    }

    public jakarta.persistence.criteria.JoinType getCorrespondingJpaJoinType() {
        return switch (this) {
            case RIGHT -> jakarta.persistence.criteria.JoinType.RIGHT;
            case LEFT -> jakarta.persistence.criteria.JoinType.LEFT;
            case INNER -> jakarta.persistence.criteria.JoinType.INNER;
            default -> null;
        };
    }

    public JoinType getCorrespondingJoinType() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case RIGHT -> JoinType.RIGHT;
            case LEFT -> JoinType.LEFT;
            case INNER -> JoinType.INNER;
            case FULL -> JoinType.FULL;
            case CROSS -> JoinType.CROSS;
        };
    }

    public static SqmJoinType from(JoinType joinType) {
        return switch (joinType) {
            default -> throw new IncompatibleClassChangeError();
            case JoinType.INNER -> INNER;
            case JoinType.LEFT -> LEFT;
            case JoinType.RIGHT -> RIGHT;
            case JoinType.CROSS -> CROSS;
            case JoinType.FULL -> FULL;
        };
    }

    public static SqmJoinType from(jakarta.persistence.criteria.JoinType jpaJoinType) {
        return switch (jpaJoinType) {
            default -> throw new IncompatibleClassChangeError();
            case jakarta.persistence.criteria.JoinType.INNER -> INNER;
            case jakarta.persistence.criteria.JoinType.LEFT -> LEFT;
            case jakarta.persistence.criteria.JoinType.RIGHT -> RIGHT;
        };
    }
}

