/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;

@Incubating
public class NamedSqmSetReturningFunctionDescriptor
extends AbstractSqmSelfRenderingSetReturningFunctionDescriptor {
    private final String functionName;
    private final String argumentListSignature;
    private final SqlAstNodeRenderingMode argumentRenderingMode;

    public NamedSqmSetReturningFunctionDescriptor(String functionName, @Nullable ArgumentsValidator argumentsValidator, SetReturningFunctionTypeResolver returnTypeResolver, @Nullable FunctionArgumentTypeResolver argumentTypeResolver, String name, String argumentListSignature, SqlAstNodeRenderingMode argumentRenderingMode) {
        super(name, argumentsValidator, returnTypeResolver, argumentTypeResolver);
        this.functionName = functionName;
        this.argumentListSignature = argumentListSignature;
        this.argumentRenderingMode = argumentRenderingMode;
    }

    @Override
    public String getName() {
        return this.functionName;
    }

    @Override
    public String getArgumentListSignature() {
        return this.argumentListSignature == null ? super.getArgumentListSignature() : this.argumentListSignature;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, AnonymousTupleTableGroupProducer returnType, String tableIdentifierVariable, SqlAstTranslator<?> translator) {
        translator.renderNamedSetReturningFunction(this.functionName, sqlAstArguments, returnType, tableIdentifierVariable, this.argumentRenderingMode);
    }

    public String toString() {
        return String.format(Locale.ROOT, "NamedSqmSetReturningFunctionTemplate(%s)", this.functionName);
    }
}

