/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.function.SqmSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;

@Incubating
public abstract class AbstractSqmSetReturningFunctionDescriptor
implements SqmSetReturningFunctionDescriptor {
    private final ArgumentsValidator argumentsValidator;
    private final SetReturningFunctionTypeResolver setReturningTypeResolver;
    private final FunctionArgumentTypeResolver functionArgumentTypeResolver;
    private final String name;

    public AbstractSqmSetReturningFunctionDescriptor(String name, SetReturningFunctionTypeResolver typeResolver) {
        this(name, null, typeResolver, null);
    }

    public AbstractSqmSetReturningFunctionDescriptor(String name, @Nullable ArgumentsValidator argumentsValidator, SetReturningFunctionTypeResolver typeResolver) {
        this(name, argumentsValidator, typeResolver, null);
    }

    public AbstractSqmSetReturningFunctionDescriptor(String name, @Nullable ArgumentsValidator argumentsValidator, SetReturningFunctionTypeResolver typeResolver, @Nullable FunctionArgumentTypeResolver argumentTypeResolver) {
        this.name = name;
        this.argumentsValidator = argumentsValidator == null ? StandardArgumentsValidators.NONE : argumentsValidator;
        this.setReturningTypeResolver = typeResolver;
        this.functionArgumentTypeResolver = argumentTypeResolver == null ? StandardFunctionArgumentTypeResolvers.NULL : argumentTypeResolver;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getSignature(String name) {
        return name + this.getArgumentListSignature();
    }

    @Override
    public ArgumentsValidator getArgumentsValidator() {
        return this.argumentsValidator;
    }

    public SetReturningFunctionTypeResolver getSetReturningTypeResolver() {
        return this.setReturningTypeResolver;
    }

    public FunctionArgumentTypeResolver getArgumentTypeResolver() {
        return this.functionArgumentTypeResolver;
    }

    public String getArgumentListSignature() {
        return this.argumentsValidator.getSignature();
    }

    @Override
    public final <T> SelfRenderingSqmSetReturningFunction<T> generateSqmExpression(List<? extends SqmTypedNode<?>> arguments, QueryEngine queryEngine) {
        this.argumentsValidator.validate(arguments, this.getName(), queryEngine.getTypeConfiguration());
        return this.generateSqmSetReturningFunctionExpression(arguments, queryEngine);
    }

    protected abstract <T> SelfRenderingSqmSetReturningFunction<T> generateSqmSetReturningFunctionExpression(List<? extends SqmTypedNode<?>> var1, QueryEngine var2);
}

