/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import jakarta.persistence.TemporalType;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.hibernate.query.BindableType;
import org.hibernate.query.BindingContext;
import org.hibernate.query.QueryArgumentException;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.type.descriptor.java.JavaType;

public class QueryParameterBindingValidator {
    public static final QueryParameterBindingValidator INSTANCE = new QueryParameterBindingValidator();

    private QueryParameterBindingValidator() {
    }

    public void validate(BindableType<?> paramType, Object bind, BindingContext bindingContext) {
        this.validate(paramType, bind, null, bindingContext);
    }

    public void validate(BindableType<?> paramType, Object bind, TemporalType temporalPrecision, BindingContext bindingContext) {
        if (bind == null || paramType == null) {
            return;
        }
        SqmExpressible<?> sqmExpressible = paramType.resolveExpressible(bindingContext);
        Class<Object> parameterJavaType = paramType.getBindableJavaType() != null ? paramType.getBindableJavaType() : sqmExpressible.getBindableJavaType();
        if (parameterJavaType == null) {
            return;
        }
        if (bind instanceof Collection && !Collection.class.isAssignableFrom(parameterJavaType)) {
            this.validateCollectionValuedParameterBinding(parameterJavaType, (Collection)bind, temporalPrecision);
        } else if (bind.getClass().isArray()) {
            this.validateArrayValuedParameterBinding(parameterJavaType, bind, temporalPrecision);
        } else if (!QueryParameterBindingValidator.isValidBindValue(sqmExpressible.getExpressibleJavaType(), parameterJavaType, bind, temporalPrecision)) {
            throw new QueryArgumentException(String.format("Argument [%s] of type [%s] did not match parameter type [%s (%s)]", bind, bind.getClass().getName(), parameterJavaType.getName(), this.extractName(temporalPrecision)), parameterJavaType, bind);
        }
    }

    private String extractName(TemporalType temporalType) {
        return temporalType == null ? "n/a" : temporalType.name();
    }

    private void validateCollectionValuedParameterBinding(Class<?> parameterType, Collection<?> value, TemporalType temporalType) {
        for (Object element : value) {
            if (QueryParameterBindingValidator.isValidBindValue(parameterType, element, temporalType)) continue;
            throw new QueryArgumentException(String.format("Parameter value element [%s] did not match expected type [%s (%s)]", element, parameterType.getName(), this.extractName(temporalType)), parameterType, element);
        }
    }

    private static boolean isValidBindValue(JavaType<?> expectedJavaType, Class<?> expectedType, Object value, TemporalType temporalType) {
        if (value == null) {
            return true;
        }
        if (expectedJavaType.isInstance(value)) {
            return true;
        }
        if (temporalType != null) {
            boolean parameterDeclarationIsTemporal = Date.class.isAssignableFrom(expectedType) || Calendar.class.isAssignableFrom(expectedType);
            boolean bindIsTemporal = value instanceof Date || value instanceof Calendar;
            return parameterDeclarationIsTemporal && bindIsTemporal;
        }
        return false;
    }

    private static boolean isValidBindValue(Class<?> expectedType, Object value, TemporalType temporalType) {
        if (expectedType.isPrimitive()) {
            if (expectedType == Boolean.TYPE) {
                return value instanceof Boolean;
            }
            if (expectedType == Character.TYPE) {
                return value instanceof Character;
            }
            if (expectedType == Byte.TYPE) {
                return value instanceof Byte;
            }
            if (expectedType == Short.TYPE) {
                return value instanceof Short;
            }
            if (expectedType == Integer.TYPE) {
                return value instanceof Integer;
            }
            if (expectedType == Long.TYPE) {
                return value instanceof Long;
            }
            if (expectedType == Float.TYPE) {
                return value instanceof Float;
            }
            if (expectedType == Double.TYPE) {
                return value instanceof Double;
            }
            return false;
        }
        if (value == null) {
            return true;
        }
        if (expectedType.isInstance(value)) {
            return true;
        }
        if (temporalType != null) {
            boolean parameterDeclarationIsTemporal = Date.class.isAssignableFrom(expectedType) || Calendar.class.isAssignableFrom(expectedType);
            boolean bindIsTemporal = value instanceof Date || value instanceof Calendar;
            return parameterDeclarationIsTemporal && bindIsTemporal;
        }
        return false;
    }

    private void validateArrayValuedParameterBinding(Class<?> parameterType, Object value, TemporalType temporalType) {
        if (!parameterType.isArray()) {
            throw new QueryArgumentException(String.format("Encountered array-valued parameter binding, but was expecting [%s (%s)]", parameterType.getName(), this.extractName(temporalType)), parameterType, value);
        }
        if (value.getClass().getComponentType().isPrimitive()) {
            if (!parameterType.getComponentType().isAssignableFrom(value.getClass().getComponentType())) {
                throw new QueryArgumentException(String.format("Primitive array-valued parameter bind value type [%s] did not match expected type [%s (%s)]", value.getClass().getComponentType().getName(), parameterType.getName(), this.extractName(temporalType)), parameterType, value);
            }
        } else {
            Object[] array;
            for (Object element : array = (Object[])value) {
                if (QueryParameterBindingValidator.isValidBindValue(parameterType.getComponentType(), element, temporalType)) continue;
                throw new QueryArgumentException(String.format("Array-valued parameter value element [%s] did not match expected type [%s (%s)]", element, parameterType.getName(), this.extractName(temporalType)), parameterType, array);
            }
        }
    }
}

