/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.internal.DomainPathPart;
import org.hibernate.query.hql.spi.DotIdentifierConsumer;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmEnumLiteral;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmFieldLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEmbeddableType;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;

public class BasicDotIdentifierConsumer
implements DotIdentifierConsumer {
    private final SqmCreationState creationState;
    private final StringBuilder pathSoFar = new StringBuilder();
    private SemanticPathPart currentPart;

    public BasicDotIdentifierConsumer(SqmCreationState creationState) {
        this.creationState = creationState;
    }

    public BasicDotIdentifierConsumer(SemanticPathPart initialState, SqmCreationState creationState) {
        this.currentPart = initialState;
        this.creationState = creationState;
    }

    protected SqmCreationState getCreationState() {
        return this.creationState;
    }

    @Override
    public SemanticPathPart getConsumedPart() {
        return this.currentPart;
    }

    @Override
    public void consumeIdentifier(String identifier, boolean isBase, boolean isTerminal) {
        if (isBase) {
            this.reset();
        }
        if (!this.pathSoFar.isEmpty()) {
            this.pathSoFar.append('.');
        }
        this.pathSoFar.append(identifier);
        HqlLogging.QUERY_LOGGER.tracef("BasicDotIdentifierHandler#consumeIdentifier( %s, %s, %s ) - %s", new Object[]{identifier, isBase, isTerminal, this.pathSoFar});
        this.currentPart = this.currentPart.resolvePathPart(identifier, isTerminal, this.creationState);
    }

    @Override
    public void consumeTreat(String importableName, boolean isTerminal) {
        SqmPath sqmPath = (SqmPath)this.currentPart;
        this.currentPart = sqmPath.treatAs(this.treatTarget(importableName));
    }

    private <T> Class<T> treatTarget(String typeName) {
        ManagedDomainType managedType = this.creationState.getCreationContext().getJpaMetamodel().managedType(typeName);
        return managedType.getJavaType();
    }

    protected void reset() {
        this.pathSoFar.setLength(0);
        this.currentPart = this.createBasePart();
    }

    protected SemanticPathPart createBasePart() {
        return new BaseLocalSequencePart();
    }

    public class BaseLocalSequencePart
    implements SemanticPathPart {
        private boolean isBase = true;

        @Override
        public SemanticPathPart resolvePathPart(String identifier, boolean isTerminal, SqmCreationState creationState) {
            SqmFunctionDescriptor functionDescriptor;
            HqlLogging.QUERY_LOGGER.tracef("BaseLocalSequencePart#consumeIdentifier( %s, %s, %s ) - %s", new Object[]{identifier, this.isBase, isTerminal, BasicDotIdentifierConsumer.this.pathSoFar});
            if (this.isBase) {
                this.isBase = false;
                SqmPathRegistry sqmPathRegistry = creationState.getProcessingStateStack().getCurrent().getPathRegistry();
                Object pathRootByAlias = sqmPathRegistry.findFromByAlias(identifier, true);
                if (pathRootByAlias != null) {
                    this.validateAsRoot((SqmFrom<?, ?>)pathRootByAlias);
                    return isTerminal ? pathRootByAlias : new DomainPathPart((SqmPath<?>)pathRootByAlias);
                }
                Object pathRootByExposedNavigable = sqmPathRegistry.findFromExposing(identifier);
                if (pathRootByExposedNavigable != null) {
                    this.validateAsRoot((SqmFrom<?, ?>)pathRootByExposedNavigable);
                    SqmPath sqmPath = pathRootByExposedNavigable.get(identifier, true);
                    return isTerminal ? sqmPath : new DomainPathPart(sqmPath);
                }
            }
            if (!isTerminal) {
                return this;
            }
            SqmCreationContext creationContext = creationState.getCreationContext();
            JpaMetamodel jpaMetamodel = creationContext.getJpaMetamodel();
            String path = BasicDotIdentifierConsumer.this.pathSoFar.toString();
            String importableName = jpaMetamodel.qualifyImportableName(path);
            NodeBuilder nodeBuilder = creationContext.getNodeBuilder();
            if (importableName != null) {
                ManagedDomainType managedType = jpaMetamodel.managedType(importableName);
                if (managedType instanceof EntityDomainType) {
                    EntityDomainType entityDomainType = (EntityDomainType)managedType;
                    return new SqmLiteralEntityType(entityDomainType, nodeBuilder);
                }
                if (managedType instanceof EmbeddableDomainType) {
                    EmbeddableDomainType embeddableDomainType = (EmbeddableDomainType)managedType;
                    return new SqmLiteralEmbeddableType(embeddableDomainType, nodeBuilder);
                }
            }
            if ((functionDescriptor = creationContext.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor(path)) != null) {
                return functionDescriptor.generateSqmExpression(null, creationContext.getQueryEngine());
            }
            int splitPosition = path.lastIndexOf(46);
            if (splitPosition > 0) {
                String prefix = path.substring(0, splitPosition);
                String terminal = path.substring(splitPosition + 1);
                try {
                    EnumJavaType<?> enumType = jpaMetamodel.getEnumType(prefix);
                    if (enumType != null) {
                        return BaseLocalSequencePart.sqmEnumLiteral(jpaMetamodel, enumType, terminal, nodeBuilder);
                    }
                    JavaType<?> fieldJtdTest = jpaMetamodel.getJavaConstantType(prefix, terminal);
                    if (fieldJtdTest != null) {
                        return BaseLocalSequencePart.sqmFieldLiteral(jpaMetamodel, prefix, terminal, fieldJtdTest, nodeBuilder);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new SemanticException("Could not interpret path expression '" + path + "'");
        }

        private static <E> SqmFieldLiteral<E> sqmFieldLiteral(JpaMetamodel jpaMetamodel, String prefix, String terminal, JavaType<E> fieldJtdTest, NodeBuilder nodeBuilder) {
            return new SqmFieldLiteral(jpaMetamodel.getJavaConstant(prefix, terminal), fieldJtdTest, terminal, nodeBuilder);
        }

        private static <E extends Enum<E>> SqmEnumLiteral<E> sqmEnumLiteral(JpaMetamodel jpaMetamodel, EnumJavaType<E> enumType, String terminal, NodeBuilder nodeBuilder) {
            return new SqmEnumLiteral<E>(jpaMetamodel.enumValue(enumType, terminal), enumType, terminal, nodeBuilder);
        }

        protected void validateAsRoot(SqmFrom<?, ?> pathRoot) {
        }

        @Override
        public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState processingState) {
            return BasicDotIdentifierConsumer.this.currentPart.resolveIndexedAccess(selector, isTerminal, processingState);
        }
    }
}

