/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.derived;

import java.util.function.BiConsumer;
import org.hibernate.Incubating;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.OwnedValuedModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaType;

@Incubating
public class AnonymousTupleBasicValuedModelPart
implements OwnedValuedModelPart,
MappingType,
BasicValuedModelPart {
    private static final FetchOptions FETCH_OPTIONS = FetchOptions.valueOf(FetchTiming.IMMEDIATE, FetchStyle.JOIN);
    private final MappingType declaringType;
    private final String partName;
    private final SelectableMapping selectableMapping;
    private final SqmExpressible<?> expressible;
    private final int fetchableIndex;

    public AnonymousTupleBasicValuedModelPart(MappingType declaringType, String partName, String selectionExpression, SqmExpressible<?> expressible, JdbcMapping jdbcMapping, int fetchableIndex) {
        this(declaringType, partName, new SelectableMappingImpl("", selectionExpression, new SelectablePath(partName), null, null, null, null, null, null, null, false, true, false, false, false, false, jdbcMapping), expressible, fetchableIndex);
    }

    public AnonymousTupleBasicValuedModelPart(MappingType declaringType, String partName, SelectableMapping selectableMapping, SqmExpressible<?> expressible, int fetchableIndex) {
        this.declaringType = declaringType;
        this.partName = partName;
        this.selectableMapping = selectableMapping;
        this.expressible = expressible;
        this.fetchableIndex = fetchableIndex;
    }

    @Override
    public MappingType getPartMappingType() {
        return this;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.expressible.getExpressibleJavaType();
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.expressible.getExpressibleJavaType();
    }

    @Override
    public MappingType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public String getPartName() {
        return this.partName;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return null;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return null;
    }

    @Override
    public String getSelectableName() {
        return this.selectableMapping.getSelectableName();
    }

    @Override
    public SelectablePath getSelectablePath() {
        return this.selectableMapping.getSelectablePath();
    }

    @Override
    public String getWriteExpression() {
        return this.selectableMapping.getWriteExpression();
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.selectableMapping.getJdbcMapping();
    }

    @Override
    public String getContainingTableExpression() {
        return this.selectableMapping.getContainingTableExpression();
    }

    @Override
    public String getSelectionExpression() {
        return this.selectableMapping.getSelectionExpression();
    }

    @Override
    public String getCustomReadExpression() {
        return this.selectableMapping.getCustomReadExpression();
    }

    @Override
    public String getCustomWriteExpression() {
        return this.selectableMapping.getCustomWriteExpression();
    }

    @Override
    public boolean isFormula() {
        return this.selectableMapping.isFormula();
    }

    @Override
    public boolean isNullable() {
        return this.selectableMapping.isNullable();
    }

    @Override
    public boolean isInsertable() {
        return this.selectableMapping.isInsertable();
    }

    @Override
    public boolean isUpdateable() {
        return this.selectableMapping.isUpdateable();
    }

    @Override
    public boolean isPartitioned() {
        return this.selectableMapping.isPartitioned();
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return this.selectableMapping.isPartitioned();
    }

    @Override
    public String getColumnDefinition() {
        return this.selectableMapping.getColumnDefinition();
    }

    @Override
    public Long getLength() {
        return this.selectableMapping.getLength();
    }

    @Override
    public Integer getPrecision() {
        return this.selectableMapping.getPrecision();
    }

    @Override
    public Integer getScale() {
        return this.selectableMapping.getScale();
    }

    @Override
    public Integer getTemporalPrecision() {
        return this.selectableMapping.getTemporalPrecision();
    }

    @Override
    public MappingType getMappedType() {
        return this;
    }

    @Override
    public String getFetchableName() {
        return this.partName;
    }

    @Override
    public int getFetchableKey() {
        return this.fetchableIndex;
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return FETCH_OPTIONS;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(navigablePath, tableGroup, null, creationState.getSqlAstCreationState());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.getJdbcMapping(), navigablePath, false, !sqlSelection.isVirtual());
    }

    private SqlSelection resolveSqlSelection(NavigablePath navigablePath, TableGroup tableGroup, FetchParent fetchParent, SqlAstCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(navigablePath, this, this.getContainingTableExpression());
        Expression expression = expressionResolver.resolveSqlExpression(tableReference, this);
        return expressionResolver.resolveSqlSelection(expression, this.getJdbcMapping().getJdbcJavaType(), fetchParent, creationState.getCreationContext().getSessionFactory().getTypeConfiguration());
    }

    @Override
    public BasicFetch<?> generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        assert (tableGroup != null);
        SqlSelection sqlSelection = this.resolveSqlSelection(fetchablePath, tableGroup, fetchParent, creationState.getSqlAstCreationState());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, fetchTiming, creationState, !sqlSelection.isVirtual());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(navigablePath, tableGroup, null, creationState.getSqlAstCreationState());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        selectionConsumer.accept(this.resolveSqlSelection(navigablePath, tableGroup, null, creationState.getSqlAstCreationState()), this.getJdbcMapping());
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(offset, x, y, domainValue, this);
        return this.getJdbcTypeCount();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            return;
        }
        cacheKey.addValue(value);
        cacheKey.addHashCode(this.getExpressibleJavaType().extractHashCode(value));
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this);
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(IndexedConsumer<JdbcMapping> action) {
        action.accept(0, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }
}

