/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.hibernate.Incubating;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionContract;
import org.hibernate.query.QueryProducer;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaCteCriteria;
import org.hibernate.query.criteria.JpaDerivedRoot;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaFunctionRoot;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.criteria.JpaSetReturningFunction;
import org.hibernate.query.criteria.JpaSubQuery;
import org.hibernate.query.criteria.spi.HibernateCriteriaBuilderDelegate;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;

@Incubating
public abstract class CriteriaDefinition<R>
extends HibernateCriteriaBuilderDelegate
implements JpaCriteriaQuery<R> {
    private final JpaCriteriaQuery<R> query;

    public CriteriaDefinition(CriteriaDefinition<R> template) {
        super(template.getCriteriaBuilder());
        this.query = ((SqmSelectStatement)template.query).copy(SqmCopyContext.simpleContext());
    }

    public CriteriaDefinition(CriteriaDefinition<?> template, Class<R> resultType) {
        super(template.getCriteriaBuilder());
        this.query = ((SqmSelectStatement)template.query).createCopy(SqmCopyContext.simpleContext(), resultType);
    }

    public CriteriaDefinition(SessionFactory factory, Class<R> resultType) {
        super(factory.getCriteriaBuilder());
        this.query = this.createQuery((Class)resultType);
    }

    public CriteriaDefinition(SessionFactory factory, Class<R> resultType, String baseHql) {
        super(factory.getCriteriaBuilder());
        this.query = this.createQuery(baseHql, resultType);
    }

    public CriteriaDefinition(SessionFactory factory, CriteriaQuery<R> baseQuery) {
        super(factory.getCriteriaBuilder());
        this.query = (JpaCriteriaQuery)baseQuery;
    }

    public CriteriaDefinition(EntityManagerFactory factory, Class<R> resultType) {
        super(factory.getCriteriaBuilder());
        this.query = this.createQuery((Class)resultType);
    }

    public CriteriaDefinition(EntityManagerFactory factory, Class<R> resultType, String baseHql) {
        super(factory.getCriteriaBuilder());
        this.query = this.createQuery(baseHql, resultType);
    }

    public CriteriaDefinition(EntityManagerFactory factory, CriteriaQuery<R> baseQuery) {
        super(factory.getCriteriaBuilder());
        this.query = (JpaCriteriaQuery)baseQuery;
    }

    public CriteriaDefinition(SharedSessionContract session, Class<R> resultType) {
        this(session.getFactory(), resultType);
    }

    public CriteriaDefinition(SharedSessionContract session, Class<R> resultType, String baseHql) {
        this(session.getFactory(), resultType, baseHql);
    }

    public CriteriaDefinition(SharedSessionContract session, CriteriaQuery<R> baseQuery) {
        this(session.getFactory(), baseQuery);
    }

    public CriteriaDefinition(EntityManager entityManager, Class<R> resultType) {
        this(entityManager.getEntityManagerFactory(), resultType);
    }

    public CriteriaDefinition(EntityManager entityManager, Class<R> resultType, String baseHql) {
        this(entityManager.getEntityManagerFactory(), resultType, baseHql);
    }

    public CriteriaDefinition(EntityManager entityManager, CriteriaQuery<R> baseQuery) {
        this(entityManager.getEntityManagerFactory(), baseQuery);
    }

    public SelectionQuery<R> createSelectionQuery(QueryProducer session) {
        return session.createQuery(this.query);
    }

    public TypedQuery<R> createQuery(EntityManager entityManager) {
        return entityManager.createQuery(this.query);
    }

    @Incubating
    public JpaCriteriaQuery<R> restrict(Predicate predicate) {
        JpaPredicate existing = this.getRestriction();
        return existing == null ? this.where((Expression)predicate) : this.where(new Predicate[]{existing, predicate});
    }

    @Override
    public JpaCriteriaQuery<R> select(Selection<? extends R> selection) {
        return this.query.select((Selection)selection);
    }

    @Override
    public JpaCriteriaQuery<R> multiselect(Selection<?> ... selections) {
        return this.query.multiselect((Selection[])selections);
    }

    @Override
    public JpaCriteriaQuery<R> multiselect(List<Selection<?>> list) {
        return this.query.multiselect((List)list);
    }

    @Override
    public JpaCriteriaQuery<R> where(Expression<Boolean> restriction) {
        return this.query.where((Expression)restriction);
    }

    @Override
    public JpaCriteriaQuery<R> where(Predicate ... restrictions) {
        return this.query.where(restrictions);
    }

    @Override
    public JpaCriteriaQuery<R> groupBy(Expression ... grouping) {
        return this.query.groupBy(grouping);
    }

    @Override
    public JpaCriteriaQuery<R> groupBy(List<Expression<?>> grouping) {
        return this.query.groupBy((List)grouping);
    }

    @Override
    public JpaCriteriaQuery<R> having(Expression<Boolean> restriction) {
        return this.query.having((Expression)restriction);
    }

    @Override
    public JpaCriteriaQuery<R> having(Predicate ... restrictions) {
        return this.query.having(restrictions);
    }

    @Override
    public JpaCriteriaQuery<R> orderBy(Order ... o) {
        return this.query.orderBy(o);
    }

    @Override
    public JpaCriteriaQuery<R> orderBy(List<Order> o) {
        return this.query.orderBy((List)o);
    }

    @Override
    public JpaCriteriaQuery<R> distinct(boolean distinct) {
        return this.query.distinct(distinct);
    }

    @Override
    public List<Order> getOrderList() {
        return this.query.getOrderList();
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        return this.query.getParameters();
    }

    @Override
    public <X> JpaRoot<X> from(Class<X> entityClass) {
        return this.query.from((Class)entityClass);
    }

    @Override
    public <X> JpaRoot<X> from(EntityType<X> entity) {
        return this.query.from((EntityType)entity);
    }

    @Override
    public <U> JpaSubQuery<U> subquery(Class<U> type) {
        return this.query.subquery(type);
    }

    public Set<Root<?>> getRoots() {
        return this.query.getRoots();
    }

    @Override
    public JpaSelection<R> getSelection() {
        return this.query.getSelection();
    }

    public List<Expression<?>> getGroupList() {
        return this.query.getGroupList();
    }

    @Override
    public JpaPredicate getGroupRestriction() {
        return this.query.getGroupRestriction();
    }

    public boolean isDistinct() {
        return this.query.isDistinct();
    }

    public Class<R> getResultType() {
        return this.query.getResultType();
    }

    @Override
    public JpaPredicate getRestriction() {
        return this.query.getRestriction();
    }

    @Override
    public JpaCriteriaQuery<R> where(List<Predicate> restrictions) {
        return this.query.where((List)restrictions);
    }

    @Override
    public JpaCriteriaQuery<R> having(List<Predicate> restrictions) {
        return this.query.having((List)restrictions);
    }

    @Override
    public <U> JpaSubQuery<U> subquery(EntityType<U> type) {
        return this.query.subquery((EntityType)type);
    }

    @Override
    public JpaExpression<Number> getOffset() {
        return this.query.getOffset();
    }

    @Override
    public JpaCriteriaQuery<R> offset(JpaExpression<? extends Number> offset) {
        return this.query.offset(offset);
    }

    @Override
    public JpaCriteriaQuery<R> offset(Number offset) {
        return this.query.offset(offset);
    }

    @Override
    public JpaExpression<Number> getFetch() {
        return this.query.getFetch();
    }

    @Override
    public JpaCriteriaQuery<R> fetch(JpaExpression<? extends Number> fetch) {
        return this.query.fetch(fetch);
    }

    @Override
    public JpaCriteriaQuery<R> fetch(JpaExpression<? extends Number> fetch, FetchClauseType fetchClauseType) {
        return this.query.fetch(fetch, fetchClauseType);
    }

    @Override
    public JpaCriteriaQuery<R> fetch(Number fetch) {
        return this.query.fetch(fetch);
    }

    @Override
    public JpaCriteriaQuery<R> fetch(Number fetch, FetchClauseType fetchClauseType) {
        return this.query.fetch(fetch, fetchClauseType);
    }

    @Override
    public FetchClauseType getFetchClauseType() {
        return this.query.getFetchClauseType();
    }

    @Override
    public List<Root<?>> getRootList() {
        return this.query.getRootList();
    }

    @Override
    public Collection<? extends JpaCteCriteria<?>> getCteCriterias() {
        return this.query.getCteCriterias();
    }

    @Override
    public <T> JpaCteCriteria<T> getCteCriteria(String cteName) {
        return this.query.getCteCriteria(cteName);
    }

    @Override
    public <T> JpaCteCriteria<T> with(AbstractQuery<T> criteria) {
        return this.query.with(criteria);
    }

    @Override
    public <T> JpaCteCriteria<T> withRecursiveUnionAll(AbstractQuery<T> baseCriteria, Function<JpaCteCriteria<T>, AbstractQuery<T>> recursiveCriteriaProducer) {
        return this.query.withRecursiveUnionAll(baseCriteria, recursiveCriteriaProducer);
    }

    @Override
    public <T> JpaCteCriteria<T> withRecursiveUnionDistinct(AbstractQuery<T> baseCriteria, Function<JpaCteCriteria<T>, AbstractQuery<T>> recursiveCriteriaProducer) {
        return this.query.withRecursiveUnionDistinct(baseCriteria, recursiveCriteriaProducer);
    }

    @Override
    public <T> JpaCteCriteria<T> with(String name, AbstractQuery<T> criteria) {
        return this.query.with(name, criteria);
    }

    @Override
    public <T> JpaCteCriteria<T> withRecursiveUnionAll(String name, AbstractQuery<T> baseCriteria, Function<JpaCteCriteria<T>, AbstractQuery<T>> recursiveCriteriaProducer) {
        return this.query.withRecursiveUnionAll(name, baseCriteria, recursiveCriteriaProducer);
    }

    @Override
    public <T> JpaCteCriteria<T> withRecursiveUnionDistinct(String name, AbstractQuery<T> baseCriteria, Function<JpaCteCriteria<T>, AbstractQuery<T>> recursiveCriteriaProducer) {
        return this.query.withRecursiveUnionDistinct(name, baseCriteria, recursiveCriteriaProducer);
    }

    @Override
    public JpaQueryStructure<R> getQuerySpec() {
        return this.query.getQuerySpec();
    }

    @Override
    public JpaQueryPart<R> getQueryPart() {
        return this.query.getQueryPart();
    }

    @Override
    public <X> JpaDerivedRoot<X> from(Subquery<X> subquery) {
        return this.query.from(subquery);
    }

    @Override
    public <X> JpaRoot<X> from(JpaCteCriteria<X> cte) {
        return this.query.from(cte);
    }

    @Override
    public <X> JpaFunctionRoot<X> from(JpaSetReturningFunction<X> function) {
        return this.query.from(function);
    }

    @Override
    public JpaCriteriaQuery<Long> createCountQuery() {
        return this.query.createCountQuery();
    }
}

