/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.cache.spi.entry.CacheEntryStructure;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.EntityEntryFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.MergeContext;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.generator.internal.VersionGeneration;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.TableGroupFilterAliasGenerator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoader;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.persister.entity.DiscriminatorMetadata;
import org.hibernate.persister.entity.UniqueKeyEntry;
import org.hibernate.persister.entity.mutation.DeleteCoordinator;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.persister.entity.mutation.InsertCoordinator;
import org.hibernate.persister.entity.mutation.UpdateCoordinator;
import org.hibernate.persister.walking.spi.AttributeSource;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.tree.from.RootTableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.VersionJavaType;

public interface EntityPersister
extends EntityMappingType,
EntityMutationTarget,
RootTableGroupProducer,
AttributeSource {
    @Deprecated(since="6.2")
    public static final String ENTITY_ID = "id";

    public void postInstantiate() throws MappingException;

    default public void prepareLoaders() {
    }

    public SessionFactoryImplementor getFactory();

    @Override
    default public String getSqlAliasStem() {
        return SqlAliasStemHelper.INSTANCE.generateStemFromEntityName(this.getEntityName());
    }

    public EntityEntryFactory getEntityEntryFactory();

    public String getRootEntityName();

    @Override
    public String getEntityName();

    public @Nullable String getJpaEntityName();

    @Override
    default public String getImportedName() {
        return this.getJpaEntityName() != null ? this.getJpaEntityName() : StringHelper.unqualifyEntityName(this.getEntityName());
    }

    @Override
    public SqmMultiTableMutationStrategy getSqmMultiTableMutationStrategy();

    @Override
    public SqmMultiTableInsertStrategy getSqmMultiTableInsertStrategy();

    public EntityMetamodel getEntityMetamodel();

    default public Object initializeEnhancedEntityUsedAsProxy(Object entity, String nameOfAttributeBeingAccessed, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("Initialization of entity enhancement used to act like a proxy is not supported by this EntityPersister : " + this.getClass().getName());
    }

    public boolean isSubclassEntityName(String var1);

    public String[] getPropertySpaces();

    public Serializable[] getQuerySpaces();

    @Deprecated(since="7.0", forRemoval=true)
    default public String[] getSynchronizationSpaces() {
        return (String[])this.getQuerySpaces();
    }

    default public String[] getSynchronizedQuerySpaces() {
        return (String[])this.getQuerySpaces();
    }

    @Override
    default public void visitQuerySpaces(Consumer<String> querySpaceConsumer) {
        String[] spaces;
        for (String space : spaces = this.getSynchronizedQuerySpaces()) {
            querySpaceConsumer.accept(space);
        }
    }

    public boolean hasProxy();

    public boolean hasCollections();

    public boolean hasMutableProperties();

    public boolean hasSubselectLoadableCollections();

    public boolean hasCollectionNotReferencingPK();

    public boolean hasCascades();

    default public boolean hasCascadeDelete() {
        return this.hasCascades();
    }

    default public boolean hasOwnedCollections() {
        return this.hasCollections();
    }

    public boolean isMutable();

    public boolean isInherited();

    public boolean isIdentifierAssignedByInsert();

    @Deprecated(since="6", forRemoval=true)
    public Type getPropertyType(String var1) throws MappingException;

    public int[] findDirty(Object[] var1, Object[] var2, Object var3, SharedSessionContractImplementor var4);

    public int[] findModified(Object[] var1, Object[] var2, Object var3, SharedSessionContractImplementor var4);

    public boolean hasIdentifierProperty();

    @Deprecated(since="6")
    default public boolean canExtractIdOutOfEntity() {
        return true;
    }

    public boolean isVersioned();

    public BasicType<?> getVersionType();

    default public VersionJavaType<Object> getVersionJavaType() {
        return (VersionJavaType)this.getVersionType().getJavaTypeDescriptor();
    }

    public int getVersionProperty();

    public boolean hasNaturalIdentifier();

    public int[] getNaturalIdentifierProperties();

    public Object getNaturalIdentifierSnapshot(Object var1, SharedSessionContractImplementor var2);

    @Deprecated
    public IdentifierGenerator getIdentifierGenerator();

    default public Generator getGenerator() {
        return this.getIdentifierGenerator();
    }

    default public BeforeExecutionGenerator getVersionGenerator() {
        return new VersionGeneration(this.getVersionMapping());
    }

    @Override
    default public AttributeMapping getAttributeMapping(int position) {
        return this.getAttributeMappings().get(position);
    }

    @Override
    default public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        int span = 0;
        if (domainValue instanceof Object[]) {
            Object[] values = (Object[])domainValue;
            for (int i = 0; i < this.getNumberOfAttributeMappings(); ++i) {
                AttributeMapping attributeMapping = this.getAttributeMapping(i);
                span += attributeMapping.breakDownJdbcValues(values[i], offset + span, x, y, valueConsumer, session);
            }
        } else {
            for (int i = 0; i < this.getNumberOfAttributeMappings(); ++i) {
                AttributeMapping attributeMapping = this.getAttributeMapping(i);
                Object attributeValue = attributeMapping.getValue(domainValue);
                span += attributeMapping.breakDownJdbcValues(attributeValue, offset + span, x, y, valueConsumer, session);
            }
        }
        return span;
    }

    public boolean hasLazyProperties();

    @Override
    default public NaturalIdLoader<?> getNaturalIdLoader() {
        throw new UnsupportedOperationException("EntityPersister implementation '" + this.getClass().getName() + "' does not support 'NaturalIdLoader'");
    }

    @Override
    default public MultiNaturalIdLoader<?> getMultiNaturalIdLoader() {
        throw new UnsupportedOperationException("EntityPersister implementation '" + this.getClass().getName() + "' does not support 'MultiNaturalIdLoader'");
    }

    public Object loadEntityIdByNaturalId(Object[] var1, LockOptions var2, SharedSessionContractImplementor var3);

    public Object load(Object var1, Object var2, LockMode var3, SharedSessionContractImplementor var4);

    @Deprecated(since="6.0")
    default public Object load(Object id, Object optionalObject, LockMode lockMode, SharedSessionContractImplementor session, Boolean readOnly) throws HibernateException {
        return this.load(id, optionalObject, lockMode, session);
    }

    public Object load(Object var1, Object var2, LockOptions var3, SharedSessionContractImplementor var4);

    default public Object load(Object id, Object optionalObject, LockOptions lockOptions, SharedSessionContractImplementor session, Boolean readOnly) throws HibernateException {
        return this.load(id, optionalObject, lockOptions, session);
    }

    public List<?> multiLoad(Object[] var1, EventSource var2, MultiIdLoadOptions var3);

    @Override
    default public Object loadByUniqueKey(String propertyName, Object uniqueKey, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException("EntityPersister implementation '" + this.getClass().getName() + "' does not support 'UniqueKeyLoadable'");
    }

    public void lock(Object var1, Object var2, Object var3, LockMode var4, EventSource var5);

    public void lock(Object var1, Object var2, Object var3, LockOptions var4, EventSource var5);

    @Deprecated(forRemoval=true, since="6.5")
    default public void insert(Object id, Object[] fields, Object object, SharedSessionContractImplementor session) {
        this.getInsertCoordinator().insert(object, id, fields, session);
    }

    @Deprecated(forRemoval=true, since="6.5")
    default public Object insert(Object[] fields, Object object, SharedSessionContractImplementor session) {
        GeneratedValues generatedValues = this.getInsertCoordinator().insert(object, fields, session);
        return generatedValues == null ? null : generatedValues.getGeneratedValue(this.getIdentifierMapping());
    }

    @Deprecated(forRemoval=true, since="6.5")
    default public void delete(Object id, Object version, Object object, SharedSessionContractImplementor session) {
        this.getDeleteCoordinator().delete(object, id, version, session);
    }

    @Deprecated(forRemoval=true, since="6.5")
    default public void update(Object id, Object[] fields, int[] dirtyFields, boolean hasDirtyCollection, Object[] oldFields, Object oldVersion, Object object, Object rowId, SharedSessionContractImplementor session) {
        this.getUpdateCoordinator().update(object, id, rowId, fields, oldVersion, oldFields, dirtyFields, hasDirtyCollection, session);
    }

    @Deprecated(forRemoval=true, since="6.5")
    default public void merge(Object id, Object[] fields, int[] dirtyFields, boolean hasDirtyCollection, Object[] oldFields, Object oldVersion, Object object, Object rowId, SharedSessionContractImplementor session) {
        this.getMergeCoordinator().update(object, id, rowId, fields, oldVersion, oldFields, dirtyFields, hasDirtyCollection, session);
    }

    public InsertCoordinator getInsertCoordinator();

    public UpdateCoordinator getUpdateCoordinator();

    public DeleteCoordinator getDeleteCoordinator();

    default public UpdateCoordinator getMergeCoordinator() {
        throw new UnsupportedOperationException();
    }

    public Type[] getPropertyTypes();

    public String[] getPropertyNames();

    public boolean[] getPropertyInsertability();

    public boolean[] getPropertyUpdateability();

    public boolean[] getPropertyCheckability();

    public boolean[] getPropertyNullability();

    public boolean[] getPropertyVersionability();

    public boolean[] getPropertyLaziness();

    public boolean[] getNonLazyPropertyUpdateability();

    public CascadeStyle[] getPropertyCascadeStyles();

    default public boolean isPropertySelectable(int propertyNumber) {
        return true;
    }

    public Type getIdentifierType();

    public String getIdentifierPropertyName();

    public boolean isCacheInvalidationRequired();

    public boolean isLazyPropertiesCacheable();

    public boolean canReadFromCache();

    public boolean canWriteToCache();

    @Deprecated
    public boolean hasCache();

    public EntityDataAccess getCacheAccessStrategy();

    public CacheEntryStructure getCacheEntryStructure();

    public CacheEntry buildCacheEntry(Object var1, Object[] var2, Object var3, SharedSessionContractImplementor var4);

    public boolean hasNaturalIdCache();

    public NaturalIdDataAccess getNaturalIdCacheAccessStrategy();

    @Override
    default public int getBatchSize() {
        return -1;
    }

    default public boolean isBatchLoadable() {
        return this.getBatchSize() > 1;
    }

    public boolean isSelectBeforeUpdateRequired();

    public Object[] getDatabaseSnapshot(Object var1, SharedSessionContractImplementor var2) throws HibernateException;

    public Object getIdByUniqueKey(Object var1, String var2, SharedSessionContractImplementor var3);

    public Object getCurrentVersion(Object var1, SharedSessionContractImplementor var2) throws HibernateException;

    public Object forceVersionIncrement(Object var1, Object var2, SharedSessionContractImplementor var3) throws HibernateException;

    default public Object forceVersionIncrement(Object id, Object currentVersion, boolean batching, SharedSessionContractImplementor session) throws HibernateException {
        return this.forceVersionIncrement(id, currentVersion, session);
    }

    public boolean isInstrumented();

    public boolean hasInsertGeneratedProperties();

    public boolean hasUpdateGeneratedProperties();

    public boolean isVersionPropertyGenerated();

    public void afterInitialize(Object var1, SharedSessionContractImplementor var2);

    public void afterReassociate(Object var1, SharedSessionContractImplementor var2);

    public Object createProxy(Object var1, SharedSessionContractImplementor var2);

    public Boolean isTransient(Object var1, SharedSessionContractImplementor var2);

    public Object[] getPropertyValuesToInsert(Object var1, Map<Object, Object> var2, SharedSessionContractImplementor var3);

    @Deprecated(forRemoval=true, since="6.5")
    default public void processInsertGeneratedProperties(Object id, Object entity, Object[] state, SharedSessionContractImplementor session) {
        this.processInsertGeneratedProperties(id, entity, state, null, session);
    }

    default public void processInsertGeneratedProperties(Object id, Object entity, Object[] state, GeneratedValues generatedValues, SharedSessionContractImplementor session) {
    }

    default public List<? extends ModelPart> getGeneratedProperties(EventType timing) {
        return timing == EventType.INSERT ? this.getInsertGeneratedProperties() : this.getUpdateGeneratedProperties();
    }

    default public List<? extends ModelPart> getInsertGeneratedProperties() {
        return Collections.emptyList();
    }

    @Deprecated(forRemoval=true, since="6.5")
    default public void processUpdateGeneratedProperties(Object id, Object entity, Object[] state, SharedSessionContractImplementor session) {
        this.processUpdateGeneratedProperties(id, entity, state, null, session);
    }

    public void processUpdateGeneratedProperties(Object var1, Object var2, Object[] var3, GeneratedValues var4, SharedSessionContractImplementor var5);

    default public List<? extends ModelPart> getUpdateGeneratedProperties() {
        return Collections.emptyList();
    }

    public Class<?> getMappedClass();

    public boolean implementsLifecycle();

    public Class<?> getConcreteProxyClass();

    @Override
    default public void setValues(Object object, Object[] values) {
        this.setPropertyValues(object, values);
    }

    @Deprecated(since="6.0")
    public void setPropertyValues(Object var1, Object[] var2);

    @Override
    default public void setValue(Object object, int i, Object value) {
        this.setPropertyValue(object, i, value);
    }

    @Deprecated(since="6.0")
    public void setPropertyValue(Object var1, int var2, Object var3);

    @Override
    default public Object[] getValues(Object object) {
        return this.getPropertyValues(object);
    }

    @Deprecated(since="6.0")
    public Object[] getPropertyValues(Object var1);

    @Override
    default public Object getValue(Object object, int i) {
        return this.getPropertyValue(object, i);
    }

    @Deprecated(since="6.0")
    public Object getPropertyValue(Object var1, int var2) throws HibernateException;

    public Object getPropertyValue(Object var1, String var2);

    public Object getIdentifier(Object var1, SharedSessionContractImplementor var2);

    default public Object getIdentifier(Object entity, MergeContext mergeContext) {
        return this.getIdentifier(entity, mergeContext.getEventSource());
    }

    default public Object getIdentifier(Object entity) {
        return this.getIdentifier(entity, (SharedSessionContractImplementor)null);
    }

    public void setIdentifier(Object var1, Object var2, SharedSessionContractImplementor var3);

    public Object getVersion(Object var1) throws HibernateException;

    public Object instantiate(Object var1, SharedSessionContractImplementor var2);

    public boolean isInstance(Object var1);

    public boolean hasUninitializedLazyProperties(Object var1);

    public void resetIdentifier(Object var1, Object var2, Object var3, SharedSessionContractImplementor var4);

    public EntityPersister getSubclassEntityPersister(Object var1, SessionFactoryImplementor var2);

    @Override
    public EntityRepresentationStrategy getRepresentationStrategy();

    @Override
    default public EntityMappingType getEntityMappingType() {
        return this;
    }

    @Override
    default public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        this.getIdentifierMapping().addToCacheKey(cacheKey, this.getIdentifier(value, session), session);
    }

    public BytecodeEnhancementMetadata getInstrumentationMetadata();

    default public BytecodeEnhancementMetadata getBytecodeEnhancementMetadata() {
        return this.getInstrumentationMetadata();
    }

    public FilterAliasGenerator getFilterAliasGenerator(String var1);

    default public FilterAliasGenerator getFilterAliasGenerator(TableGroup rootTableGroup) {
        return new TableGroupFilterAliasGenerator(this.getTableName(), rootTableGroup);
    }

    public String getTableName();

    public int[] resolveAttributeIndexes(String[] var1);

    default public int[] resolveDirtyAttributeIndexes(Object[] values, Object[] loadedState, String[] attributeNames, SessionImplementor session) {
        return this.resolveAttributeIndexes(attributeNames);
    }

    public boolean canUseReferenceCacheEntries();

    @Incubating
    public boolean useShallowQueryCacheLayout();

    @Incubating
    public boolean storeDiscriminatorInShallowQueryCacheLayout();

    public boolean hasFilterForLoadByKey();

    @Incubating
    public Iterable<UniqueKeyEntry> uniqueKeyEntries();

    public String getSelectByUniqueKeyString(String var1);

    default public String getSelectByUniqueKeyString(String[] propertyNames) {
        if (propertyNames.length > 1) {
            throw new IllegalArgumentException("support for multiple properties not implemented");
        }
        return this.getSelectByUniqueKeyString(propertyNames[0]);
    }

    public String getSelectByUniqueKeyString(String[] var1, String[] var2);

    public String[] getRootTableKeyColumnNames();

    public String getIdentitySelectString();

    public String[] getIdentifierColumnNames();

    public String[] getIdentifierAliases(String var1);

    public String getRootTableName();

    public String[] getRootTableIdentifierColumnNames();

    public String getVersionColumnName();

    public String[] getPropertyAliases(String var1, int var2);

    public String getDiscriminatorAlias(String var1);

    public boolean hasMultipleTables();

    public String[] getTableNames();

    @Deprecated(since="6.2")
    public String getTableName(int var1);

    public String[] getKeyColumns(int var1);

    public int getTableSpan();

    public boolean isInverseTable(int var1);

    public boolean isNullableTable(int var1);

    public boolean hasDuplicateTables();

    public int getSubclassTableSpan();

    public String getSubclassTableName(int var1);

    public String getTableNameForColumn(String var1);

    @Deprecated
    public String getDiscriminatorColumnName();

    public Type getDiscriminatorType();

    public boolean hasRowId();

    public String[] getSubclassPropertyColumnNames(int var1);

    public String[] getSubclassPropertyColumnAliases(String var1, String var2);

    public int countSubclassProperties();

    public String[] getPropertyColumnNames(String var1);

    public String selectFragment(String var1, String var2);

    public DiscriminatorMetadata getTypeDiscriminatorMetadata();

    @Deprecated(since="7.0", forRemoval=true)
    public String[] toColumns(String var1);

    public boolean isSharedColumn(String var1);

    public String[][] getConstraintOrderedTableKeyColumnClosure();

    @Internal
    public boolean managesColumns(String[] var1);
}

