/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.graph.internal.SubGraphImpl;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.MappingModelHelper;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.persister.entity.EntityPersister;

public class DomainModelHelper {
    public static <T, S extends T> ManagedDomainType<S> resolveSubType(ManagedDomainType<T> baseType, String subTypeName, JpaMetamodel jpaMetamodel) {
        if (baseType instanceof EmbeddableDomainType) {
            return baseType;
        }
        EntityDomainType subManagedType = jpaMetamodel.resolveHqlEntityReference(subTypeName);
        if (subManagedType != null) {
            return subManagedType;
        }
        try {
            Class javaType = jpaMetamodel.getServiceRegistry().requireService(ClassLoaderService.class).classForName(subTypeName);
            return jpaMetamodel.managedType(javaType);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown subtype name (" + baseType.getTypeName() + ") : " + subTypeName);
        }
    }

    static boolean isCompatible(PersistentAttribute<?, ?> attribute1, PersistentAttribute<?, ?> attribute2, MappingMetamodel mappingMetamodel) {
        if (attribute1 == attribute2) {
            return true;
        }
        ModelPart modelPart1 = DomainModelHelper.getEntityAttributeModelPart(attribute1, attribute1.getDeclaringType(), mappingMetamodel);
        ModelPart modelPart2 = DomainModelHelper.getEntityAttributeModelPart(attribute2, attribute2.getDeclaringType(), mappingMetamodel);
        return modelPart1 != null && modelPart2 != null && MappingModelHelper.isCompatibleModelPart(modelPart1, modelPart2);
    }

    static ModelPart getEntityAttributeModelPart(PersistentAttribute<?, ?> attribute, ManagedDomainType<?> domainType, MappingMetamodel mappingMetamodel) {
        if (domainType instanceof EntityDomainType) {
            EntityPersister entity = mappingMetamodel.getEntityDescriptor(domainType.getTypeName());
            return entity.findSubPart(attribute.getName());
        }
        ModelPart candidate = null;
        for (ManagedDomainType<?> subType : domainType.getSubTypes()) {
            ModelPart modelPart = DomainModelHelper.getEntityAttributeModelPart(attribute, subType, mappingMetamodel);
            if (modelPart == null) continue;
            if (candidate != null && !MappingModelHelper.isCompatibleModelPart(candidate, modelPart)) {
                return null;
            }
            candidate = modelPart;
        }
        return candidate;
    }

    public static <J, S> ManagedDomainType<S> findSubType(ManagedDomainType<J> type, Class<S> subtype) {
        if (type.getBindableJavaType() == subtype) {
            ManagedDomainType<J> result = type;
            return result;
        }
        for (ManagedDomainType<J> candidate : type.getSubTypes()) {
            if (candidate.getBindableJavaType() != subtype) continue;
            ManagedDomainType<J> result = candidate;
            return result;
        }
        for (ManagedDomainType<J> candidate : type.getSubTypes()) {
            ManagedDomainType<S> candidateSubtype = DomainModelHelper.findSubType(candidate, subtype);
            if (candidateSubtype == null) continue;
            return candidateSubtype;
        }
        throw new IllegalArgumentException("The class '" + subtype.getName() + "' is not a mapped subtype of '" + type.getTypeName() + "'");
    }

    public static <J, S> SubGraphImplementor<S> makeSubGraph(ManagedDomainType<J> type, Class<S> subtype) {
        if (type.getBindableJavaType().isAssignableFrom(subtype)) {
            return new SubGraphImpl<J>(type, true);
        }
        throw new IllegalArgumentException(String.format("Type '%s' cannot be treated as subtype '%s'", type.getTypeName(), subtype.getName()));
    }
}

