/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.MergeContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.IdClassEmbeddable;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.internal.VirtualIdEmbeddable;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetchable;

public class InverseNonAggregatedIdentifierMapping
extends EmbeddedAttributeMapping
implements NonAggregatedIdentifierMapping {
    private final IdClassEmbeddable idClassEmbeddable;
    private final EntityMappingType entityDescriptor;
    private final NonAggregatedIdentifierMapping.IdentifierValueMapper identifierValueMapper;

    InverseNonAggregatedIdentifierMapping(ManagedMappingType keyDeclaringType, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, NonAggregatedIdentifierMapping inverseModelPart, EmbeddableMappingType embeddableTypeDescriptor, MappingModelCreationProcess creationProcess) {
        super(keyDeclaringType, declaringTableGroupProducer, selectableMappings, inverseModelPart, embeddableTypeDescriptor, creationProcess);
        this.entityDescriptor = inverseModelPart.findContainingEntityMapping();
        if (inverseModelPart.getIdClassEmbeddable() == null) {
            this.idClassEmbeddable = null;
            this.identifierValueMapper = (NonAggregatedIdentifierMapping.IdentifierValueMapper)super.getEmbeddableTypeDescriptor();
        } else {
            this.idClassEmbeddable = (IdClassEmbeddable)inverseModelPart.getIdClassEmbeddable().createInverseMappingType(this, declaringTableGroupProducer, selectableMappings, creationProcess);
            this.identifierValueMapper = this.idClassEmbeddable;
        }
    }

    @Override
    public Object instantiate() {
        return null;
    }

    @Override
    public String getPartName() {
        return super.getPartName();
    }

    @Override
    public EntityIdentifierMapping.Nature getNature() {
        return EntityIdentifierMapping.Nature.VIRTUAL;
    }

    @Override
    public EmbeddableMappingType getPartMappingType() {
        return (EmbeddableMappingType)super.getPartMappingType();
    }

    @Override
    public IdClassEmbeddable getIdClassEmbeddable() {
        return this.idClassEmbeddable;
    }

    @Override
    public VirtualIdEmbeddable getVirtualIdEmbeddable() {
        return (VirtualIdEmbeddable)this.getMappedType();
    }

    @Override
    public NonAggregatedIdentifierMapping.IdentifierValueMapper getIdentifierValueMapper() {
        return this.identifierValueMapper;
    }

    @Override
    public boolean hasContainingClass() {
        return this.idClassEmbeddable != null;
    }

    @Override
    public EmbeddableMappingType getMappedIdEmbeddableTypeDescriptor() {
        return this.identifierValueMapper;
    }

    @Override
    public boolean areEqual(@Nullable Object one, @Nullable Object other, SharedSessionContractImplementor session) {
        return this.identifierValueMapper.areEqual(one, other, session);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.identifierValueMapper.disassemble(value, session);
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        this.identifierValueMapper.addToCacheKey(cacheKey, value, session);
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        return this.identifierValueMapper.forEachJdbcValue(value, offset, x, y, valuesConsumer, session);
    }

    @Override
    public SqlTuple toSqlExpression(TableGroup tableGroup, Clause clause, SqmToSqlAstConverter walker, SqlAstCreationState sqlAstCreationState) {
        if (this.hasContainingClass()) {
            EmbeddableMappingType selectableMappings = this.getEmbeddableTypeDescriptor();
            ArrayList columnReferences = CollectionHelper.arrayList(selectableMappings.getJdbcTypeCount());
            NavigablePath navigablePath = tableGroup.getNavigablePath().append(this.getNavigableRole().getNavigableName());
            TableReference defaultTableReference = tableGroup.resolveTableReference(navigablePath, this.getContainingTableExpression());
            this.identifierValueMapper.forEachSelectable(0, (columnIndex, selection) -> {
                TableReference tableReference = defaultTableReference.resolveTableReference(selection.getContainingTableExpression()) != null ? defaultTableReference : tableGroup.resolveTableReference(navigablePath, selection.getContainingTableExpression());
                Expression columnReference = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(tableReference, selection);
                columnReferences.add((ColumnReference)columnReference);
            });
            return new SqlTuple(columnReferences, this);
        }
        return super.toSqlExpression(tableGroup, clause, walker, sqlAstCreationState);
    }

    @Override
    public Object getIdentifier(Object entity) {
        return this.getIdentifier(entity, null);
    }

    @Override
    public Object getIdentifier(Object entity, MergeContext mergeContext) {
        if (this.hasContainingClass()) {
            Object id = this.identifierValueMapper.getRepresentationStrategy().getInstantiator().instantiate(null, null);
            EmbeddableMappingType embeddableTypeDescriptor = this.getEmbeddableTypeDescriptor();
            Object[] propertyValues = new Object[embeddableTypeDescriptor.getNumberOfAttributeMappings()];
            for (int i = 0; i < propertyValues.length; ++i) {
                AttributeMapping attributeMapping = embeddableTypeDescriptor.getAttributeMapping(i);
                Object o = attributeMapping.getValue(entity);
                if (o == null) {
                    AttributeMapping idClassAttributeMapping = this.identifierValueMapper.getAttributeMapping(i);
                    if (idClassAttributeMapping.getPropertyAccess().getGetter().getReturnTypeClass().isPrimitive()) {
                        propertyValues[i] = idClassAttributeMapping.getExpressibleJavaType().getDefaultValue();
                        continue;
                    }
                    propertyValues[i] = null;
                    continue;
                }
                if (attributeMapping instanceof ToOneAttributeMapping) {
                    ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attributeMapping;
                    if (!(this.identifierValueMapper.getAttributeMapping(i) instanceof ToOneAttributeMapping)) {
                        Object toOne = InverseNonAggregatedIdentifierMapping.getIfMerged(o, mergeContext);
                        ValuedModelPart targetPart = toOneAttributeMapping.getForeignKeyDescriptor().getPart(toOneAttributeMapping.getSideNature().inverse());
                        if (targetPart.isEntityIdentifierMapping()) {
                            propertyValues[i] = ((EntityIdentifierMapping)targetPart).getIdentifier(toOne, mergeContext);
                            continue;
                        }
                        propertyValues[i] = toOne;
                        continue;
                    }
                }
                propertyValues[i] = o;
            }
            this.identifierValueMapper.setValues(id, propertyValues);
            return id;
        }
        return entity;
    }

    private static Object getIfMerged(Object o, MergeContext mergeContext) {
        Object merged;
        if (mergeContext != null && (merged = mergeContext.get(o)) != null) {
            return merged;
        }
        return o;
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        Object[] propertyValues = new Object[this.identifierValueMapper.getNumberOfAttributeMappings()];
        EmbeddableMappingType embeddableTypeDescriptor = this.getEmbeddableTypeDescriptor();
        for (int position = 0; position < propertyValues.length; ++position) {
            AttributeMapping attribute = embeddableTypeDescriptor.getAttributeMapping(position);
            AttributeMapping mappedIdAttributeMapping = this.identifierValueMapper.getAttributeMapping(position);
            Object o = mappedIdAttributeMapping.getValue(id);
            if (attribute instanceof ToOneAttributeMapping && !(mappedIdAttributeMapping instanceof ToOneAttributeMapping)) {
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attribute;
                EntityPersister entityPersister = toOneAttributeMapping.getEntityMappingType().getEntityPersister();
                EntityKey entityKey = session.generateEntityKey(o, entityPersister);
                PersistenceContext persistenceContext = session.getPersistenceContext();
                EntityHolder holder = persistenceContext.getEntityHolder(entityKey);
                Object object = o = holder == null ? null : holder.getManagedObject();
                if (o == null) {
                    o = this.entityDescriptor.findAttributeMapping(toOneAttributeMapping.getAttributeName()).getValue(entity);
                }
            }
            propertyValues[position] = o;
        }
        embeddableTypeDescriptor.setValues(entity, propertyValues);
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        return this.identifierValueMapper.breakDownJdbcValues(domainValue, offset, x, y, valueConsumer, session);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.identifierValueMapper.applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.identifierValueMapper.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public String getSqlAliasStem() {
        return "id";
    }

    @Override
    public String getFetchableName() {
        return "{id}";
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getPartMappingType().getNumberOfFetchables();
    }

    @Override
    public Fetchable getFetchable(int position) {
        return this.getPartMappingType().getFetchable(position);
    }
}

