/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import org.hibernate.HibernateException;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.ImplicitDiscriminatorStrategy;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class ShortNameImplicitDiscriminatorStrategy
implements ImplicitDiscriminatorStrategy {
    public static final ShortNameImplicitDiscriminatorStrategy SHORT_NAME_STRATEGY = new ShortNameImplicitDiscriminatorStrategy();

    @Override
    public Object toDiscriminatorValue(EntityMappingType entityMapping, NavigableRole discriminatorRole, MappingMetamodelImplementor mappingModel) {
        return entityMapping.getImportedName();
    }

    @Override
    public EntityMappingType toEntityMapping(Object discriminatorValue, NavigableRole discriminatorRole, MappingMetamodelImplementor mappingModel) {
        String assumedEntityName;
        String importedName;
        EntityPersister entityMapping;
        if (discriminatorValue instanceof String && (entityMapping = mappingModel.findEntityDescriptor(importedName = mappingModel.getImportedName(assumedEntityName = (String)discriminatorValue))) != null) {
            return entityMapping;
        }
        throw new HibernateException("Cannot interpret discriminator value (" + discriminatorRole + ") : " + discriminatorValue);
    }
}

