/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.ExportableProducer;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.id.CompositeNestedGeneratedValueGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.GeneratorSettings;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.MappingHelper;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SortableValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.metamodel.mapping.DiscriminatorType;
import org.hibernate.metamodel.mapping.EmbeddableDiscriminatorConverter;
import org.hibernate.metamodel.mapping.internal.DiscriminatorTypeImpl;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.persister.entity.DiscriminatorHelper;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.MappingContext;
import org.hibernate.type.UserComponentType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.usertype.CompositeUserType;

public class Component
extends SimpleValue
implements MetaAttributable,
SortableValue {
    private String componentClassName;
    private boolean embedded;
    private String parentProperty;
    private PersistentClass owner;
    private boolean dynamic;
    private boolean isKey;
    private transient Boolean isGeneric;
    private String roleName;
    private MappedSuperclass mappedSuperclass;
    private Value discriminator;
    private transient DiscriminatorType<?> discriminatorType;
    private Map<Object, String> discriminatorValues;
    private Map<String, String> subclassToSuperclass;
    private final ArrayList<Property> properties = new ArrayList();
    private Map<Property, String> propertyDeclaringClasses;
    private int[] originalPropertyOrder = ArrayHelper.EMPTY_INT_ARRAY;
    private Map<String, MetaAttribute> metaAttributes;
    private Class<? extends EmbeddableInstantiator> customInstantiator;
    private Constructor<?> instantiator;
    private String[] instantiatorPropertyNames;
    private volatile transient CompositeType type;
    private AggregateColumn aggregateColumn;
    private AggregateColumn parentAggregateColumn;
    private QualifiedName structName;
    private String[] structColumnNames;
    private transient Class<?> componentClass;
    private transient Boolean simpleRecord;

    public Component(MetadataBuildingContext metadata, PersistentClass owner) throws MappingException {
        this(metadata, owner.getTable(), owner);
    }

    public Component(MetadataBuildingContext metadata, Component component) throws MappingException {
        this(metadata, component.getTable(), component.getOwner());
    }

    public Component(MetadataBuildingContext metadata, Join join) throws MappingException {
        this(metadata, join.getTable(), join.getPersistentClass());
    }

    public Component(MetadataBuildingContext metadata, Collection collection) throws MappingException {
        this(metadata, collection.getCollectionTable(), collection.getOwner());
    }

    public Component(MetadataBuildingContext metadata, Table table, PersistentClass owner) throws MappingException {
        super(metadata, table);
        this.owner = owner;
        metadata.getMetadataCollector().registerComponent(this);
    }

    private Component(Component original) {
        super(original);
        this.properties.addAll(original.properties);
        this.originalPropertyOrder = original.originalPropertyOrder == null ? null : (int[])original.originalPropertyOrder.clone();
        this.propertyDeclaringClasses = original.propertyDeclaringClasses;
        this.componentClassName = original.componentClassName;
        this.componentClass = original.componentClass;
        this.embedded = original.embedded;
        this.parentProperty = original.parentProperty;
        this.owner = original.owner;
        this.dynamic = original.dynamic;
        this.isGeneric = original.isGeneric;
        this.metaAttributes = original.metaAttributes == null ? null : new HashMap<String, MetaAttribute>(original.metaAttributes);
        this.isKey = original.isKey;
        this.roleName = original.roleName;
        this.discriminator = original.discriminator;
        this.discriminatorValues = original.discriminatorValues;
        this.subclassToSuperclass = original.subclassToSuperclass;
        this.customInstantiator = original.customInstantiator;
        this.type = original.type;
    }

    @Override
    public Component copy() {
        return new Component(this);
    }

    public int getPropertySpan() {
        return this.properties.size();
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void addProperty(Property p, ClassDetails declaringClass) {
        this.properties.add(p);
        if (this.isPolymorphic() && declaringClass != null) {
            if (this.propertyDeclaringClasses == null) {
                this.propertyDeclaringClasses = new HashMap<Property, String>();
            }
            this.propertyDeclaringClasses.put(p, declaringClass.getName());
        }
    }

    public void addProperty(Property p) {
        this.addProperty(p, null);
    }

    public String getPropertyDeclaringClass(Property p) {
        if (this.propertyDeclaringClasses != null) {
            return this.propertyDeclaringClasses.get(p);
        }
        return null;
    }

    @Override
    public void addColumn(Column column) {
        throw new UnsupportedOperationException("Cant add a column to a component");
    }

    @Override
    public List<Selectable> getSelectables() {
        ArrayList<Selectable> selectables = new ArrayList<Selectable>(this.properties.size() + 2);
        for (Property property : this.properties) {
            selectables.addAll(property.getSelectables());
        }
        if (this.discriminator != null) {
            selectables.addAll(this.discriminator.getSelectables());
        }
        return Collections.unmodifiableList(selectables);
    }

    @Override
    public List<Column> getColumns() {
        ArrayList<Column> columns = new ArrayList<Column>(this.properties.size() + 2);
        for (Property property : this.properties) {
            columns.addAll(property.getValue().getColumns());
        }
        if (this.discriminator != null) {
            columns.addAll(this.discriminator.getColumns());
        }
        return Collections.unmodifiableList(columns);
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public AggregateColumn getAggregateColumn() {
        return this.aggregateColumn;
    }

    public void setAggregateColumn(AggregateColumn aggregateColumn) {
        this.aggregateColumn = aggregateColumn;
        this.notifyPropertiesAboutAggregateColumn(aggregateColumn, this);
    }

    @Override
    public int getColumnSpan() {
        return this.getSelectables().size();
    }

    public List<Column> getAggregatedColumns() {
        ArrayList<Column> aggregatedColumns = new ArrayList<Column>(this.getPropertySpan());
        this.collectAggregatedColumns(aggregatedColumns, this);
        return aggregatedColumns;
    }

    private void collectAggregatedColumns(List<Column> aggregatedColumns, Component component) {
        for (Property property : component.getProperties()) {
            Value value = property.getValue();
            if (value instanceof Component) {
                Component subComponent = (Component)value;
                AggregateColumn subAggregate = subComponent.getAggregateColumn();
                if (subAggregate != null) {
                    aggregatedColumns.add(subAggregate);
                    continue;
                }
                this.collectAggregatedColumns(aggregatedColumns, subComponent);
                continue;
            }
            aggregatedColumns.addAll(property.getValue().getColumns());
        }
        if (component.isPolymorphic()) {
            aggregatedColumns.addAll(component.getDiscriminator().getColumns());
        }
    }

    private void notifyPropertiesAboutAggregateColumn(AggregateColumn aggregateColumn, Component component) {
        for (Property property : component.getProperties()) {
            Value value = property.getValue();
            if (value instanceof BasicValue) {
                BasicValue basicValue = (BasicValue)value;
                assert (basicValue.getResolution() == null);
                basicValue.setAggregateColumn(aggregateColumn);
                continue;
            }
            if (!(value instanceof Component)) continue;
            Component subComponent = (Component)value;
            if (subComponent.getAggregateColumn() == null) {
                subComponent.notifyPropertiesAboutAggregateColumn(aggregateColumn, subComponent);
                continue;
            }
            subComponent.setParentAggregateColumn(aggregateColumn);
        }
        if (component.isPolymorphic()) {
            ((BasicValue)component.getDiscriminator()).setAggregateColumn(aggregateColumn);
        }
    }

    public AggregateColumn getParentAggregateColumn() {
        return this.parentAggregateColumn;
    }

    public void setParentAggregateColumn(AggregateColumn parentAggregateColumn) {
        this.parentAggregateColumn = parentAggregateColumn;
    }

    public QualifiedName getStructName() {
        return this.structName;
    }

    public void setStructName(QualifiedName structName) {
        this.structName = structName;
    }

    @Override
    public void checkColumnDuplication(Set<String> distinctColumns, String owner) {
        if (this.aggregateColumn == null) {
            if (this.isPolymorphic()) {
                HashMap<String, Set> distinctColumnsByClass = new HashMap<String, Set>();
                for (Property prop : this.properties) {
                    if (!prop.isUpdateable() && !prop.isInsertable()) continue;
                    String declaringClass = this.propertyDeclaringClasses.get(prop);
                    Set set = distinctColumnsByClass.computeIfAbsent(declaringClass, k -> new HashSet(distinctColumns));
                    prop.getValue().checkColumnDuplication(set, owner);
                }
                for (Set columns : distinctColumnsByClass.values()) {
                    distinctColumns.addAll(columns);
                }
            } else {
                MappingHelper.checkPropertyColumnDuplication(distinctColumns, this.getProperties(), owner);
            }
        } else {
            MappingHelper.checkPropertyColumnDuplication(new HashSet<String>(), this.getProperties(), "component '" + this.getRoleName() + "'");
            this.aggregateColumn.getValue().checkColumnDuplication(distinctColumns, owner);
        }
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public Class<?> getComponentClass() throws MappingException {
        Class<Object> result = this.componentClass;
        if (result == null) {
            if (this.componentClassName == null) {
                return null;
            }
            try {
                result = this.componentClass = this.getMetadata().getMetadataBuildingOptions().getServiceRegistry().requireService(ClassLoaderService.class).classForName(this.componentClassName);
            }
            catch (ClassLoadingException e) {
                throw new MappingException("component class not found: " + this.componentClassName, (Throwable)((Object)e));
            }
        }
        return result;
    }

    public PersistentClass getOwner() {
        return this.owner;
    }

    public String getParentProperty() {
        return this.parentProperty;
    }

    public void setComponentClassName(String componentClass) {
        this.componentClassName = componentClass;
        this.componentClass = null;
        this.simpleRecord = null;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public void setOwner(PersistentClass owner) {
        this.owner = owner;
    }

    public void setParentProperty(String parentProperty) {
        this.parentProperty = parentProperty;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    private CompositeUserType<?> createCompositeUserType(Component component) {
        BootstrapContext bootstrapContext = this.getBuildingContext().getBootstrapContext();
        Class customTypeClass = bootstrapContext.getClassLoaderAccess().classForName(component.getTypeName());
        return !this.getBuildingContext().getBuildingOptions().isAllowExtensionsInCdi() ? (CompositeUserType)FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(customTypeClass) : (CompositeUserType)bootstrapContext.getServiceRegistry().requireService(ManagedBeanRegistry.class).getBean(customTypeClass).getBeanInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeType getType() throws MappingException {
        UserComponentType localType = this.type;
        if (localType == null) {
            Component component = this;
            synchronized (component) {
                localType = this.type;
                if (localType == null) {
                    this.sortProperties(true);
                    String typeName = this.getTypeName();
                    if (typeName == null) {
                        localType = this.isEmbedded() ? new EmbeddedComponentType(this, this.originalPropertyOrder) : new ComponentType(this, this.originalPropertyOrder);
                    } else {
                        CompositeUserType<?> compositeUserType = this.createCompositeUserType(this);
                        localType = new UserComponentType(this, this.originalPropertyOrder, compositeUserType);
                    }
                    this.type = localType;
                }
            }
        }
        return localType;
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
    }

    @Override
    public Map<String, MetaAttribute> getMetaAttributes() {
        return this.metaAttributes;
    }

    @Override
    public MetaAttribute getMetaAttribute(String attributeName) {
        return this.metaAttributes == null ? null : this.metaAttributes.get(attributeName);
    }

    @Override
    public void setMetaAttributes(Map<String, MetaAttribute> metas) {
        this.metaAttributes = metas;
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean isSame(SimpleValue other) {
        return other instanceof Component && this.isSame((Component)other);
    }

    public boolean isSame(Component other) {
        return super.isSame(other) && Objects.equals(this.properties, other.properties) && Objects.equals(this.componentClassName, other.componentClassName) && this.embedded == other.embedded && Objects.equals(this.aggregateColumn, other.aggregateColumn) && Objects.equals(this.parentAggregateColumn, other.parentAggregateColumn) && Objects.equals(this.structName, other.structName) && Objects.equals(this.parentProperty, other.parentProperty) && Objects.equals(this.metaAttributes, other.metaAttributes);
    }

    @Override
    public boolean[] getColumnInsertability() {
        boolean[] result = new boolean[this.getColumnSpan()];
        int i = 0;
        for (Property prop : this.getProperties()) {
            i += Component.copyFlags(prop.getValue().getColumnInsertability(), result, i, prop.isInsertable());
        }
        if (this.isPolymorphic()) {
            i += Component.copyFlags(this.getDiscriminator().getColumnInsertability(), result, i, true);
        }
        assert (i == this.getColumnSpan());
        return result;
    }

    private static int copyFlags(boolean[] chunk, boolean[] result, int i, boolean doCopy) {
        if (doCopy) {
            System.arraycopy(chunk, 0, result, i, chunk.length);
        }
        return chunk.length;
    }

    @Override
    public boolean hasAnyInsertableColumns() {
        for (Property property : this.properties) {
            if (!property.getValue().hasAnyInsertableColumns()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean[] getColumnUpdateability() {
        boolean[] result = new boolean[this.getColumnSpan()];
        int i = 0;
        for (Property prop : this.getProperties()) {
            i += Component.copyFlags(prop.getValue().getColumnUpdateability(), result, i, prop.isUpdateable());
        }
        if (this.isPolymorphic()) {
            i += Component.copyFlags(this.getDiscriminator().getColumnUpdateability(), result, i, true);
        }
        assert (i == this.getColumnSpan());
        return result;
    }

    @Override
    public boolean hasAnyUpdatableColumns() {
        for (Property property : this.properties) {
            if (!property.getValue().hasAnyUpdatableColumns()) continue;
            return true;
        }
        return false;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean isKey) {
        this.isKey = isKey;
    }

    public Property getProperty(int index) {
        return this.properties.get(index);
    }

    public Property getProperty(String propertyName) throws MappingException {
        for (Property prop : this.properties) {
            if (!prop.getName().equals(propertyName)) continue;
            return prop;
        }
        throw new MappingException("component: " + this.componentClassName + " property not found: " + propertyName);
    }

    public boolean matchesAllProperties(String ... propertyNames) {
        return this.properties.size() == propertyNames.length && new HashSet(this.properties.stream().map(Property::getName).collect(Collectors.toList())).containsAll(List.of(propertyNames));
    }

    public boolean hasProperty(String propertyName) {
        for (Property prop : this.properties) {
            if (!prop.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public MappedSuperclass getMappedSuperclass() {
        return this.mappedSuperclass;
    }

    public void setMappedSuperclass(MappedSuperclass mappedSuperclass) {
        this.mappedSuperclass = mappedSuperclass;
    }

    public Value getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(Value discriminator) {
        this.discriminator = discriminator;
    }

    public DiscriminatorType<?> getDiscriminatorType() {
        DiscriminatorType<?> type = this.discriminatorType;
        if (type == null) {
            type = this.discriminatorType = this.buildDiscriminatorType();
        }
        return type;
    }

    private DiscriminatorType<?> buildDiscriminatorType() {
        return this.getBuildingContext().getMetadataCollector().resolveEmbeddableDiscriminatorType(this.getComponentClass(), () -> {
            JavaTypeRegistry javaTypeRegistry = this.getTypeConfiguration().getJavaTypeRegistry();
            JavaType domainJavaType = javaTypeRegistry.resolveDescriptor((Type)((Object)Class.class));
            BasicType<?> discriminatorType = DiscriminatorHelper.getDiscriminatorType(this);
            EmbeddableDiscriminatorConverter converter = EmbeddableDiscriminatorConverter.fromValueMappings(StringHelper.qualify(this.getComponentClassName(), "{discriminator}"), domainJavaType, discriminatorType, this.getDiscriminatorValues(), this.getServiceRegistry());
            return new DiscriminatorTypeImpl(discriminatorType, converter);
        });
    }

    public boolean isPolymorphic() {
        return this.discriminator != null;
    }

    public Map<Object, String> getDiscriminatorValues() {
        return this.discriminatorValues;
    }

    public void setDiscriminatorValues(Map<Object, String> discriminatorValues) {
        this.discriminatorValues = discriminatorValues;
    }

    public String getSuperclass(String subclass) {
        return this.subclassToSuperclass.get(subclass);
    }

    public void setSubclassToSuperclass(Map<String, String> subclassToSuperclass) {
        this.subclassToSuperclass = subclassToSuperclass;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.componentClassName + ")";
    }

    @Override
    public Generator createGenerator(Dialect dialect, RootClass rootClass, Property property, GeneratorSettings defaults) {
        return this.getCustomIdGeneratorCreator().isAssigned() ? this.buildIdentifierGenerator(dialect, rootClass, defaults) : super.createGenerator(dialect, rootClass, property, defaults);
    }

    private Generator buildIdentifierGenerator(Dialect dialect, RootClass rootClass, GeneratorSettings defaults) {
        CompositeNestedGeneratedValueGenerator generator = new CompositeNestedGeneratedValueGenerator(new StandardGenerationContextLocator(rootClass.getEntityName()), this.getType());
        List<Property> properties = this.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            SimpleValue value;
            Property property = properties.get(i);
            if (!property.getValue().isSimpleValue() || (value = (SimpleValue)property.getValue()).getCustomIdGeneratorCreator().isAssigned()) continue;
            Generator generator2 = value.createGenerator(dialect, rootClass, property, defaults);
            if (generator2 instanceof BeforeExecutionGenerator) {
                BeforeExecutionGenerator beforeExecutionGenerator = (BeforeExecutionGenerator)generator2;
                generator.addGeneratedValuePlan(new ValueGenerationPlan(beforeExecutionGenerator, this.getType().isMutable() ? this.injector(property, this.getAttributeDeclarer(rootClass)) : null, i));
                continue;
            }
            throw new IdentifierGenerationException("Identity generation isn't supported for composite ids");
        }
        return generator;
    }

    private Class<?> getAttributeDeclarer(RootClass rootClass) {
        if (rootClass.getIdentifierMapper() != null) {
            return this.resolveComponentClass();
        }
        if (rootClass.getIdentifierProperty() != null) {
            return this.resolveComponentClass();
        }
        return rootClass.getMappedClass();
    }

    private Setter injector(Property property, Class<?> attributeDeclarer) {
        return property.getPropertyAccessStrategy(attributeDeclarer).buildPropertyAccess(attributeDeclarer, property.getName(), true).getSetter();
    }

    private Class<?> resolveComponentClass() {
        try {
            return this.getComponentClass();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Internal
    public String[] getPropertyNames() {
        String[] propertyNames = new String[this.properties.size()];
        for (int i = 0; i < this.properties.size(); ++i) {
            propertyNames[i] = this.properties.get(i).getName();
        }
        return propertyNames;
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public void prepareForMappingModel() {
        this.getType();
    }

    @Override
    public boolean isValid(MappingContext mappingContext) throws MappingException {
        if (!super.isValid(mappingContext)) {
            return false;
        }
        if (this.instantiatorPropertyNames != null) {
            if (this.instantiatorPropertyNames.length < this.properties.size()) {
                throw new MappingException("component type [" + this.componentClassName + "] specifies " + this.instantiatorPropertyNames.length + " properties for the instantiator but has " + this.properties.size() + " properties");
            }
            HashSet assignedPropertyNames = CollectionHelper.setOfSize(this.properties.size());
            for (String instantiatorPropertyName : this.instantiatorPropertyNames) {
                if (this.getProperty(instantiatorPropertyName) == null) {
                    throw new MappingException("could not find property [" + instantiatorPropertyName + "] defined in the @Instantiator withing component [" + this.componentClassName + "]");
                }
                assignedPropertyNames.add(instantiatorPropertyName);
            }
            if (assignedPropertyNames.size() != this.properties.size()) {
                ArrayList<String> missingProperties = new ArrayList<String>();
                for (Property property : this.properties) {
                    if (assignedPropertyNames.contains(property.getName())) continue;
                    missingProperties.add(property.getName());
                }
                throw new MappingException("component type [" + this.componentClassName + "] has " + this.properties.size() + " properties but the instantiator only assigns " + assignedPropertyNames.size() + " properties. missing properties: " + missingProperties);
            }
        }
        return true;
    }

    @Override
    public boolean isSorted() {
        return this.originalPropertyOrder != ArrayHelper.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] sortProperties() {
        return this.sortProperties(false);
    }

    private int[] sortProperties(boolean forceRetainOriginalOrder) {
        PrimaryKey primaryKey;
        int[] originalPropertyOrder;
        if (this.originalPropertyOrder != ArrayHelper.EMPTY_INT_ARRAY) {
            return this.originalPropertyOrder;
        }
        if (this.isSimpleRecord()) {
            this.originalPropertyOrder = null;
            return null;
        }
        if (forceRetainOriginalOrder || this.isAlternateUniqueKey() || this.isEmbedded() || this.getBuildingContext() instanceof MappingDocument) {
            Property[] originalProperties = this.properties.toArray(new Property[0]);
            this.properties.sort(Comparator.comparing(Property::getName));
            originalPropertyOrder = new int[originalProperties.length];
            for (int j = 0; j < originalPropertyOrder.length; ++j) {
                originalPropertyOrder[j] = this.properties.indexOf(originalProperties[j]);
            }
        } else {
            this.properties.sort(Comparator.comparing(Property::getName));
            originalPropertyOrder = null;
        }
        if (this.isKey && (primaryKey = this.getOwner().getTable().getPrimaryKey()) != null) {
            List<Column> columns = primaryKey.getColumns();
            columns.clear();
            for (Property property : this.properties) {
                for (Selectable selectable : property.getSelectables()) {
                    if (!(selectable instanceof Column)) continue;
                    columns.add((Column)selectable);
                }
            }
        }
        this.originalPropertyOrder = originalPropertyOrder;
        return originalPropertyOrder;
    }

    public void setSimpleRecord(boolean simpleRecord) {
        this.simpleRecord = simpleRecord;
    }

    public boolean isSimpleRecord() {
        Boolean simple = this.simpleRecord;
        if (simple == null) {
            Class<?> componentClass = this.resolveComponentClass();
            if (this.customInstantiator != null) {
                this.simpleRecord = false;
                return this.simpleRecord;
            }
            if (componentClass == null || !ReflectHelper.isRecord(componentClass)) {
                this.simpleRecord = false;
                return this.simpleRecord;
            }
            String[] recordComponentNames = ReflectHelper.getRecordComponentNames(componentClass);
            if (recordComponentNames.length != this.properties.size()) {
                this.simpleRecord = false;
                return this.simpleRecord;
            }
            for (int i = 0; i < recordComponentNames.length; ++i) {
                if (recordComponentNames[i].equals(this.properties.get(i).getName())) continue;
                this.simpleRecord = false;
                return this.simpleRecord;
            }
            simple = this.simpleRecord = Boolean.valueOf(true);
        }
        return simple;
    }

    public Class<? extends EmbeddableInstantiator> getCustomInstantiator() {
        return this.customInstantiator;
    }

    public void setCustomInstantiator(Class<? extends EmbeddableInstantiator> customInstantiator) {
        this.customInstantiator = customInstantiator;
    }

    public Constructor<?> getInstantiator() {
        return this.instantiator;
    }

    public String[] getInstantiatorPropertyNames() {
        return this.instantiatorPropertyNames;
    }

    public void setInstantiator(Constructor<?> instantiator, String[] instantiatorPropertyNames) {
        this.instantiator = instantiator;
        this.instantiatorPropertyNames = instantiatorPropertyNames;
    }

    public String[] getStructColumnNames() {
        return this.structColumnNames;
    }

    public void setStructColumnNames(String[] structColumnNames) {
        this.structColumnNames = structColumnNames;
    }

    public boolean isGeneric() {
        if (this.isGeneric == null) {
            this.isGeneric = this.getComponentClassName() != null && this.getComponentClass().getTypeParameters().length > 0;
        }
        return this.isGeneric;
    }

    public void setGeneric(boolean generic) {
        this.isGeneric = generic;
    }

    public static class StandardGenerationContextLocator
    implements CompositeNestedGeneratedValueGenerator.GenerationContextLocator {
        private final String entityName;

        public StandardGenerationContextLocator(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public Object locateGenerationContext(SharedSessionContractImplementor session, Object incomingObject) {
            return session.getEntityPersister(this.entityName, incomingObject).getIdentifier(incomingObject, session);
        }
    }

    public static class ValueGenerationPlan
    implements CompositeNestedGeneratedValueGenerator.GenerationPlan {
        private final BeforeExecutionGenerator generator;
        private final Setter injector;
        private final int propertyIndex;

        public ValueGenerationPlan(BeforeExecutionGenerator generator, Setter injector, int propertyIndex) {
            this.generator = generator;
            this.injector = injector;
            this.propertyIndex = propertyIndex;
        }

        @Override
        public Setter getInjector() {
            return this.injector;
        }

        @Override
        public int getPropertyIndex() {
            return this.propertyIndex;
        }

        @Override
        public Object execute(SharedSessionContractImplementor session, Object incomingObject) {
            if (this.generator.generatedBeforeExecution(incomingObject, session)) {
                return this.generator.generate(session, incomingObject, null, EventType.INSERT);
            }
            throw new IdentifierGenerationException("Identity generation isn't supported for composite ids");
        }

        @Override
        public void registerExportables(Database database) {
            BeforeExecutionGenerator beforeExecutionGenerator = this.generator;
            if (beforeExecutionGenerator instanceof ExportableProducer) {
                ExportableProducer exportableProducer = (ExportableProducer)((Object)beforeExecutionGenerator);
                exportableProducer.registerExportables(database);
            }
        }

        @Override
        public void initialize(SqlStringGenerationContext context) {
            BeforeExecutionGenerator beforeExecutionGenerator = this.generator;
            if (beforeExecutionGenerator instanceof Configurable) {
                Configurable configurable = (Configurable)((Object)beforeExecutionGenerator);
                configurable.initialize(context);
            }
        }
    }
}

