/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.internal.BatchFetchQueueHelper;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.event.spi.EventSource;
import org.hibernate.loader.ast.internal.AbstractMultiIdEntityLoader;
import org.hibernate.loader.ast.internal.ExecutionContextWithSubselectFetchHandler;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.loader.ast.spi.SqlArrayMultiKeyLoader;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ManagedResultConsumer;

public class MultiIdEntityLoaderArrayParam<E>
extends AbstractMultiIdEntityLoader<E>
implements SqlArrayMultiKeyLoader {
    private final JdbcMapping arrayJdbcMapping;
    private final JdbcParameter jdbcParameter;

    public MultiIdEntityLoaderArrayParam(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
        Class<?> idArrayClass = this.idArray.getClass();
        this.arrayJdbcMapping = MultiKeyLoadHelper.resolveArrayJdbcMapping(this.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(idArrayClass), this.getIdentifierMapping().getJdbcMapping(), idArrayClass, this.getSessionFactory());
        this.jdbcParameter = new JdbcParameterImpl(this.arrayJdbcMapping);
    }

    @Override
    public BasicEntityIdentifierMapping getIdentifierMapping() {
        return (BasicEntityIdentifierMapping)super.getIdentifierMapping();
    }

    @Override
    protected void handleResults(MultiIdLoadOptions loadOptions, EventSource session, List<Integer> elementPositionsLoadedByBatch, List<Object> result) {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        for (Integer position : elementPositionsLoadedByBatch) {
            EntityKey entityKey = (EntityKey)result.get(position);
            BatchFetchQueueHelper.removeBatchLoadableEntityKey(entityKey, session);
            Object entity = persistenceContext.getEntity(entityKey);
            if (entity != null && !loadOptions.isReturnOfDeletedEntitiesEnabled()) {
                EntityEntry entry = persistenceContext.getEntry(entity);
                entity = entry.getStatus().isDeletedOrGone() ? null : persistenceContext.proxyFor(entity);
            }
            result.set(position, entity);
        }
    }

    @Override
    protected int maxBatchSize(Object[] ids, MultiIdLoadOptions loadOptions) {
        Integer explicitBatchSize = loadOptions.getBatchSize();
        return explicitBatchSize != null && explicitBatchSize > 0 ? explicitBatchSize : ids.length;
    }

    @Override
    protected void loadEntitiesById(List<Object> idsInBatch, LockOptions lockOptions, MultiIdLoadOptions loadOptions, EventSource session) {
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectBySingleArrayParameter(this.getLoadable(), this.getIdentifierMapping(), session.getLoadQueryInfluencers(), lockOptions, this.jdbcParameter, this.getSessionFactory());
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(1);
        jdbcParameterBindings.addBinding(this.jdbcParameter, new JdbcParameterBindingImpl(this.arrayJdbcMapping, idsInBatch.toArray(this.idArray)));
        this.getJdbcSelectExecutor().executeQuery(this.getSqlAstTranslatorFactory().buildSelectTranslator(this.getSessionFactory(), sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE), (JdbcParameterBindings)jdbcParameterBindings, (ExecutionContext)new ExecutionContextWithSubselectFetchHandler(session, SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), sqlAst, JdbcParametersList.singleton(this.jdbcParameter), jdbcParameterBindings), Boolean.TRUE.equals(loadOptions.getReadOnly(session))), RowTransformerStandardImpl.instance(), null, idsInBatch.size(), ManagedResultConsumer.INSTANCE);
    }

    @Override
    protected void loadEntitiesWithUnresolvedIds(MultiIdLoadOptions loadOptions, LockOptions lockOptions, EventSource session, Object[] unresolvableIds, List<E> result) {
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectBySingleArrayParameter(this.getLoadable(), this.getIdentifierMapping(), session.getLoadQueryInfluencers(), lockOptions, this.jdbcParameter, this.getSessionFactory());
        JdbcOperationQuerySelect jdbcSelectOperation = this.getSqlAstTranslatorFactory().buildSelectTranslator(this.getSessionFactory(), sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
        List databaseResults = LoaderHelper.loadByArrayParameter(unresolvableIds, sqlAst, jdbcSelectOperation, this.jdbcParameter, this.arrayJdbcMapping, null, null, null, lockOptions, session.isDefaultReadOnly(), session);
        result.addAll(databaseResults);
        for (Object id : unresolvableIds) {
            if (id == null) continue;
            BatchFetchQueueHelper.removeBatchLoadableEntityKey(id, this.getLoadable(), (SharedSessionContractImplementor)session);
        }
    }
}

