/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.CacheEntityLoaderHelper;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.MultiIdEntityLoader;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractMultiIdEntityLoader<T>
implements MultiIdEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    private final SessionFactoryImplementor sessionFactory;
    private final EntityIdentifierMapping identifierMapping;
    protected final Object[] idArray;

    public AbstractMultiIdEntityLoader(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.sessionFactory = sessionFactory;
        this.identifierMapping = this.getLoadable().getIdentifierMapping();
        this.idArray = (Object[])Array.newInstance(this.identifierMapping.getJavaType().getJavaTypeClass(), 0);
    }

    protected EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public EntityIdentifierMapping getIdentifierMapping() {
        return this.identifierMapping;
    }

    protected JdbcServices getJdbcServices() {
        return this.getSessionFactory().getJdbcServices();
    }

    protected SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return this.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
    }

    protected JdbcSelectExecutor getJdbcSelectExecutor() {
        return this.getJdbcServices().getJdbcSelectExecutor();
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.getEntityDescriptor();
    }

    @Override
    public final <K> List<T> load(K[] ids, MultiIdLoadOptions loadOptions, EventSource session) {
        assert (ids != null);
        return loadOptions.isOrderReturnEnabled() ? this.performOrderedMultiLoad(ids, loadOptions, session) : this.performUnorderedMultiLoad(ids, loadOptions, session);
    }

    private List<T> performUnorderedMultiLoad(Object[] ids, MultiIdLoadOptions loadOptions, EventSource session) {
        assert (!loadOptions.isOrderReturnEnabled());
        assert (ids != null);
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("#performUnorderedMultiLoad(`%s`, ..)", (Object)this.getLoadable().getEntityName());
        }
        return this.unorderedMultiLoad(ids, loadOptions, AbstractMultiIdEntityLoader.lockOptions(loadOptions), session);
    }

    protected List<T> performOrderedMultiLoad(Object[] ids, MultiIdLoadOptions loadOptions, EventSource session) {
        assert (loadOptions.isOrderReturnEnabled());
        assert (ids != null);
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("#performOrderedMultiLoad(`%s`, ..)", (Object)this.getLoadable().getEntityName());
        }
        return this.orderedMultiLoad(ids, loadOptions, AbstractMultiIdEntityLoader.lockOptions(loadOptions), session);
    }

    private List<T> orderedMultiLoad(Object[] ids, MultiIdLoadOptions loadOptions, LockOptions lockOptions, EventSource session) {
        boolean idCoercionEnabled = this.isIdCoercionEnabled();
        JavaType<?> idType = this.getLoadable().getIdentifierMapping().getJavaType();
        int maxBatchSize = this.maxBatchSize(ids, loadOptions);
        ArrayList<Object> result = CollectionHelper.arrayList(ids.length);
        ArrayList<Object> idsInBatch = new ArrayList<Object>();
        ArrayList<Integer> elementPositionsLoadedByBatch = new ArrayList<Integer>();
        for (int i = 0; i < ids.length; ++i) {
            EntityKey entityKey;
            Object id = idCoercionEnabled ? idType.coerce(ids[i], session) : ids[i];
            if (this.loadFromEnabledCaches(loadOptions, session, id, lockOptions, entityKey = new EntityKey(id, this.getLoadable().getEntityPersister()), result, i)) continue;
            idsInBatch.add(id);
            if (idsInBatch.size() >= maxBatchSize) {
                this.loadEntitiesById(idsInBatch, lockOptions, loadOptions, session);
                idsInBatch.clear();
            }
            result.add(i, entityKey);
            elementPositionsLoadedByBatch.add(i);
        }
        if (!idsInBatch.isEmpty()) {
            this.loadEntitiesById(idsInBatch, lockOptions, loadOptions, session);
        }
        this.handleResults(loadOptions, session, elementPositionsLoadedByBatch, result);
        return result;
    }

    protected static LockOptions lockOptions(MultiIdLoadOptions loadOptions) {
        return loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
    }

    protected abstract int maxBatchSize(Object[] var1, MultiIdLoadOptions var2);

    protected abstract void handleResults(MultiIdLoadOptions var1, EventSource var2, List<Integer> var3, List<Object> var4);

    protected abstract void loadEntitiesById(List<Object> var1, LockOptions var2, MultiIdLoadOptions var3, EventSource var4);

    protected boolean loadFromEnabledCaches(MultiIdLoadOptions loadOptions, EventSource session, Object id, LockOptions lockOptions, EntityKey entityKey, List<Object> result, int i) {
        if (loadOptions.isSessionCheckingEnabled() || loadOptions.isSecondLevelCacheCheckingEnabled()) {
            return this.loadFromCaches(loadOptions, entityKey, result, i, new LoadEvent(id, this.getLoadable().getJavaType().getJavaTypeClass().getName(), lockOptions, session, LoaderHelper.getReadOnlyFromLoadQueryInfluencers(session)));
        }
        return false;
    }

    private boolean loadFromCaches(MultiIdLoadOptions loadOptions, EntityKey entityKey, List<Object> result, int i, LoadEvent loadEvent) {
        CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry;
        Object managedEntity = null;
        if (loadOptions.isSessionCheckingEnabled() && (managedEntity = (persistenceContextEntry = CacheEntityLoaderHelper.loadFromSessionCacheStatic(loadEvent, entityKey, LoadEventListener.GET)).getEntity()) != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !persistenceContextEntry.isManaged()) {
            result.add(i, null);
            return true;
        }
        if (managedEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled()) {
            managedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(loadEvent, this.getLoadable().getEntityPersister(), entityKey);
        }
        if (managedEntity != null) {
            result.add(i, managedEntity);
            return true;
        }
        return false;
    }

    protected List<T> unorderedMultiLoad(Object[] ids, MultiIdLoadOptions loadOptions, LockOptions lockOptions, EventSource session) {
        ArrayList result = CollectionHelper.arrayList(ids.length);
        Object[] unresolvableIds = this.resolveInCachesIfEnabled(ids, loadOptions, lockOptions, session, (position, entityKey, resolvedRef) -> result.add(resolvedRef));
        if (!CollectionHelper.isEmpty(unresolvableIds)) {
            this.loadEntitiesWithUnresolvedIds(loadOptions, lockOptions, session, unresolvableIds, result);
        }
        return result;
    }

    protected abstract void loadEntitiesWithUnresolvedIds(MultiIdLoadOptions var1, LockOptions var2, EventSource var3, Object[] var4, List<T> var5);

    protected final <R> Object[] resolveInCachesIfEnabled(Object[] ids, @NonNull MultiIdLoadOptions loadOptions, @NonNull LockOptions lockOptions, EventSource session, ResolutionConsumer<R> resolutionConsumer) {
        return loadOptions.isSessionCheckingEnabled() || loadOptions.isSecondLevelCacheCheckingEnabled() ? this.resolveInCaches(ids, loadOptions, lockOptions, session, resolutionConsumer) : ids;
    }

    protected final <R> Object[] resolveInCaches(Object[] ids, MultiIdLoadOptions loadOptions, LockOptions lockOptions, EventSource session, ResolutionConsumer<R> resolutionConsumer) {
        boolean idCoercionEnabled = this.isIdCoercionEnabled();
        JavaType<?> idType = this.getLoadable().getIdentifierMapping().getJavaType();
        List<Object> unresolvedIds = null;
        for (int i = 0; i < ids.length; ++i) {
            Object id = idCoercionEnabled ? idType.coerce(ids[i], session) : ids[i];
            EntityKey entityKey = new EntityKey(id, this.getLoadable().getEntityPersister());
            unresolvedIds = this.loadFromCaches(id, entityKey, i, unresolvedIds, loadOptions, resolutionConsumer, new LoadEvent(id, this.getLoadable().getJavaType().getJavaTypeClass().getName(), lockOptions, session, LoaderHelper.getReadOnlyFromLoadQueryInfluencers(session)));
        }
        if (CollectionHelper.isEmpty(unresolvedIds)) {
            return null;
        }
        if (unresolvedIds.size() == ids.length) {
            return ids;
        }
        return unresolvedIds.toArray(this.idArray);
    }

    private boolean isIdCoercionEnabled() {
        return !this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled();
    }

    private <R, K> List<K> loadFromCaches(K id, EntityKey entityKey, int i, List<K> unresolvedIds, MultiIdLoadOptions loadOptions, ResolutionConsumer<R> resolutionConsumer, LoadEvent loadEvent) {
        Object cachedEntity = null;
        CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry = CacheEntityLoaderHelper.loadFromSessionCacheStatic(loadEvent, entityKey, LoadEventListener.GET);
        if (loadOptions.isSessionCheckingEnabled() && (cachedEntity = persistenceContextEntry.getEntity()) != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !persistenceContextEntry.isManaged()) {
            resolutionConsumer.consume(i, entityKey, null);
            return unresolvedIds;
        }
        if (cachedEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled()) {
            cachedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(loadEvent, this.getLoadable().getEntityPersister(), entityKey);
        }
        if (cachedEntity != null) {
            resolutionConsumer.consume(i, entityKey, cachedEntity);
        } else {
            if (unresolvedIds == null) {
                unresolvedIds = new ArrayList<K>();
            }
            unresolvedIds.add(id);
        }
        return unresolvedIds;
    }

    public static interface ResolutionConsumer<T> {
        public void consume(int var1, EntityKey var2, T var3);
    }
}

