/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal;

import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.ExcludeDefaultListeners;
import jakarta.persistence.ExcludeSuperclassListeners;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PersistenceException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.models.spi.GlobalRegistrations;
import org.hibernate.boot.models.spi.JpaEventListener;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.event.internal.EmbeddableCallback;
import org.hibernate.jpa.event.internal.EntityCallback;
import org.hibernate.jpa.event.internal.ListenerCallback;
import org.hibernate.jpa.event.spi.CallbackDefinition;
import org.hibernate.jpa.event.spi.CallbackType;
import org.hibernate.mapping.Property;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.property.access.spi.Getter;
import org.jboss.logging.Logger;

public final class CallbackDefinitionResolver {
    private static final Logger log = Logger.getLogger(CallbackDefinitionResolver.class);
    private static boolean useAnnotationAnnotatedByListener = false;

    public static List<CallbackDefinition> resolveEntityCallbacks(MetadataBuildingContext metadataBuildingContext, ClassDetails entityClass, CallbackType callbackType) {
        InFlightMetadataCollector metadataCollector = metadataBuildingContext.getMetadataCollector();
        GlobalRegistrations globalRegistrations = metadataCollector.getGlobalRegistrations();
        List<JpaEventListener> globalListenerRegistrations = globalRegistrations.getEntityListenerRegistrations();
        SourceModelBuildingContext sourceModelContext = metadataCollector.getSourceModelBuildingContext();
        ArrayList<CallbackDefinition> callbackDefinitions = new ArrayList<CallbackDefinition>();
        ArrayList<String> callbacksMethodNames = new ArrayList<String>();
        ArrayList<ClassDetails> orderedListeners = new ArrayList<ClassDetails>();
        ClassDetails currentClazz = entityClass;
        boolean stopListeners = false;
        boolean stopDefaultListeners = false;
        do {
            EntityCallback.Definition callbackDefinition = null;
            List methodsDetailsList = currentClazz.getMethods();
            for (MethodDetails methodDetails : methodsDetailsList) {
                if (!methodDetails.hasDirectAnnotationUsage(callbackType.getCallbackAnnotation()) || callbacksMethodNames.contains(methodDetails.getName())) continue;
                if (callbackDefinition == null) {
                    Method javaMethod = (Method)methodDetails.toJavaMember();
                    callbackDefinition = new EntityCallback.Definition(javaMethod, callbackType);
                    Class<?> returnType = javaMethod.getReturnType();
                    Class<?>[] args = javaMethod.getParameterTypes();
                    if (returnType != Void.TYPE || args.length != 0) {
                        throw new RuntimeException("Callback methods annotated on the bean class must return void and take no arguments: " + callbackType.getCallbackAnnotation().getName() + " - " + methodDetails);
                    }
                    ReflectHelper.ensureAccessibility(javaMethod);
                    if (log.isDebugEnabled()) {
                        log.debugf("Adding %s as %s callback for entity %s", (Object)methodDetails.getName(), (Object)callbackType.getCallbackAnnotation().getSimpleName(), (Object)entityClass.getName());
                    }
                    callbackDefinitions.add(0, callbackDefinition);
                    callbacksMethodNames.add(0, methodDetails.getName());
                    continue;
                }
                throw new PersistenceException("You can only annotate one callback method with " + callbackType.getCallbackAnnotation().getName() + " in bean class: " + entityClass.getName());
            }
            if (!stopListeners) {
                CallbackDefinitionResolver.applyListeners(currentClazz, orderedListeners, sourceModelContext);
                stopListeners = currentClazz.hasDirectAnnotationUsage(ExcludeSuperclassListeners.class);
                stopDefaultListeners = currentClazz.hasDirectAnnotationUsage(ExcludeDefaultListeners.class);
            }
            while ((currentClazz = currentClazz.getSuperClass()) != null && !currentClazz.hasDirectAnnotationUsage(Entity.class) && !currentClazz.hasDirectAnnotationUsage(MappedSuperclass.class)) {
            }
        } while (currentClazz != null);
        if (!stopDefaultListeners && CollectionHelper.isNotEmpty(globalListenerRegistrations)) {
            int defaultListenerSize = globalListenerRegistrations.size();
            for (int i = defaultListenerSize - 1; i >= 0; --i) {
                orderedListeners.add(globalListenerRegistrations.get(i).getCallbackClass());
            }
        }
        for (ClassDetails listenerClassDetails : orderedListeners) {
            ListenerCallback.Definition callbackDefinition = null;
            if (listenerClassDetails == null) continue;
            for (MethodDetails methodDetails : listenerClassDetails.getMethods()) {
                if (!methodDetails.hasDirectAnnotationUsage(callbackType.getCallbackAnnotation())) continue;
                String methodName = methodDetails.getName();
                if (callbackDefinition == null) {
                    Method method = (Method)methodDetails.toJavaMember();
                    callbackDefinition = new ListenerCallback.Definition(listenerClassDetails.toJavaClass(), method, callbackType);
                    Class<?> returnType = method.getReturnType();
                    Class<?>[] args = method.getParameterTypes();
                    if (returnType != Void.TYPE || args.length != 1) {
                        throw new PersistenceException("Callback methods annotated in a listener bean class must return void and take one argument: " + callbackType.getCallbackAnnotation().getName() + " - " + methodDetails);
                    }
                    ReflectHelper.ensureAccessibility(method);
                    if (log.isDebugEnabled()) {
                        log.debugf("Adding %s as %s callback for entity %s", (Object)methodName, (Object)callbackType.getCallbackAnnotation().getSimpleName(), (Object)entityClass.getName());
                    }
                    callbackDefinitions.add(0, callbackDefinition);
                    continue;
                }
                throw new PersistenceException("You can only annotate one callback method with " + callbackType.getCallbackAnnotation().getName() + " in bean class: " + entityClass.getName() + " and callback listener: " + listenerClassDetails.getName());
            }
        }
        return callbackDefinitions;
    }

    public static List<CallbackDefinition> resolveEmbeddableCallbacks(MetadataBuildingContext metadataBuildingContext, Class<?> entityClass, Property embeddableProperty, CallbackType callbackType) {
        SourceModelBuildingContext hibernateModelsContext = metadataBuildingContext.getMetadataCollector().getSourceModelBuildingContext();
        ClassDetailsRegistry classDetailsRegistry = hibernateModelsContext.getClassDetailsRegistry();
        Class<?> embeddableClass = embeddableProperty.getType().getReturnedClass();
        ClassDetails embeddableClassDetails = classDetailsRegistry.getClassDetails(embeddableClass.getName());
        Getter embeddableGetter = embeddableProperty.getGetter(entityClass);
        ArrayList<CallbackDefinition> callbackDefinitions = new ArrayList<CallbackDefinition>();
        ArrayList<String> callbacksMethodNames = new ArrayList<String>();
        ClassDetails currentClazz = embeddableClassDetails;
        do {
            EmbeddableCallback.Definition callbackDefinition = null;
            List methodsDetailsList = currentClazz.getMethods();
            for (MethodDetails methodDetails : methodsDetailsList) {
                if (!methodDetails.hasDirectAnnotationUsage(callbackType.getCallbackAnnotation())) continue;
                Method method = (Method)methodDetails.toJavaMember();
                String methodName = method.getName();
                if (callbacksMethodNames.contains(methodName)) {
                    throw new PersistenceException("You can only annotate one callback method with " + callbackType.getCallbackAnnotation().getName() + " in bean class: " + currentClazz.getName());
                }
                if (callbackDefinition != null) continue;
                callbackDefinition = new EmbeddableCallback.Definition(embeddableGetter, method, callbackType);
                Class<?> returnType = method.getReturnType();
                Class<?>[] args = method.getParameterTypes();
                if (returnType != Void.TYPE || args.length != 0) {
                    throw new RuntimeException("Callback methods annotated on the bean class must return void and take no arguments: " + callbackType.getCallbackAnnotation().getName() + " - " + methodDetails);
                }
                ReflectHelper.ensureAccessibility(method);
                if (log.isDebugEnabled()) {
                    log.debugf("Adding %s as %s callback for entity %s", (Object)methodName, (Object)callbackType.getCallbackAnnotation().getSimpleName(), (Object)currentClazz.getName());
                }
                callbackDefinitions.add(0, callbackDefinition);
                callbacksMethodNames.add(0, methodName);
            }
            while ((currentClazz = currentClazz.getSuperClass()) != null && !currentClazz.hasDirectAnnotationUsage(MappedSuperclass.class)) {
            }
        } while (currentClazz != null);
        return callbackDefinitions;
    }

    private static void applyListeners(ClassDetails currentClazz, List<ClassDetails> listOfListeners, SourceModelBuildingContext sourceModelContext) {
        ClassDetailsRegistry classDetailsRegistry = sourceModelContext.getClassDetailsRegistry();
        EntityListeners entityListeners = (EntityListeners)currentClazz.getDirectAnnotationUsage(EntityListeners.class);
        if (entityListeners != null) {
            Class[] listeners = entityListeners.value();
            int size = listeners.length;
            for (int index = size - 1; index >= 0; --index) {
                listOfListeners.add(classDetailsRegistry.resolveClassDetails(listeners[index].getName()));
            }
        }
        if (useAnnotationAnnotatedByListener) {
            List metaAnnotatedUsageList = currentClazz.getMetaAnnotated(EntityListeners.class, sourceModelContext);
            for (Annotation metaAnnotatedUsage : metaAnnotatedUsageList) {
                AnnotationDescriptor descriptor = sourceModelContext.getAnnotationDescriptorRegistry().getDescriptor(metaAnnotatedUsage.getClass());
                EntityListeners metaAnnotatedListeners = (EntityListeners)descriptor.getDirectAnnotationUsage(EntityListeners.class);
                Class[] listeners = metaAnnotatedListeners.value();
                for (int index = listeners.length - 1; index >= 0; --index) {
                    listOfListeners.add(sourceModelContext.getClassDetailsRegistry().resolveClassDetails(listeners[index].getName()));
                }
            }
        }
    }

    static {
        Target target = EntityListeners.class.getAnnotation(Target.class);
        if (target != null) {
            for (ElementType type : target.value()) {
                if (!type.equals((Object)ElementType.ANNOTATION_TYPE)) continue;
                useAnnotationAnnotatedByListener = true;
                break;
            }
        }
    }
}

