/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.util.function.Supplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.StaleStateException;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.BatchFailedException;
import org.hibernate.jdbc.BatchedTooManyRowsAffectedException;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.TooManyRowsAffectedException;

public class Expectations {
    private static final @UnknownKeyFor @NonNull @Initialized CoreMessageLogger LOG = CoreLogging.messageLogger(Expectations.class);
    static final @UnknownKeyFor @NonNull @Initialized SqlExceptionHelper sqlExceptionHelper = new SqlExceptionHelper(false);
    @Deprecated(since="6.5")
    public static final @UnknownKeyFor @NonNull @Initialized Expectation NONE = new Expectation.None();
    @Deprecated(since="6.5")
    public static final @UnknownKeyFor @NonNull @Initialized Expectation BASIC = new Expectation.RowCount();
    @Deprecated(since="6.5")
    public static final @UnknownKeyFor @NonNull @Initialized Expectation PARAM = new Expectation.OutParameter();

    @Internal
    public static @UnknownKeyFor @NonNull @Initialized Expectation createExpectation(@UnknownKeyFor @NonNull @Initialized Supplier<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Expectation> expectation, @UnknownKeyFor @NonNull @Initialized boolean callable) {
        Expectation instance = Expectations.instantiate(expectation, callable);
        instance.validate(callable);
        return instance;
    }

    private static @UnknownKeyFor @NonNull @Initialized Expectation instantiate(@UnknownKeyFor @NonNull @Initialized Supplier<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Expectation> supplier, @UnknownKeyFor @NonNull @Initialized boolean callable) {
        if (supplier == null) {
            return callable ? new Expectation.OutParameter() : new Expectation.RowCount();
        }
        return supplier.get();
    }

    static @UnknownKeyFor @NonNull @Initialized CallableStatement toCallableStatement(@UnknownKeyFor @NonNull @Initialized PreparedStatement statement) {
        if (statement instanceof CallableStatement) {
            return (CallableStatement)statement;
        }
        throw new HibernateException("Expectation.OutParameter operates exclusively on CallableStatements: " + statement.getClass());
    }

    static void checkBatched(@UnknownKeyFor @NonNull @Initialized int expectedRowCount, @UnknownKeyFor @NonNull @Initialized int rowCount, @UnknownKeyFor @NonNull @Initialized int batchPosition, @UnknownKeyFor @NonNull @Initialized String sql) {
        switch (rowCount) {
            case -3: {
                throw new BatchFailedException("Batch update failed: " + batchPosition);
            }
            case -2: {
                LOG.debugf("Success of batch update unknown: %s", batchPosition);
                break;
            }
            default: {
                if (expectedRowCount > rowCount) {
                    throw new StaleStateException("Batch update returned unexpected row count from update " + batchPosition + Expectations.actualVsExpected(expectedRowCount, rowCount) + " [" + sql + "]");
                }
                if (expectedRowCount >= rowCount) break;
                throw new BatchedTooManyRowsAffectedException("Batch update returned unexpected row count from update " + batchPosition + Expectations.actualVsExpected(expectedRowCount, rowCount), expectedRowCount, rowCount, batchPosition);
            }
        }
    }

    static void checkNonBatched(@UnknownKeyFor @NonNull @Initialized int expectedRowCount, @UnknownKeyFor @NonNull @Initialized int rowCount, @UnknownKeyFor @NonNull @Initialized String sql) {
        if (expectedRowCount > rowCount) {
            throw new StaleStateException("Unexpected row count" + Expectations.actualVsExpected(expectedRowCount, rowCount) + " [" + sql + "]");
        }
        if (expectedRowCount < rowCount) {
            throw new TooManyRowsAffectedException("Unexpected row count" + Expectations.actualVsExpected(expectedRowCount, rowCount), 1, rowCount);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String actualVsExpected(@UnknownKeyFor @NonNull @Initialized int expectedRowCount, @UnknownKeyFor @NonNull @Initialized int rowCount) {
        return " (expected row count " + expectedRowCount + " but was " + rowCount + ")";
    }

    private Expectations() {
    }
}

