/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.lang.invoke.MethodHandles;
import javax.naming.NamingException;
import org.hibernate.engine.jndi.JndiException;
import org.hibernate.engine.jndi.JndiNameException;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.factoryRegistry", description="Logging related to session factory registry")
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=20100, max=20400)
public interface SessionFactoryRegistryMessageLogger
extends BasicLogger {
    public static final String LOGGER_NAME = "org.hibernate.orm.factoryRegistry";
    public static final SessionFactoryRegistryMessageLogger INSTANCE = (SessionFactoryRegistryMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), SessionFactoryRegistryMessageLogger.class, (String)"org.hibernate.orm.factoryRegistry");

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Naming exception occurred accessing factory: %s", id=20178)
    public void namingExceptionAccessingFactory(NamingException var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Bound factory to JNDI name: %s", id=20194)
    public void factoryBoundToJndiName(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="A factory was renamed from [%s] to [%s] in JNDI", id=20196)
    public void factoryJndiRename(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Could not bind JNDI listener", id=20127)
    public void couldNotBindJndiListener();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Invalid JNDI name: %s", id=20135)
    public void invalidJndiName(String var1, @Cause JndiNameException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not bind factory to JNDI", id=20277)
    public void unableToBindFactoryToJndi(@Cause JndiException var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unbound factory from JNDI name: %s", id=20197)
    public void factoryUnboundFromJndiName(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="A factory was unbound from name: %s", id=20198)
    public void factoryUnboundFromName(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not unbind factory from JNDI", id=20374)
    public void unableToUnbindFactoryFromJndi(@Cause JndiException var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Registering SessionFactory: %s (%s)", id=20384)
    public void registeringSessionFactory(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Attempting to bind SessionFactory [%s] to JNDI", id=20280)
    public void attemptingToBindFactoryToJndi(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Attempting to unbind SessionFactory [%s] from JNDI", id=20281)
    public void attemptingToUnbindFactoryFromJndi(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="A SessionFactory was successfully bound to name: %s", id=20282)
    public void factoryBoundToJndi(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Not binding SessionFactory to JNDI, no JNDI name configured", id=20385)
    public void notBindingSessionFactory();
}

