/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.uuid;

import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.Internal;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.UUIDGenerationStrategy;
import org.hibernate.id.uuid.UuidValueGenerator;

public class UuidVersion6Strategy
implements UUIDGenerationStrategy,
UuidValueGenerator {
    public static final UuidVersion6Strategy INSTANCE = new UuidVersion6Strategy();
    private final AtomicReference<State> lastState;

    @Internal
    public UuidVersion6Strategy() {
        this(Long.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Internal
    public UuidVersion6Strategy(long initialTimestamp, int initialSequence) {
        this.lastState = new AtomicReference<State>(new State(initialTimestamp, initialSequence));
    }

    @Override
    public int getGeneratedVersion() {
        return 6;
    }

    @Override
    public UUID generateUUID(SharedSessionContractImplementor session) {
        return this.generateUuid(session);
    }

    @Override
    public UUID generateUuid(SharedSessionContractImplementor session) {
        State state = this.lastState.updateAndGet(State::getNextState);
        return new UUID(state.lastTimestamp << 4 & 0xFFFFFFFFFFFF0000L | 0x6000L | state.lastTimestamp & 0xFFFL, Long.MIN_VALUE | (long)state.lastSequence << 48 | UuidVersion6Strategy.randomNode());
    }

    private static long randomNode() {
        return Holder.numberGenerator.nextLong(0x1000000000000L) | 0x100000000000L;
    }

    private record State(long lastTimestamp, int lastSequence) {
        public State getNextState() {
            long now = State.instantToTimestamp();
            if (this.lastTimestamp < now) {
                return new State(now, State.randomSequence());
            }
            if (this.lastSequence == 16383) {
                return new State(this.lastTimestamp + 1L, State.randomSequence());
            }
            return new State(this.lastTimestamp, this.lastSequence + 1);
        }

        private static int randomSequence() {
            return Holder.numberGenerator.nextInt(16384);
        }

        private static long instantToTimestamp() {
            Instant instant = Instant.now();
            long seconds = instant.getEpochSecond() - Holder.EPOCH_1582_SECONDS;
            return seconds * 10000000L + (long)(instant.getNano() / 100);
        }
    }

    private static class Holder {
        static final SecureRandom numberGenerator = new SecureRandom();
        static final long EPOCH_1582_SECONDS = LocalDate.of(1582, 10, 15).atStartOfDay(ZoneId.of("UTC")).toInstant().getEpochSecond();

        private Holder() {
        }
    }
}

