/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.generator.values.AbstractGeneratedValuesMutationDelegate;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.internal.GeneratedValuesHelper;
import org.hibernate.id.insert.Binder;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;

public abstract class AbstractSelectingDelegate
extends AbstractGeneratedValuesMutationDelegate
implements InsertGeneratedIdentifierDelegate {
    protected AbstractSelectingDelegate(EntityPersister persister, EventType timing, boolean supportsArbitraryValues, boolean supportsRowId) {
        super(persister, timing, supportsArbitraryValues, supportsRowId);
    }

    protected abstract String getSelectSQL();

    protected void bindParameters(Object entity, PreparedStatement ps, SharedSessionContractImplementor session) throws SQLException {
    }

    private GeneratedValues extractReturningValues(ResultSet resultSet, SharedSessionContractImplementor session) throws SQLException {
        return GeneratedValuesHelper.getGeneratedValues(resultSet, this.persister, this.getTiming(), session);
    }

    @Override
    public PreparedStatement prepareStatement(String insertSql, SharedSessionContractImplementor session) {
        return session.getJdbcCoordinator().getMutationStatementPreparer().prepareStatement(insertSql, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GeneratedValues performMutation(PreparedStatementDetails statementDetails, JdbcValueBindings jdbcValueBindings, Object entity, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        JdbcServices jdbcServices = session.getJdbcServices();
        jdbcServices.getSqlStatementLogger().logStatement(statementDetails.getSqlString());
        try {
            jdbcValueBindings.beforeStatement(statementDetails);
            jdbcCoordinator.getResultSetReturn().executeUpdate(statementDetails.resolveStatement(), statementDetails.getSqlString());
        }
        finally {
            if (statementDetails.getStatement() != null) {
                statementDetails.releaseStatement(session);
            }
            jdbcValueBindings.afterStatement(statementDetails.getMutatingTableDetails());
            session.getJdbcCoordinator().afterStatementExecution();
        }
        String idSelectSql = this.getSelectSQL();
        PreparedStatement idSelect = jdbcCoordinator.getStatementPreparer().prepareStatement(idSelectSql);
        try {
            this.bindParameters(entity, idSelect, session);
            ResultSet resultSet = session.getJdbcCoordinator().getResultSetReturn().extract(idSelect, idSelectSql);
            try {
                GeneratedValues generatedValues = this.extractReturningValues(resultSet, session);
                return generatedValues;
            }
            catch (SQLException e) {
                throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to execute post-insert id selection query", idSelectSql);
            }
            finally {
                session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(idSelect);
                session.getJdbcCoordinator().afterStatementExecution();
            }
        }
        catch (SQLException e) {
            throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to bind parameters for post-insert id selection query", idSelectSql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public final GeneratedValues performInsertReturning(String sql, SharedSessionContractImplementor session, Binder binder) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        StatementPreparer statementPreparer = jdbcCoordinator.getStatementPreparer();
        try {
            PreparedStatement insert = statementPreparer.prepareStatement(sql, 2);
            try {
                binder.bindValues(insert);
                jdbcCoordinator.getResultSetReturn().executeUpdate(insert, sql);
            }
            finally {
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(insert);
                jdbcCoordinator.afterStatementExecution();
            }
        }
        catch (SQLException sqle) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(sqle, "could not insert: " + MessageHelper.infoString(this.persister), sql);
        }
        String selectSQL = this.getSelectSQL();
        try {
            PreparedStatement idSelect = statementPreparer.prepareStatement(selectSQL, false);
            try {
                this.bindParameters(binder.getEntity(), idSelect, session);
                ResultSet resultSet = jdbcCoordinator.getResultSetReturn().extract(idSelect, selectSQL);
                try {
                    GeneratedValues generatedValues = this.extractReturningValues(resultSet, session);
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(resultSet, idSelect);
                    return generatedValues;
                }
                catch (Throwable throwable) {
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(resultSet, idSelect);
                    throw throwable;
                }
            }
            finally {
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(idSelect);
                jdbcCoordinator.afterStatementExecution();
            }
        }
        catch (SQLException sqle) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(sqle, "could not retrieve generated id after insert: " + MessageHelper.infoString(this.persister), selectSQL);
        }
    }
}

