/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.hibernate.id.enhanced.InitialValueAwareOptimizer;
import org.hibernate.id.enhanced.NoopOptimizer;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerDescriptor;
import org.hibernate.id.enhanced.StandardOptimizerDescriptor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class OptimizerFactory {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)OptimizerFactory.class.getName());
    private static final Class<?>[] CTOR_SIG = new Class[]{Class.class, Integer.TYPE};

    private static Optimizer buildOptimizer(OptimizerDescriptor descriptor, Class<?> returnClass, int incrementSize) {
        Class<? extends Optimizer> optimizerClass;
        try {
            optimizerClass = descriptor.getOptimizerClass();
        }
        catch (Throwable ignore) {
            LOG.unableToLocateCustomOptimizerClass(descriptor.getExternalName());
            return OptimizerFactory.buildFallbackOptimizer(returnClass, incrementSize);
        }
        try {
            Constructor<? extends Optimizer> ctor = optimizerClass.getConstructor(CTOR_SIG);
            return ctor.newInstance(returnClass, incrementSize);
        }
        catch (Throwable ignore) {
            LOG.unableToInstantiateOptimizer(descriptor.getExternalName());
            return OptimizerFactory.buildFallbackOptimizer(returnClass, incrementSize);
        }
    }

    private static Optimizer buildFallbackOptimizer(Class<?> returnClass, int incrementSize) {
        return new NoopOptimizer(returnClass, incrementSize);
    }

    public static Optimizer buildOptimizer(OptimizerDescriptor type, Class<?> returnClass, int incrementSize, long explicitInitialValue) {
        Optimizer optimizer = OptimizerFactory.buildOptimizer(type, returnClass, incrementSize);
        if (optimizer instanceof InitialValueAwareOptimizer) {
            ((InitialValueAwareOptimizer)((Object)optimizer)).injectInitialValue(explicitInitialValue);
        }
        return optimizer;
    }

    public static String determineImplicitOptimizerName(int incrementSize, Properties configSettings) {
        if (incrementSize <= 1) {
            return StandardOptimizerDescriptor.NONE.getExternalName();
        }
        String preferredPooledOptimizerStrategy = configSettings.getProperty("hibernate.id.optimizer.pooled.preferred");
        if (StringHelper.isNotEmpty(preferredPooledOptimizerStrategy)) {
            return preferredPooledOptimizerStrategy;
        }
        return StandardOptimizerDescriptor.POOLED.getExternalName();
    }

    private OptimizerFactory() {
    }
}

