/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import jakarta.persistence.GenerationType;
import jakarta.persistence.SequenceGenerator;
import java.lang.reflect.Member;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.model.internal.GeneratorParameters;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.ExportableProducer;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.AnnotationBasedGenerator;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.id.uuid.UuidGenerator;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.persister.entity.EntityPersister;

public class NativeGenerator
implements OnExecutionGenerator,
BeforeExecutionGenerator,
Configurable,
ExportableProducer,
AnnotationBasedGenerator<org.hibernate.annotations.NativeGenerator> {
    private GenerationType generationType;
    private org.hibernate.annotations.NativeGenerator annotation;
    private Generator dialectNativeGenerator;

    public GenerationType getGenerationType() {
        return this.generationType;
    }

    @Override
    public EnumSet<EventType> getEventTypes() {
        return this.dialectNativeGenerator.getEventTypes();
    }

    @Override
    public boolean generatedOnExecution() {
        return this.dialectNativeGenerator.generatedOnExecution();
    }

    @Override
    public void initialize(org.hibernate.annotations.NativeGenerator annotation, Member member, GeneratorCreationContext context) {
        this.annotation = annotation;
        this.generationType = context.getDatabase().getDialect().getNativeValueGenerationStrategy();
        switch (this.generationType) {
            case TABLE: {
                this.dialectNativeGenerator = new TableGenerator();
                break;
            }
            case IDENTITY: {
                this.dialectNativeGenerator = new IdentityGenerator();
                context.getProperty().getValue().getColumns().get(0).setIdentity(true);
                break;
            }
            case UUID: {
                this.dialectNativeGenerator = new UuidGenerator(context.getType().getReturnedClass());
                break;
            }
            default: {
                assert (this.generationType == GenerationType.AUTO || this.generationType == GenerationType.SEQUENCE);
                this.dialectNativeGenerator = new SequenceStyleGenerator();
            }
        }
    }

    @Override
    public void configure(GeneratorCreationContext creationContext, Properties parameters) {
        Generator generator = this.dialectNativeGenerator;
        if (generator instanceof SequenceStyleGenerator) {
            SequenceStyleGenerator sequenceStyleGenerator = (SequenceStyleGenerator)generator;
            this.applyProperties(parameters, this.annotation.sequenceForm(), creationContext);
            sequenceStyleGenerator.configure(creationContext, parameters);
        } else {
            generator = this.dialectNativeGenerator;
            if (generator instanceof TableGenerator) {
                TableGenerator tableGenerator = (TableGenerator)generator;
                this.applyProperties(parameters, this.annotation.tableForm(), creationContext);
                tableGenerator.configure(creationContext, parameters);
            }
        }
    }

    @Override
    public void registerExportables(Database database) {
        Generator generator = this.dialectNativeGenerator;
        if (generator instanceof ExportableProducer) {
            ExportableProducer exportableProducer = (ExportableProducer)((Object)generator);
            exportableProducer.registerExportables(database);
        }
    }

    @Override
    public void initialize(SqlStringGenerationContext context) {
        Generator generator = this.dialectNativeGenerator;
        if (generator instanceof Configurable) {
            Configurable configurable = (Configurable)((Object)generator);
            configurable.initialize(context);
        }
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object owner, Object currentValue, EventType eventType) {
        return ((BeforeExecutionGenerator)this.dialectNativeGenerator).generate(session, owner, currentValue, eventType);
    }

    @Override
    public boolean referenceColumnsInSql(Dialect dialect) {
        return ((OnExecutionGenerator)this.dialectNativeGenerator).referenceColumnsInSql(dialect);
    }

    @Override
    public boolean writePropertyValue() {
        return ((OnExecutionGenerator)this.dialectNativeGenerator).writePropertyValue();
    }

    @Override
    public String[] getReferencedColumnValues(Dialect dialect) {
        return ((OnExecutionGenerator)this.dialectNativeGenerator).getReferencedColumnValues(dialect);
    }

    @Override
    public InsertGeneratedIdentifierDelegate getGeneratedIdentifierDelegate(EntityPersister persister) {
        return ((OnExecutionGenerator)this.dialectNativeGenerator).getGeneratedIdentifierDelegate(persister);
    }

    private void applyProperties(Properties properties, SequenceGenerator sequenceAnnotation, GeneratorCreationContext creationContext) {
        Properties mapRef = properties;
        mapRef.put("GENERATOR_NAME", sequenceAnnotation.name());
        NativeGenerator.applyCommonConfiguration(mapRef, creationContext);
        SequenceStyleGenerator.applyConfiguration(sequenceAnnotation, mapRef::put);
    }

    private void applyProperties(Properties properties, jakarta.persistence.TableGenerator tableGenerator, GeneratorCreationContext creationContext) {
        Properties mapRef = properties;
        mapRef.put("GENERATOR_NAME", tableGenerator.name());
        NativeGenerator.applyCommonConfiguration(mapRef, creationContext);
        TableGenerator.applyConfiguration(tableGenerator, mapRef::put);
    }

    private static void applyCommonConfiguration(Map<String, Object> mapRef, GeneratorCreationContext context) {
        GeneratorParameters.collectParameters((SimpleValue)context.getProperty().getValue(), context.getDatabase().getDialect(), context.getRootClass(), mapRef::put);
        mapRef.put("increment_size", 1);
    }
}

