/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator.values.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.generator.internal.NaturalIdHelper;
import org.hibernate.generator.values.GeneratedValueBasicResultBuilder;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.GeneratedValuesMutationDelegate;
import org.hibernate.generator.values.internal.GeneratedValuesImpl;
import org.hibernate.generator.values.internal.GeneratedValuesMappingProducer;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.insert.GetGeneratedKeysDelegate;
import org.hibernate.id.insert.InsertReturningDelegate;
import org.hibernate.id.insert.UniqueKeySelectingDelegate;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.query.results.TableGroupImpl;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.results.internal.ResultsHelper;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerArrayImpl;
import org.hibernate.sql.results.jdbc.internal.DirectResultSetAccess;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesResultSetImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.type.descriptor.WrapperOptions;

@Internal
public class GeneratedValuesHelper {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(IdentifierGeneratorHelper.class);

    public static GeneratedValues getGeneratedValues(ResultSet resultSet, EntityPersister persister, EventType timing, WrapperOptions wrapperOptions) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        GeneratedValuesMutationDelegate delegate = persister.getMutationDelegate(timing == EventType.INSERT ? MutationType.INSERT : MutationType.UPDATE);
        GeneratedValuesMappingProducer mappingProducer = (GeneratedValuesMappingProducer)delegate.getGeneratedValuesMappingProducer();
        List<GeneratedValueBasicResultBuilder> resultBuilders = mappingProducer.getResultBuilders();
        ArrayList<BasicValuedModelPart> generatedProperties = new ArrayList<BasicValuedModelPart>(resultBuilders.size());
        for (GeneratedValueBasicResultBuilder resultBuilder : resultBuilders) {
            generatedProperties.add(resultBuilder.getModelPart());
        }
        GeneratedValuesImpl generatedValues = new GeneratedValuesImpl(generatedProperties);
        Object[] results = GeneratedValuesHelper.readGeneratedValues(resultSet, persister, mappingProducer, wrapperOptions.getSession());
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Extracted generated values %s: %s", MessageHelper.infoString(persister), results);
        }
        for (int i = 0; i < results.length; ++i) {
            generatedValues.addGeneratedValue((ModelPart)generatedProperties.get(i), results[i]);
        }
        return generatedValues;
    }

    private static Object[] readGeneratedValues(ResultSet resultSet, EntityPersister persister, JdbcValuesMappingProducer mappingProducer, SharedSessionContractImplementor session) {
        DirectResultSetAccess directResultSetAccess;
        BaseExecutionContext executionContext = new BaseExecutionContext(session);
        try {
            directResultSetAccess = new DirectResultSetAccess(session, (PreparedStatement)resultSet.getStatement(), resultSet);
        }
        catch (SQLException e) {
            throw new HibernateException("Could not retrieve statement from generated values result set", e);
        }
        JdbcValuesResultSetImpl jdbcValues = new JdbcValuesResultSetImpl(directResultSetAccess, null, null, QueryOptions.NONE, true, mappingProducer.resolve(directResultSetAccess, session.getLoadQueryInfluencers(), session.getSessionFactory()), null, executionContext);
        JdbcValuesSourceProcessingOptions processingOptions = new JdbcValuesSourceProcessingOptions(){

            @Override
            public Object getEffectiveOptionalObject() {
                return null;
            }

            @Override
            public String getEffectiveOptionalEntityName() {
                return null;
            }

            @Override
            public Object getEffectiveOptionalId() {
                return null;
            }

            @Override
            public boolean shouldReturnProxies() {
                return true;
            }
        };
        JdbcValuesSourceProcessingStateStandardImpl valuesProcessingState = new JdbcValuesSourceProcessingStateStandardImpl(executionContext, processingOptions);
        RowReader<Object[]> rowReader = ResultsHelper.createRowReader(session.getFactory(), RowTransformerArrayImpl.instance(), Object[].class, jdbcValues);
        RowProcessingStateStandardImpl rowProcessingState = new RowProcessingStateStandardImpl(valuesProcessingState, executionContext, rowReader, jdbcValues);
        Object results = ListResultsConsumer.instance(ListResultsConsumer.UniqueSemantic.NONE).consume((JdbcValues)jdbcValues, session, processingOptions, valuesProcessingState, rowProcessingState, (RowReader)rowReader);
        if (results.isEmpty()) {
            throw new HibernateException("The database returned no natively generated values : " + persister.getNavigableRole().getFullPath());
        }
        return (Object[])results.get(0);
    }

    public static GeneratedValuesMappingProducer createMappingProducer(EntityPersister persister, EventType timing, boolean supportsArbitraryValues, boolean supportsRowId) {
        NavigablePath parentNavigablePath = new NavigablePath(persister.getEntityName());
        TableGroupImpl tableGroup = new TableGroupImpl(parentNavigablePath, null, new NamedTableReference("t", "t"), persister);
        List<? extends ModelPart> generatedProperties = GeneratedValuesHelper.getActualGeneratedModelParts(persister, timing, supportsArbitraryValues, supportsRowId);
        GeneratedValuesMappingProducer mappingProducer = new GeneratedValuesMappingProducer();
        for (int i = 0; i < generatedProperties.size(); ++i) {
            ModelPart modelPart = generatedProperties.get(i);
            BasicValuedModelPart basicModelPart = modelPart.asBasicValuedModelPart();
            if (basicModelPart == null) {
                throw new UnsupportedOperationException("Unsupported generated ModelPart: " + modelPart.getPartName());
            }
            GeneratedValueBasicResultBuilder resultBuilder = new GeneratedValueBasicResultBuilder(parentNavigablePath.append(basicModelPart.getSelectableName()), basicModelPart, tableGroup, supportsArbitraryValues ? Integer.valueOf(i) : null);
            mappingProducer.addResultBuilder(resultBuilder);
        }
        return mappingProducer;
    }

    public static BasicValuedModelPart getActualGeneratedModelPart(BasicValuedModelPart modelPart) {
        return modelPart.isEntityIdentifierMapping() ? modelPart.findContainingEntityMapping().getRootEntityDescriptor().getIdentifierMapping().asBasicValuedModelPart() : modelPart;
    }

    private static List<? extends ModelPart> getActualGeneratedModelParts(EntityPersister persister, EventType timing, boolean supportsArbitraryValues, boolean supportsRowId) {
        if (timing == EventType.INSERT) {
            List<? extends ModelPart> generatedProperties;
            List<? extends ModelPart> list = generatedProperties = supportsArbitraryValues ? persister.getInsertGeneratedProperties() : List.of(persister.getIdentifierMapping());
            if (persister.getRowIdMapping() != null && supportsRowId) {
                ArrayList<? extends ModelPart> newList = new ArrayList<ModelPart>(generatedProperties.size() + 1);
                newList.addAll(generatedProperties);
                newList.add(persister.getRowIdMapping());
                return Collections.unmodifiableList(newList);
            }
            return generatedProperties;
        }
        return persister.getUpdateGeneratedProperties();
    }

    public static GeneratedValuesMutationDelegate getGeneratedValuesDelegate(EntityPersister persister, EventType timing) {
        List<? extends ModelPart> generatedProperties = persister.getGeneratedProperties(timing);
        boolean hasGeneratedProperties = !generatedProperties.isEmpty();
        boolean hasFormula = generatedProperties.stream().anyMatch(part -> {
            SelectableMapping selectable;
            return part instanceof SelectableMapping && (selectable = (SelectableMapping)((Object)part)).isFormula();
        });
        boolean hasRowId = timing == EventType.INSERT && persister.getRowIdMapping() != null;
        Dialect dialect = persister.getFactory().getJdbcServices().getDialect();
        if (hasRowId && dialect.supportsInsertReturning() && dialect.supportsInsertReturningRowId() && GeneratedValuesHelper.noCustomSql(persister, timing)) {
            return new InsertReturningDelegate(persister, timing);
        }
        if (!hasGeneratedProperties) {
            return null;
        }
        if (!hasFormula && dialect.supportsInsertReturningGeneratedKeys() && persister.getFactory().getSessionFactoryOptions().isGetGeneratedKeysEnabled()) {
            return new GetGeneratedKeysDelegate(persister, false, timing);
        }
        if (GeneratedValuesHelper.supportsReturning(dialect, timing) && GeneratedValuesHelper.noCustomSql(persister, timing)) {
            return new InsertReturningDelegate(persister, timing);
        }
        if (timing == EventType.INSERT && persister.getNaturalIdentifierProperties() != null && !persister.getEntityMetamodel().isNaturalIdentifierInsertGenerated()) {
            return new UniqueKeySelectingDelegate(persister, NaturalIdHelper.getNaturalIdPropertyNames(persister), timing);
        }
        return null;
    }

    private static boolean supportsReturning(Dialect dialect, EventType timing) {
        return timing == EventType.INSERT ? dialect.supportsInsertReturning() : dialect.supportsUpdateReturning();
    }

    public static boolean noCustomSql(EntityPersister persister, EventType timing) {
        EntityTableMapping identifierTable = persister.getIdentifierTableMapping();
        TableMapping.MutationDetails mutationDetails = timing == EventType.INSERT ? identifierTable.getInsertDetails() : identifierTable.getUpdateDetails();
        return mutationDetails.getCustomSql() == null;
    }
}

