/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.spi;

import jakarta.persistence.PessimisticLockScope;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;

public class LockEvent
extends AbstractEvent {
    private Object object;
    private final LockOptions lockOptions;
    private String entityName;

    public LockEvent(String entityName, Object original, LockMode lockMode, EventSource source) {
        this(original, lockMode, source);
        this.entityName = entityName;
    }

    public LockEvent(String entityName, Object original, LockOptions lockOptions, EventSource source) {
        this(original, lockOptions, source);
        this.entityName = entityName;
    }

    public LockEvent(Object object, LockMode lockMode, EventSource source) {
        super(source);
        this.object = object;
        this.lockOptions = lockMode.toLockOptions();
    }

    public LockEvent(Object object, LockOptions lockOptions, EventSource source) {
        super(source);
        this.object = object;
        this.lockOptions = lockOptions;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    public LockMode getLockMode() {
        return this.lockOptions.getLockMode();
    }

    public int getLockTimeout() {
        return this.lockOptions.getTimeOut();
    }

    public boolean getLockScope() {
        return this.lockOptions.getLockScope() == PessimisticLockScope.EXTENDED;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }
}

