/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.type.Type;

public final class TypedValue
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized Type type;
    private final @UnknownKeyFor @NonNull @Initialized Object value;
    private transient @UnknownKeyFor @NonNull @Initialized ValueHolder<@UnknownKeyFor @NonNull @Initialized Integer> hashcode;

    public TypedValue(@UnknownKeyFor @NonNull @Initialized Type type, @UnknownKeyFor @NonNull @Initialized Object value) {
        this.type = type;
        this.value = value;
        this.hashcode = TypedValue.hashCode(type, value);
    }

    public @UnknownKeyFor @NonNull @Initialized Object getValue() {
        return this.value;
    }

    public @UnknownKeyFor @NonNull @Initialized Type getType() {
        return this.type;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.value == null ? "null" : this.value.toString();
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.hashcode.getValue();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TypedValue that = (TypedValue)other;
        return this.type.getReturnedClass() == that.type.getReturnedClass() && this.type.isEqual(that.value, this.value);
    }

    private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream ois) throws @UnknownKeyFor @NonNull @Initialized ClassNotFoundException, @UnknownKeyFor @NonNull @Initialized IOException {
        ois.defaultReadObject();
        this.hashcode = TypedValue.hashCode(this.type, this.value);
    }

    private static @UnknownKeyFor @NonNull @Initialized ValueHolder<@UnknownKeyFor @NonNull @Initialized Integer> hashCode(@UnknownKeyFor @NonNull @Initialized Type type, @UnknownKeyFor @NonNull @Initialized Object value) {
        return new ValueHolder<ValueHolder.DeferredInitializer<Integer>>(() -> value == null ? 0 : type.getHashCode(value));
    }
}

