/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.jdbc.connections.internal.DatasourceConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.internal.UserSuppliedConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentImpl;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.internal.Helper;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class ConnectionProviderInitiator
implements StandardServiceInitiator<ConnectionProvider> {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ConnectionProviderInitiator.class);
    public static final ConnectionProviderInitiator INSTANCE = new ConnectionProviderInitiator();
    public static final String C3P0_STRATEGY = "c3p0";
    public static final String PROXOOL_STRATEGY = "proxool";
    public static final String HIKARI_STRATEGY = "hikari";
    public static final String VIBUR_STRATEGY = "vibur";
    public static final String UCP_STRATEGY = "ucp";
    public static final String AGROAL_STRATEGY = "agroal";
    private static final Set<String> SPECIAL_PROPERTIES = new HashSet<String>();
    private static final Map<String, Integer> ISOLATION_VALUE_MAP;
    private static final Map<Integer, String> ISOLATION_VALUE_CONSTANT_NAME_MAP;
    private static final Map<Integer, String> ISOLATION_VALUE_NICE_NAME_MAP;
    private static final Map<String, String> CONDITIONAL_PROPERTIES;

    @Override
    public Class<ConnectionProvider> getServiceInitiated() {
        return ConnectionProvider.class;
    }

    @Override
    public ConnectionProvider initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        if (JdbcEnvironmentImpl.isMultiTenancyEnabled(registry)) {
            return null;
        }
        BeanContainer beanContainer = Helper.allowExtensionsInCdi(registry) ? registry.requireService(ManagedBeanRegistry.class).getBeanContainer() : null;
        StrategySelector strategySelector = registry.requireService(StrategySelector.class);
        Object explicitSetting = configurationValues.get("hibernate.connection.provider_class");
        if (explicitSetting != null) {
            if (explicitSetting instanceof ConnectionProvider) {
                ConnectionProvider provider = (ConnectionProvider)explicitSetting;
                return provider;
            }
            if (explicitSetting instanceof Class) {
                Class providerClass = (Class)explicitSetting;
                LOG.instantiatingExplicitConnectionProvider(providerClass.getName());
                return this.instantiateExplicitConnectionProvider(providerClass, beanContainer);
            }
            String providerName = StringHelper.nullIfEmpty(explicitSetting.toString());
            if (providerName != null) {
                return this.instantiateNamedConnectionProvider(providerName, strategySelector, beanContainer);
            }
        }
        return this.instantiateConnectionProvider(configurationValues, strategySelector, beanContainer);
    }

    private ConnectionProvider instantiateNamedConnectionProvider(String providerName, StrategySelector strategySelector, BeanContainer beanContainer) {
        LOG.instantiatingExplicitConnectionProvider(providerName);
        Class<ConnectionProvider> providerClass = strategySelector.selectStrategyImplementor(ConnectionProvider.class, providerName);
        try {
            return this.instantiateExplicitConnectionProvider(providerClass, beanContainer);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate connection provider [" + providerName + "]", e);
        }
    }

    private ConnectionProvider instantiateConnectionProvider(Map<String, Object> configurationValues, StrategySelector strategySelector, BeanContainer beanContainer) {
        if (configurationValues.containsKey("hibernate.connection.datasource")) {
            return new DatasourceConnectionProviderImpl();
        }
        Class<? extends ConnectionProvider> singleRegisteredProvider = this.getSingleRegisteredProvider(strategySelector);
        if (singleRegisteredProvider != null) {
            try {
                return singleRegisteredProvider.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new HibernateException("Could not instantiate singular-registered ConnectionProvider", e);
            }
        }
        if (ConnectionProviderInitiator.hasConfiguration(configurationValues, "hibernate.c3p0")) {
            return ConnectionProviderInitiator.instantiateProvider(strategySelector, C3P0_STRATEGY);
        }
        if (ConnectionProviderInitiator.hasConfiguration(configurationValues, "hibernate.proxool")) {
            return ConnectionProviderInitiator.instantiateProvider(strategySelector, PROXOOL_STRATEGY);
        }
        if (ConnectionProviderInitiator.hasConfiguration(configurationValues, "hibernate.hikari")) {
            return ConnectionProviderInitiator.instantiateProvider(strategySelector, HIKARI_STRATEGY);
        }
        if (ConnectionProviderInitiator.hasConfiguration(configurationValues, "hibernate.vibur")) {
            return ConnectionProviderInitiator.instantiateProvider(strategySelector, VIBUR_STRATEGY);
        }
        if (ConnectionProviderInitiator.hasConfiguration(configurationValues, "hibernate.oracleucp")) {
            return ConnectionProviderInitiator.instantiateProvider(strategySelector, UCP_STRATEGY);
        }
        if (ConnectionProviderInitiator.hasConfiguration(configurationValues, "hibernate.agroal")) {
            return ConnectionProviderInitiator.instantiateProvider(strategySelector, AGROAL_STRATEGY);
        }
        if (configurationValues.containsKey("hibernate.connection.url")) {
            return new DriverManagerConnectionProviderImpl();
        }
        if (beanContainer != null) {
            return beanContainer.getBean(ConnectionProvider.class, new BeanContainer.LifecycleOptions(){

                @Override
                public boolean canUseCachedReferences() {
                    return true;
                }

                @Override
                public boolean useJpaCompliantCreation() {
                    return true;
                }
            }, new BeanInstanceProducer(){

                @Override
                public <B> B produceBeanInstance(Class<B> beanType) {
                    return (B)ConnectionProviderInitiator.this.noAppropriateConnectionProvider();
                }

                @Override
                public <B> B produceBeanInstance(String name, Class<B> beanType) {
                    return (B)ConnectionProviderInitiator.this.noAppropriateConnectionProvider();
                }
            }).getBeanInstance();
        }
        return this.noAppropriateConnectionProvider();
    }

    private ConnectionProvider noAppropriateConnectionProvider() {
        LOG.noAppropriateConnectionProvider();
        return new UserSuppliedConnectionProviderImpl();
    }

    private Class<? extends ConnectionProvider> getSingleRegisteredProvider(StrategySelector strategySelector) {
        Collection<Class<ConnectionProvider>> implementors = strategySelector.getRegisteredStrategyImplementors(ConnectionProvider.class);
        return implementors != null && implementors.size() == 1 ? implementors.iterator().next() : null;
    }

    private ConnectionProvider instantiateExplicitConnectionProvider(Class<?> providerClass, BeanContainer beanContainer) {
        try {
            if (beanContainer != null) {
                return (ConnectionProvider)beanContainer.getBean(providerClass, new BeanContainer.LifecycleOptions(){

                    @Override
                    public boolean canUseCachedReferences() {
                        return true;
                    }

                    @Override
                    public boolean useJpaCompliantCreation() {
                        return true;
                    }
                }, FallbackBeanInstanceProducer.INSTANCE).getBeanInstance();
            }
            return (ConnectionProvider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate connection provider [" + providerClass.getName() + "]", e);
        }
    }

    private static ConnectionProvider instantiateProvider(StrategySelector selector, String strategy) {
        try {
            return selector.selectStrategyImplementor(ConnectionProvider.class, strategy).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.providerClassNotFound(strategy);
            return null;
        }
    }

    public static Properties getConnectionProperties(Map<String, Object> properties) {
        Properties result = new Properties();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Object object = entry.getKey();
            if (!(object instanceof String)) continue;
            String key = object;
            object = entry.getValue();
            if (!(object instanceof String)) continue;
            String value = (String)object;
            if (key.startsWith("hibernate.connection")) {
                if (SPECIAL_PROPERTIES.contains(key)) {
                    if (!"hibernate.connection.username".equals(key)) continue;
                    result.setProperty("user", value);
                    continue;
                }
                result.setProperty(key.substring("hibernate.connection".length() + 1), value);
                continue;
            }
            if (!CONDITIONAL_PROPERTIES.containsKey(key)) continue;
            result.setProperty(CONDITIONAL_PROPERTIES.get(key), value);
        }
        return result;
    }

    public static Integer extractIsolation(Map<String, ?> settings) {
        return ConnectionProviderInitiator.interpretIsolation(settings.get("hibernate.connection.isolation"));
    }

    public static Integer interpretIsolation(Object setting) {
        if (setting == null) {
            return null;
        }
        if (setting instanceof Number) {
            Number number = (Number)setting;
            return number.intValue();
        }
        String string = setting.toString();
        if (StringHelper.isEmpty(string)) {
            return null;
        }
        if (ISOLATION_VALUE_MAP.containsKey(string)) {
            return ISOLATION_VALUE_MAP.get(string);
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new HibernateException("Could not interpret transaction isolation setting [" + setting + "]");
        }
    }

    public static String toIsolationConnectionConstantName(Integer isolation) {
        String name = ISOLATION_VALUE_CONSTANT_NAME_MAP.get(isolation);
        if (name == null) {
            throw new HibernateException("Could not convert isolation value [" + isolation + "] to java.sql.Connection constant name");
        }
        return name;
    }

    public static String toIsolationNiceName(Integer isolation) {
        String name = isolation != null ? ISOLATION_VALUE_NICE_NAME_MAP.get(isolation) : null;
        return name == null ? "<unknown>" : name;
    }

    public static String extractSetting(Map<String, Object> settings, String ... names) {
        for (String name : names) {
            if (!settings.containsKey(name)) continue;
            return (String)settings.get(name);
        }
        return null;
    }

    public static void consumeSetting(Map<String, Object> settings, SettingConsumer consumer, String ... names) {
        for (String name : names) {
            if (!settings.containsKey(name)) continue;
            consumer.consumeSetting(name, (String)settings.get(name));
            return;
        }
    }

    private static boolean hasConfiguration(Map<String, Object> configValues, String namespace) {
        String prefix = namespace + ".";
        for (String key : configValues.keySet()) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static {
        SPECIAL_PROPERTIES.add("hibernate.connection.datasource");
        SPECIAL_PROPERTIES.add("hibernate.connection.url");
        SPECIAL_PROPERTIES.add("hibernate.connection.provider_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.pool_size");
        SPECIAL_PROPERTIES.add("hibernate.connection.isolation");
        SPECIAL_PROPERTIES.add("hibernate.connection.driver_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.username");
        SPECIAL_PROPERTIES.add("hibernate.connection.provider_disables_autocommit");
        ISOLATION_VALUE_MAP = new ConcurrentHashMap<String, Integer>();
        ISOLATION_VALUE_MAP.put("TRANSACTION_NONE", 0);
        ISOLATION_VALUE_MAP.put("NONE", 0);
        ISOLATION_VALUE_MAP.put("TRANSACTION_READ_UNCOMMITTED", 1);
        ISOLATION_VALUE_MAP.put("READ_UNCOMMITTED", 1);
        ISOLATION_VALUE_MAP.put("TRANSACTION_READ_COMMITTED", 2);
        ISOLATION_VALUE_MAP.put("READ_COMMITTED", 2);
        ISOLATION_VALUE_MAP.put("TRANSACTION_REPEATABLE_READ", 4);
        ISOLATION_VALUE_MAP.put("REPEATABLE_READ", 4);
        ISOLATION_VALUE_MAP.put("TRANSACTION_SERIALIZABLE", 8);
        ISOLATION_VALUE_MAP.put("SERIALIZABLE", 8);
        ISOLATION_VALUE_CONSTANT_NAME_MAP = new ConcurrentHashMap<Integer, String>();
        ISOLATION_VALUE_CONSTANT_NAME_MAP.put(0, "TRANSACTION_NONE");
        ISOLATION_VALUE_CONSTANT_NAME_MAP.put(1, "TRANSACTION_READ_UNCOMMITTED");
        ISOLATION_VALUE_CONSTANT_NAME_MAP.put(2, "TRANSACTION_READ_COMMITTED");
        ISOLATION_VALUE_CONSTANT_NAME_MAP.put(4, "TRANSACTION_REPEATABLE_READ");
        ISOLATION_VALUE_CONSTANT_NAME_MAP.put(8, "TRANSACTION_SERIALIZABLE");
        ISOLATION_VALUE_NICE_NAME_MAP = new ConcurrentHashMap<Integer, String>();
        ISOLATION_VALUE_NICE_NAME_MAP.put(0, "NONE");
        ISOLATION_VALUE_NICE_NAME_MAP.put(1, "READ_UNCOMMITTED");
        ISOLATION_VALUE_NICE_NAME_MAP.put(2, "READ_COMMITTED");
        ISOLATION_VALUE_NICE_NAME_MAP.put(4, "REPEATABLE_READ");
        ISOLATION_VALUE_NICE_NAME_MAP.put(8, "SERIALIZABLE");
        CONDITIONAL_PROPERTIES = Map.of("hibernate.synonyms", "includeSynonyms");
    }

    @FunctionalInterface
    public static interface SettingConsumer {
        public void consumeSetting(String var1, String var2);
    }
}

