/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import java.util.List;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.spi.TypeConfiguration;

public class XmlConcatFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public XmlConcatFunction(TypeConfiguration typeConfiguration) {
        super("xmlconcat", FunctionKind.NORMAL, StandardArgumentsValidators.composite(new ArgumentTypesValidator(StandardArgumentsValidators.min(2), FunctionParameterType.XML)), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(String.class, 2009)), StandardFunctionArgumentTypeResolvers.impliedOrInvariant(typeConfiguration, FunctionParameterType.XML));
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("xmlconcat");
        int separator = 40;
        for (SqlAstNode sqlAstNode : sqlAstArguments) {
            sqlAppender.appendSql((char)separator);
            sqlAstNode.accept(walker);
            separator = 44;
        }
        sqlAppender.appendSql(')');
    }
}

