/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import java.util.List;
import org.hibernate.dialect.function.json.ExpressionTypeHelper;
import org.hibernate.dialect.function.xml.XmlQueryFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerXmlQueryFunction
extends XmlQueryFunction {
    public SQLServerXmlQueryFunction(TypeConfiguration typeConfiguration) {
        super(false, typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        boolean needsCast;
        Expression xmlDocument = (Expression)sqlAstArguments.get(1);
        boolean bl = needsCast = !ExpressionTypeHelper.isXml(xmlDocument);
        if (needsCast) {
            sqlAppender.appendSql("cast(");
        }
        sqlAstArguments.get(1).accept(walker);
        if (needsCast) {
            sqlAppender.appendSql(" as xml)");
        }
        sqlAppender.appendSql(".query(");
        sqlAstArguments.get(0).accept(walker);
        sqlAppender.appendSql(')');
    }
}

