/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.xml.XmlTableFunction;
import org.hibernate.dialect.function.xml.XmlTableSetReturningFunctionTypeResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmXmlTableFunction;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.internal.ColumnQualifierCollectorSqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.XmlTableQueryColumnDefinition;
import org.hibernate.sql.ast.tree.from.FunctionTableGroup;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class HANAXmlTableFunction
extends XmlTableFunction {
    public HANAXmlTableFunction(TypeConfiguration typeConfiguration) {
        super(false, new DB2XmlTableSetReturningFunctionTypeResolver(), typeConfiguration);
    }

    @Override
    protected <T> SelfRenderingSqmSetReturningFunction<T> generateSqmSetReturningFunctionExpression(List<? extends SqmTypedNode<?>> arguments, QueryEngine queryEngine) {
        return new SqmXmlTableFunction<T>(this, this, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), queryEngine.getCriteriaBuilder(), (SqmExpression)arguments.get(0), (SqmExpression)arguments.get(1)){

            @Override
            public TableGroup convertToSqlAst(NavigablePath navigablePath, String identifierVariable, boolean lateral, boolean canUseInnerJoins, boolean withOrdinality, SqmToSqlAstConverter walker) {
                FunctionTableGroup functionTableGroup = (FunctionTableGroup)super.convertToSqlAst(navigablePath, identifierVariable, lateral, canUseInnerJoins, withOrdinality, walker);
                List<? extends SqlAstNode> sqlArguments = functionTableGroup.getPrimaryTableReference().getFunctionExpression().getArguments();
                Expression document = (Expression)sqlArguments.get(1);
                Set<String> qualifiers = ColumnQualifierCollectorSqlAstWalker.determineColumnQualifiers(document);
                if (qualifiers.size() == 1) {
                    String tableQualifier = qualifiers.iterator().next();
                    FromClauseAccess fromClauseAccess = walker.getFromClauseAccess();
                    TableGroup sourceTableGroup = fromClauseAccess.findTableGroupByIdentificationVariable(tableQualifier);
                    if (sourceTableGroup != null) {
                        ArrayList<ColumnInfo> idColumns = new ArrayList<ColumnInfo>();
                        this.addIdColumns(sourceTableGroup.getModelPart(), idColumns);
                        walker.registerQueryTransformer((cteContainer, querySpec, converter) -> {
                            String cteName;
                            String baseName = "_data";
                            int index = 0;
                            while (cteContainer.getCteStatement(cteName = "_data" + index++) != null) {
                            }
                            TableGroup parentTableGroup = querySpec.getFromClause().queryTableGroups(tg -> tg.findTableGroupJoin(functionTableGroup) == null ? null : tg);
                            TableGroupJoin join = parentTableGroup.findTableGroupJoin(functionTableGroup);
                            Expression lhs = this.createExpression(tableQualifier, idColumns);
                            Expression rhs = this.createExpression(functionTableGroup.getPrimaryTableReference().getIdentificationVariable(), idColumns);
                            join.applyPredicate(new ComparisonPredicate(lhs, ComparisonOperator.EQUAL, rhs));
                            String tableName = cteName;
                            List<CteColumn> cteColumns = List.of(new CteColumn("v", document.getExpressionType().getSingleJdbcMapping()));
                            QuerySpec cteQuery = new QuerySpec(false);
                            cteQuery.getFromClause().addRoot(new StandardTableGroup(true, sourceTableGroup.getNavigablePath(), (TableGroupProducer)sourceTableGroup.getModelPart(), false, null, sourceTableGroup.findTableReference(tableQualifier), false, null, joinTableName -> false, (joinTableName, tg) -> null, null));
                            XmlWrapperExpression wrapperExpression = new XmlWrapperExpression(idColumns, tableQualifier, document);
                            cteQuery.applyPredicate(new NullnessPredicate(document, true));
                            cteQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(wrapperExpression));
                            cteContainer.addCteStatement(new CteStatement(new CteTable(tableName, cteColumns), new SelectStatement(cteQuery)));
                            sqlArguments.set(1, new TableColumnReferenceExpression(document, tableName, idColumns));
                            return querySpec;
                        });
                    }
                }
                return functionTableGroup;
            }

            private Expression createExpression(String qualifier, List<ColumnInfo> idColumns) {
                if (idColumns.size() == 1) {
                    ColumnInfo columnInfo = idColumns.get(0);
                    return new ColumnReference(qualifier, columnInfo.name(), false, null, columnInfo.jdbcMapping());
                }
                ArrayList<ColumnReference> expressions = new ArrayList<ColumnReference>(idColumns.size());
                for (ColumnInfo columnInfo : idColumns) {
                    expressions.add(new ColumnReference(qualifier, columnInfo.name(), false, null, columnInfo.jdbcMapping()));
                }
                return new SqlTuple(expressions, null);
            }

            private void addIdColumns(ModelPartContainer modelPartContainer, List<ColumnInfo> idColumns) {
                if (modelPartContainer instanceof EntityValuedModelPart) {
                    EntityValuedModelPart entityValuedModelPart = (EntityValuedModelPart)modelPartContainer;
                    this.addIdColumns(entityValuedModelPart.getEntityMappingType(), idColumns);
                } else if (modelPartContainer instanceof PluralAttributeMapping) {
                    PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)modelPartContainer;
                    this.addIdColumns(pluralAttributeMapping, idColumns);
                } else if (modelPartContainer instanceof EmbeddableValuedModelPart) {
                    EmbeddableValuedModelPart embeddableModelPart = (EmbeddableValuedModelPart)modelPartContainer;
                    this.addIdColumns(embeddableModelPart, idColumns);
                } else {
                    throw new QueryException("Unsupported model part container: " + modelPartContainer);
                }
            }

            private void addIdColumns(EmbeddableValuedModelPart embeddableModelPart, List<ColumnInfo> idColumns) {
                if (embeddableModelPart instanceof EmbeddedCollectionPart) {
                    EmbeddedCollectionPart collectionPart = (EmbeddedCollectionPart)embeddableModelPart;
                    this.addIdColumns(collectionPart.getCollectionAttribute(), idColumns);
                } else {
                    this.addIdColumns(embeddableModelPart.asAttributeMapping().getDeclaringType(), idColumns);
                }
            }

            private void addIdColumns(PluralAttributeMapping pluralAttributeMapping, List<ColumnInfo> idColumns) {
                DdlTypeRegistry ddlTypeRegistry = pluralAttributeMapping.getCollectionDescriptor().getFactory().getTypeConfiguration().getDdlTypeRegistry();
                this.addIdColumns(pluralAttributeMapping.getKeyDescriptor().getKeyPart(), ddlTypeRegistry, idColumns);
            }

            private void addIdColumns(EntityMappingType entityMappingType, List<ColumnInfo> idColumns) {
                DdlTypeRegistry ddlTypeRegistry = entityMappingType.getEntityPersister().getFactory().getTypeConfiguration().getDdlTypeRegistry();
                this.addIdColumns(entityMappingType.getIdentifierMapping(), ddlTypeRegistry, idColumns);
            }

            private void addIdColumns(ValuedModelPart modelPart, DdlTypeRegistry ddlTypeRegistry, List<ColumnInfo> idColumns) {
                modelPart.forEachSelectable((selectionIndex, selectableMapping) -> {
                    JdbcMapping jdbcMapping = selectableMapping.getJdbcMapping().getSingleJdbcMapping();
                    idColumns.add(new ColumnInfo(selectableMapping.getSelectionExpression(), jdbcMapping, ddlTypeRegistry.getTypeName(jdbcMapping.getJdbcType().getDefaultSqlTypeCode(), selectableMapping.toSize(), (Type)((Object)jdbcMapping))));
                });
            }
        };
    }

    @Override
    protected void renderXmlTable(SqlAppender sqlAppender, XmlTableFunction.XmlTableArguments arguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("xmltable(");
        Expression documentExpression = arguments.xmlDocument();
        String xpath = (String)walker.getLiteralValue(arguments.xpath());
        if (documentExpression instanceof TableColumnReferenceExpression) {
            sqlAppender.appendSingleQuoteEscapedString("/root" + xpath);
        } else {
            sqlAppender.appendSingleQuoteEscapedString(xpath);
        }
        sqlAppender.appendSql(" passing ");
        if (documentExpression instanceof Literal) {
            Literal literal = (Literal)documentExpression;
            sqlAppender.appendSingleQuoteEscapedString((String)literal.getLiteralValue());
        } else if (AbstractSqlAstTranslator.isParameter(documentExpression)) {
            sqlAppender.appendSingleQuoteEscapedString((String)walker.getLiteralValue(documentExpression));
        } else {
            documentExpression.accept(walker);
        }
        this.renderColumns(sqlAppender, arguments.columnsClause(), walker);
        if (documentExpression instanceof TableColumnReferenceExpression) {
            TableColumnReferenceExpression expression = (TableColumnReferenceExpression)documentExpression;
            for (ColumnInfo columnInfo : expression.getIdColumns()) {
                sqlAppender.appendSql(',');
                sqlAppender.appendSql(columnInfo.name());
                sqlAppender.appendSql(' ');
                sqlAppender.appendSql(columnInfo.ddlType());
                sqlAppender.appendSql(" path '/root/@");
                sqlAppender.appendSql(columnInfo.name());
                sqlAppender.appendSql('\'');
            }
        }
        sqlAppender.appendSql(')');
    }

    @Override
    protected String determineColumnType(CastTarget castTarget, SqlAstTranslator<?> walker) {
        String typeName;
        return switch (typeName = super.determineColumnType(castTarget, walker)) {
            case "tinyint" -> {
                if (HANAXmlTableFunction.isBoolean(castTarget.getJdbcMapping())) {
                    yield "varchar(5)";
                }
                yield "integer";
            }
            case "smallint" -> "integer";
            case "boolean" -> "varchar(5)";
            case "float" -> "double";
            case "clob", "nclob" -> "nvarchar(5000)";
            default -> typeName;
        };
    }

    @Override
    protected void renderXmlQueryColumnDefinition(SqlAppender sqlAppender, XmlTableQueryColumnDefinition definition, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(' ');
        sqlAppender.appendSql(this.determineColumnType(new CastTarget(definition.type()), walker));
        sqlAppender.appendSql(" format xml");
        this.renderColumnPath(definition.name(), definition.xpath(), sqlAppender, walker);
        this.renderDefaultExpression(definition.defaultExpression(), sqlAppender, walker);
    }

    @Override
    protected void renderDefaultExpression(@Nullable Expression expression, SqlAppender sqlAppender, SqlAstTranslator<?> walker) {
        if (expression != null) {
            sqlAppender.appendSql(" default ");
            sqlAppender.appendSingleQuoteEscapedString((String)walker.getLiteralValue(expression));
        }
    }

    static boolean isBoolean(JdbcMapping type) {
        return type.getJdbcType().isBoolean();
    }

    private static class DB2XmlTableSetReturningFunctionTypeResolver
    extends XmlTableSetReturningFunctionTypeResolver {
        private DB2XmlTableSetReturningFunctionTypeResolver() {
        }

        @Override
        protected void addSelectableMapping(List<SelectableMapping> selectableMappings, String name, JdbcMapping type, SqmToSqlAstConverter converter) {
            if (HANAXmlTableFunction.isBoolean(type)) {
                JdbcLiteralFormatter jdbcLiteralFormatter = type.getJdbcLiteralFormatter();
                SessionFactoryImplementor sessionFactory = converter.getCreationContext().getSessionFactory();
                Dialect dialect = sessionFactory.getJdbcServices().getDialect();
                WrapperOptions wrapperOptions = sessionFactory.getWrapperOptions();
                Object trueValue = type.convertToRelationalValue(true);
                Object falseValue = type.convertToRelationalValue(false);
                String trueFragment = jdbcLiteralFormatter.toJdbcLiteral(trueValue, dialect, wrapperOptions);
                String falseFragment = jdbcLiteralFormatter.toJdbcLiteral(falseValue, dialect, wrapperOptions);
                selectableMappings.add(new SelectableMappingImpl("", name, new SelectablePath(name), "case {@}." + name + " when 'true' then " + trueFragment + " when 'false' then " + falseFragment + " end", null, "varchar(5)", null, null, null, null, false, false, false, false, false, false, type));
            } else {
                super.addSelectableMapping(selectableMappings, name, type, converter);
            }
        }
    }

    static class TableColumnReferenceExpression
    implements SelfRenderingExpression {
        private final Expression argument;
        private final String tableName;
        private final List<ColumnInfo> idColumns;

        public TableColumnReferenceExpression(Expression argument, String tableName, List<ColumnInfo> idColumns) {
            this.argument = argument;
            this.tableName = tableName;
            this.idColumns = idColumns;
        }

        @Override
        public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
            sqlAppender.appendSql(this.tableName);
            sqlAppender.appendSql(".v");
        }

        @Override
        public JdbcMappingContainer getExpressionType() {
            return this.argument.getExpressionType();
        }

        public List<ColumnInfo> getIdColumns() {
            return this.idColumns;
        }
    }

    record ColumnInfo(String name, JdbcMapping jdbcMapping, String ddlType) {
    }

    static class XmlWrapperExpression
    implements SelfRenderingExpression {
        private final List<ColumnInfo> idColumns;
        private final String tableQualifier;
        private final Expression argument;

        public XmlWrapperExpression(List<ColumnInfo> idColumns, String tableQualifier, Expression argument) {
            this.idColumns = idColumns;
            this.tableQualifier = tableQualifier;
            this.argument = argument;
        }

        @Override
        public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
            sqlAppender.appendSql("'<root'");
            for (ColumnInfo columnInfo : this.idColumns) {
                sqlAppender.appendSql("||' ");
                sqlAppender.appendSql(columnInfo.name());
                sqlAppender.appendSql("=\"'||");
                sqlAppender.appendSql(this.tableQualifier);
                sqlAppender.appendSql('.');
                sqlAppender.appendSql(columnInfo.name());
                sqlAppender.appendSql("||'\"'");
            }
            sqlAppender.appendSql("||'>'||");
            this.argument.accept(walker);
            sqlAppender.appendSql("||'</root>'");
        }

        @Override
        public JdbcMappingContainer getExpressionType() {
            return this.argument.getExpressionType();
        }
    }
}

