/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.dialect.function.json.ExpressionTypeHelper;
import org.hibernate.dialect.function.json.JsonObjectFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.JsonNullBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerJsonObjectFunction
extends JsonObjectFunction {
    private final boolean supportsExtendedJson;

    public SQLServerJsonObjectFunction(boolean supportsExtendedJson, TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true);
        this.supportsExtendedJson = supportsExtendedJson;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        if (this.supportsExtendedJson) {
            super.render(sqlAppender, sqlAstArguments, returnType, walker);
        } else if (sqlAstArguments.isEmpty()) {
            sqlAppender.appendSql("'{}'");
        } else {
            int argumentsCount;
            JsonNullBehavior nullBehavior;
            if ((sqlAstArguments.size() & 1) == 1) {
                nullBehavior = (JsonNullBehavior)sqlAstArguments.get(sqlAstArguments.size() - 1);
                argumentsCount = sqlAstArguments.size() - 1;
            } else {
                nullBehavior = JsonNullBehavior.NULL;
                argumentsCount = sqlAstArguments.size();
            }
            if (nullBehavior == JsonNullBehavior.ABSENT) {
                int i;
                for (i = 0; i < argumentsCount; i += 2) {
                    sqlAppender.appendSql("json_modify(");
                }
                sqlAppender.appendSql("'{}'");
                for (i = 0; i < argumentsCount; i += 2) {
                    sqlAppender.appendSql(",'$.'+");
                    sqlAstArguments.get(i).accept(walker);
                    sqlAppender.appendSql(',');
                    this.renderValue(sqlAppender, sqlAstArguments.get(i + 1), walker);
                    sqlAppender.appendSql(')');
                }
            } else {
                sqlAppender.appendSql("(select '{'+string_agg(substring(t.k,2,len(t.k)-2)");
                sqlAppender.appendSql("+':'+substring(t.d,2,len(t.d)-2),',')+'}' from (values");
                int separator = 32;
                for (int i = 0; i < argumentsCount; i += 2) {
                    sqlAppender.appendSql((char)separator);
                    sqlAppender.appendSql("(json_modify('[]','append $',");
                    sqlAstArguments.get(i).accept(walker);
                    sqlAppender.appendSql("),json_modify('[]','append $',");
                    this.renderValue(sqlAppender, sqlAstArguments.get(i + 1), walker);
                    sqlAppender.appendSql("))");
                    separator = 44;
                }
                sqlAppender.appendSql(") t(k,d))");
            }
        }
    }

    @Override
    protected void renderValue(SqlAppender sqlAppender, SqlAstNode value, SqlAstTranslator<?> walker) {
        if (ExpressionTypeHelper.isBoolean(value)) {
            sqlAppender.appendSql("cast(");
            value.accept(walker);
            sqlAppender.appendSql(" as bit)");
        } else if (!this.supportsExtendedJson && ExpressionTypeHelper.isJson(value)) {
            sqlAppender.appendSql("json_query(");
            value.accept(walker);
            sqlAppender.appendSql(')');
        } else {
            value.accept(walker);
        }
    }
}

