/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.dialect.function.json.ExpressionTypeHelper;
import org.hibernate.dialect.function.json.JsonArrayFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.JsonNullBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerJsonArrayFunction
extends JsonArrayFunction {
    private final boolean supportsExtendedJson;

    public SQLServerJsonArrayFunction(boolean supportsExtendedJson, TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
        this.supportsExtendedJson = supportsExtendedJson;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        if (this.supportsExtendedJson) {
            super.render(sqlAppender, sqlAstArguments, returnType, walker);
        } else if (sqlAstArguments.isEmpty()) {
            sqlAppender.appendSql("'[]'");
        } else {
            int argumentsCount;
            JsonNullBehavior nullBehavior;
            SqlAstNode lastArgument = sqlAstArguments.get(sqlAstArguments.size() - 1);
            if (lastArgument instanceof JsonNullBehavior) {
                nullBehavior = (JsonNullBehavior)lastArgument;
                argumentsCount = sqlAstArguments.size() - 1;
            } else {
                nullBehavior = JsonNullBehavior.ABSENT;
                argumentsCount = sqlAstArguments.size();
            }
            if (nullBehavior == JsonNullBehavior.ABSENT) {
                sqlAppender.appendSql("(select '['+string_agg(substring(t.d,2,len(t.d)-2),',')");
                sqlAppender.appendSql("within group (order by t.k)+']' from (values");
                int separator = 32;
                for (int i = 0; i < argumentsCount; ++i) {
                    sqlAppender.appendSql((char)separator);
                    sqlAppender.appendSql('(');
                    sqlAppender.appendSql(i);
                    sqlAppender.appendSql(",json_modify('[]','append $',");
                    this.renderValue(sqlAppender, sqlAstArguments.get(i), walker);
                    sqlAppender.appendSql("))");
                    separator = 44;
                }
                sqlAppender.appendSql(") t(k,d))");
            } else {
                int i;
                for (i = 0; i < argumentsCount; ++i) {
                    sqlAppender.appendSql("json_modify(");
                }
                sqlAppender.appendSql("'[]'");
                for (i = 0; i < argumentsCount; ++i) {
                    sqlAppender.appendSql(",'append $',");
                    this.renderValue(sqlAppender, sqlAstArguments.get(i), walker);
                    sqlAppender.appendSql(')');
                }
            }
        }
    }

    @Override
    protected void renderValue(SqlAppender sqlAppender, SqlAstNode value, SqlAstTranslator<?> walker) {
        if (ExpressionTypeHelper.isBoolean(value)) {
            sqlAppender.appendSql("cast(");
            value.accept(walker);
            sqlAppender.appendSql(" as bit)");
        } else if (!this.supportsExtendedJson && ExpressionTypeHelper.isJson(value)) {
            sqlAppender.appendSql("json_query(");
            value.accept(walker);
            sqlAppender.appendSql(')');
        } else {
            value.accept(walker);
        }
    }
}

