/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.dialect.function.json.AbstractJsonMergepatchFunction;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLJsonMergepatchFunction
extends AbstractJsonMergepatchFunction {
    public PostgreSQLJsonMergepatchFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        int i;
        sqlAppender.appendSql("(with recursive args");
        int separator = 40;
        for (i = 0; i < arguments.size(); ++i) {
            sqlAppender.appendSql((char)separator);
            sqlAppender.appendSql('d');
            sqlAppender.appendSql(i);
            separator = 44;
        }
        sqlAppender.appendSql(") as(select");
        separator = 32;
        for (i = 0; i < arguments.size(); ++i) {
            sqlAppender.appendSql((char)separator);
            this.renderJsonDocumentExpression(sqlAppender, translator, (Expression)arguments.get(i));
            separator = 44;
        }
        sqlAppender.appendSql("),");
        for (i = 0; i < arguments.size(); ++i) {
            this.renderKeyValueCte("val" + i, "d" + i, sqlAppender);
        }
        sqlAppender.appendSql("res(v,p,l) as(");
        sqlAppender.appendSql("select");
        sqlAppender.appendSql(" jsonb_object_agg(coalesce(");
        this.renderColumnList(sqlAppender, "k", arguments.size());
        sqlAppender.appendSql("),coalesce(");
        this.renderColumnList(sqlAppender, "v", arguments.size());
        sqlAppender.appendSql("))");
        sqlAppender.appendSql(",coalesce(");
        this.renderColumnList(sqlAppender, "p", arguments.size());
        sqlAppender.appendSql(")");
        sqlAppender.appendSql(",cardinality(coalesce(");
        this.renderColumnList(sqlAppender, "p", arguments.size());
        sqlAppender.appendSql("))");
        sqlAppender.appendSql(" from val0 v0");
        for (i = 1; i < arguments.size(); ++i) {
            sqlAppender.appendSql(" full join val");
            sqlAppender.appendSql(i);
            sqlAppender.appendSql(" v");
            sqlAppender.appendSql(i);
            sqlAppender.appendSql(" on v0.p=v");
            sqlAppender.appendSql(i);
            sqlAppender.appendSql(".p and v0.k=v");
            sqlAppender.appendSql(i);
            sqlAppender.appendSql(".k");
        }
        sqlAppender.appendSql(" where cardinality(coalesce(");
        this.renderColumnList(sqlAppender, "p", arguments.size());
        sqlAppender.appendSql("))=");
        sqlAppender.appendSql("(select cardinality(v.p) from val0 v");
        for (i = 1; i < arguments.size(); ++i) {
            sqlAppender.appendSql(" union select cardinality(v.p) from val");
            sqlAppender.appendSql(i);
            sqlAppender.appendSql(" v");
        }
        sqlAppender.appendSql(" order by 1 desc limit 1)");
        sqlAppender.appendSql(" and jsonb_typeof(coalesce(");
        this.renderColumnList(sqlAppender, "v", arguments.size(), 1);
        sqlAppender.appendSql(")) is distinct from 'null'");
        sqlAppender.appendSql(" group by");
        sqlAppender.appendSql(" coalesce(");
        this.renderColumnList(sqlAppender, "p", arguments.size());
        sqlAppender.appendSql(")");
        sqlAppender.appendSql(",cardinality(coalesce(");
        this.renderColumnList(sqlAppender, "p", arguments.size());
        sqlAppender.appendSql("))");
        sqlAppender.appendSql(" union all ");
        sqlAppender.appendSql("select");
        sqlAppender.appendSql(" jsonb_object_agg_strict(coalesce(");
        this.renderColumnList(sqlAppender, "k", arguments.size());
        sqlAppender.appendSql("),coalesce(case when coalesce(");
        this.renderColumnList(sqlAppender, "k", arguments.size());
        sqlAppender.appendSql(")=r.p[cardinality(r.p)] then r.v end,");
        this.renderColumnList(sqlAppender, "v", arguments.size());
        sqlAppender.appendSql("))");
        sqlAppender.appendSql(",coalesce(");
        this.renderColumnList(sqlAppender, "p", arguments.size());
        sqlAppender.appendSql(")");
        sqlAppender.appendSql(",r.l-1");
        sqlAppender.appendSql(" from val0 v0");
        for (i = 1; i < arguments.size(); ++i) {
            sqlAppender.appendSql(" full join val");
            sqlAppender.appendSql(i);
            sqlAppender.appendSql(" v");
            sqlAppender.appendSql(i);
            sqlAppender.appendSql(" on v0.p=v");
            sqlAppender.appendSql(i);
            sqlAppender.appendSql(".p and v0.k=v");
            sqlAppender.appendSql(i);
            sqlAppender.appendSql(".k");
        }
        sqlAppender.appendSql(" join (select * from res r order by r.l fetch first 1 rows with ties) r");
        sqlAppender.appendSql(" on cardinality(coalesce(");
        this.renderColumnList(sqlAppender, "p", arguments.size());
        sqlAppender.appendSql("))=r.l-1");
        sqlAppender.appendSql(" and jsonb_typeof(coalesce(");
        this.renderColumnList(sqlAppender, "v", arguments.size(), 1);
        sqlAppender.appendSql(")) is distinct from 'null'");
        sqlAppender.appendSql(" and r.l<>0");
        sqlAppender.appendSql(" group by");
        sqlAppender.appendSql(" coalesce(");
        this.renderColumnList(sqlAppender, "p", arguments.size());
        sqlAppender.appendSql(")");
        sqlAppender.appendSql(",r.l-1");
        sqlAppender.appendSql(") ");
        sqlAppender.appendSql("select r.v from res r where r.l=0)");
    }

    private void renderColumnList(SqlAppender sqlAppender, String column, int size) {
        this.renderColumnList(sqlAppender, column, size, 0);
    }

    private void renderColumnList(SqlAppender sqlAppender, String column, int size, int end) {
        sqlAppender.appendSql("v");
        sqlAppender.appendSql(size - 1);
        sqlAppender.appendSql('.');
        sqlAppender.appendSql(column);
        for (int i = size - 2; i >= end; --i) {
            sqlAppender.appendSql(",v");
            sqlAppender.appendSql(i);
            sqlAppender.appendSql('.');
            sqlAppender.appendSql(column);
        }
    }

    private void renderKeyValueCte(String cteName, String columnName, SqlAppender sqlAppender) {
        sqlAppender.appendSql(cteName);
        sqlAppender.appendSql("(p,k,v) as (");
        sqlAppender.appendSql("select '{}'::text[],s.k,t.");
        sqlAppender.appendSql(columnName);
        sqlAppender.appendSql("->s.k from args t join lateral jsonb_object_keys(t.");
        sqlAppender.appendSql(columnName);
        sqlAppender.appendSql(") s(k) on 1=1 union ");
        sqlAppender.appendSql("select v.p||v.k,s.k,v.v->s.k from ");
        sqlAppender.appendSql(cteName);
        sqlAppender.appendSql(" v");
        sqlAppender.appendSql(" join lateral jsonb_object_keys(v.v) s(k)");
        sqlAppender.appendSql(" on jsonb_typeof(v.v)='object'");
        sqlAppender.appendSql("),");
    }

    private void renderJsonDocumentExpression(SqlAppender sqlAppender, SqlAstTranslator<?> translator, Expression json) {
        boolean needsCast;
        boolean bl = needsCast = !this.isJsonType(json);
        if (needsCast) {
            sqlAppender.appendSql("cast(");
        }
        json.accept(translator);
        if (needsCast) {
            sqlAppender.appendSql(" as jsonb)");
        }
    }

    private boolean isJsonType(Expression expression) {
        JdbcMappingContainer expressionType = expression.getExpressionType();
        return expressionType != null && expressionType.getSingleJdbcMapping().getJdbcType().isJson();
    }
}

