/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.dialect.function.json.ExpressionTypeHelper;
import org.hibernate.dialect.function.json.JsonObjectFunction;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleJsonObjectFunction
extends JsonObjectFunction {
    private final CastTarget stringCastTarget;
    private CastFunction castFunction;

    public OracleJsonObjectFunction(boolean colonSyntax, TypeConfiguration typeConfiguration) {
        super(typeConfiguration, colonSyntax);
        this.stringCastTarget = new CastTarget(typeConfiguration.getBasicTypeForJavaType(String.class));
    }

    @Override
    protected void renderValue(SqlAppender sqlAppender, SqlAstNode value, SqlAstTranslator<?> walker) {
        if (ExpressionTypeHelper.isNonNativeBoolean(value)) {
            CastFunction castFunction = this.castFunction;
            if (castFunction == null) {
                castFunction = this.castFunction = (CastFunction)walker.getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("cast");
            }
            castFunction.render(sqlAppender, List.of(value, this.stringCastTarget), (ReturnableType)((Object)this.stringCastTarget.getJdbcMapping()), walker);
            sqlAppender.appendSql(" format json");
        } else {
            value.accept(walker);
            JdbcMappingContainer expressionType = ((Expression)value).getExpressionType();
            if (expressionType != null && expressionType.getSingleJdbcMapping().getJdbcType().isJson() && !SqlTypes.isJsonType(expressionType.getSingleJdbcMapping().getJdbcType().getDdlTypeCode())) {
                sqlAppender.appendSql(" format json");
            }
        }
    }
}

