/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import org.hibernate.QueryException;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.dialect.function.json.JsonTableFunction;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonExistsErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonQueryWrapMode;
import org.hibernate.sql.ast.tree.expression.JsonTableErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonTableExistsColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableNestedColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableQueryColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableValueColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonValueEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonValueErrorBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class MySQLJsonTableFunction
extends JsonTableFunction {
    public MySQLJsonTableFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
    }

    @Override
    protected void renderJsonTable(SqlAppender sqlAppender, JsonTableFunction.JsonTableArguments arguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        if (arguments.errorBehavior() == JsonTableErrorBehavior.NULL) {
            throw new QueryException("Can't emulate null on error clause on MySQL");
        }
        sqlAppender.appendSql("json_table(");
        arguments.jsonDocument().accept(walker);
        if (arguments.jsonPath() == null) {
            sqlAppender.appendSql(",'$'");
        } else {
            sqlAppender.appendSql(',');
            JsonPathPassingClause passingClause = arguments.passingClause();
            if (passingClause != null) {
                JsonPathHelper.appendInlinedJsonPathIncludingPassingClause(sqlAppender, "", arguments.jsonPath(), passingClause, walker);
            } else {
                arguments.jsonPath().accept(walker);
            }
        }
        this.renderColumns(sqlAppender, arguments.columnsClause(), 0, walker);
        sqlAppender.appendSql(')');
    }

    @Override
    protected int renderJsonNestedColumnDefinition(SqlAppender sqlAppender, JsonTableNestedColumnDefinition definition, int clauseLevel, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("nested path ");
        sqlAppender.appendSingleQuoteEscapedString(definition.jsonPath());
        return this.renderColumns(sqlAppender, definition.columns(), clauseLevel, walker);
    }

    @Override
    protected void renderJsonValueColumnDefinition(SqlAppender sqlAppender, JsonTableValueColumnDefinition definition, int clauseLevel, SqlAstTranslator<?> walker) {
        Expression defaultExpression;
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(' ');
        sqlAppender.appendSql(this.determineColumnType(definition.type(), walker));
        if (definition.jsonPath() != null) {
            sqlAppender.appendSql(" path ");
            sqlAppender.appendSingleQuoteEscapedString(definition.jsonPath());
        } else {
            sqlAppender.appendSql(" path '$.");
            sqlAppender.appendSql(definition.name());
            sqlAppender.appendSql("'");
        }
        if (definition.errorBehavior() != null) {
            if (definition.errorBehavior() == JsonValueErrorBehavior.ERROR) {
                sqlAppender.appendSql(" error on error");
            } else if (definition.errorBehavior() != JsonValueErrorBehavior.NULL) {
                defaultExpression = definition.errorBehavior().getDefaultExpression();
                assert (defaultExpression != null);
                sqlAppender.appendSql(" default ");
                defaultExpression.accept(walker);
                sqlAppender.appendSql(" on error");
            }
        }
        if (definition.emptyBehavior() != null) {
            if (definition.emptyBehavior() == JsonValueEmptyBehavior.ERROR) {
                sqlAppender.appendSql(" error on empty");
            } else if (definition.emptyBehavior() != JsonValueEmptyBehavior.NULL) {
                defaultExpression = definition.emptyBehavior().getDefaultExpression();
                assert (defaultExpression != null);
                sqlAppender.appendSql(" default ");
                defaultExpression.accept(walker);
                sqlAppender.appendSql(" on empty");
            }
        }
    }

    @Override
    protected void renderJsonQueryColumnDefinition(SqlAppender sqlAppender, JsonTableQueryColumnDefinition definition, int clauseLevel, SqlAstTranslator<?> walker) {
        if (definition.wrapMode() != null && definition.wrapMode() != JsonQueryWrapMode.WITH_CONDITIONAL_WRAPPER) {
            throw new QueryException("Can't emulate wrapper clause on MySQL");
        }
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(' ');
        sqlAppender.appendSql(DdlTypeHelper.getTypeName(definition.type(), walker.getSessionFactory().getTypeConfiguration()));
        if (definition.type().getJdbcType().getDdlTypeCode() != 3001) {
            sqlAppender.appendSql(" format json");
        }
        if (definition.jsonPath() != null) {
            sqlAppender.appendSql(" path ");
            sqlAppender.appendSingleQuoteEscapedString(definition.jsonPath());
        } else {
            sqlAppender.appendSql(" path '$.");
            sqlAppender.appendSql(definition.name());
            sqlAppender.appendSql("'");
        }
        if (definition.errorBehavior() != null) {
            switch (definition.errorBehavior()) {
                case ERROR: {
                    sqlAppender.appendSql(" error on error");
                    break;
                }
                case NULL: {
                    sqlAppender.appendSql(" null on error");
                    break;
                }
                case EMPTY_OBJECT: {
                    sqlAppender.appendSql(" default '{}' on error");
                    break;
                }
                case EMPTY_ARRAY: {
                    sqlAppender.appendSql(" default '[]' on error");
                }
            }
        }
        if (definition.emptyBehavior() != null) {
            switch (definition.emptyBehavior()) {
                case ERROR: {
                    sqlAppender.appendSql(" error on empty");
                    break;
                }
                case NULL: {
                    sqlAppender.appendSql(" null on empty");
                    break;
                }
                case EMPTY_OBJECT: {
                    sqlAppender.appendSql(" default '{}' on empty");
                    break;
                }
                case EMPTY_ARRAY: {
                    sqlAppender.appendSql(" default '[]' on empty");
                }
            }
        }
    }

    @Override
    protected void renderJsonExistsColumnDefinition(SqlAppender sqlAppender, JsonTableExistsColumnDefinition definition, int clauseLevel, SqlAstTranslator<?> walker) {
        if (definition.errorBehavior() != null && definition.errorBehavior() != JsonExistsErrorBehavior.ERROR) {
            throw new QueryException("Can't emulate on error clause on MySQL");
        }
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(' ');
        sqlAppender.appendSql(DdlTypeHelper.getTypeName(definition.type(), walker.getSessionFactory().getTypeConfiguration()));
        sqlAppender.appendSql(" exists");
        if (definition.jsonPath() != null) {
            sqlAppender.appendSql(" path ");
            sqlAppender.appendSingleQuoteEscapedString(definition.jsonPath());
        } else {
            sqlAppender.appendSql(" path '$.");
            sqlAppender.appendSql(definition.name());
            sqlAppender.appendSql("'");
        }
    }
}

