/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.dialect.function.json.JsonQueryFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonQueryEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryWrapMode;
import org.hibernate.type.spi.TypeConfiguration;

public class MySQLJsonQueryFunction
extends JsonQueryFunction {
    public MySQLJsonQueryFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, false);
    }

    @Override
    protected void render(SqlAppender sqlAppender, JsonQueryFunction.JsonQueryArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        if (arguments.errorBehavior() != null && arguments.errorBehavior() != JsonQueryErrorBehavior.ERROR || arguments.emptyBehavior() == JsonQueryEmptyBehavior.ERROR || arguments.emptyBehavior() != null && arguments.emptyBehavior() != JsonQueryEmptyBehavior.NULL) {
            super.render(sqlAppender, arguments, returnType, walker);
        } else {
            JsonQueryWrapMode wrapMode = arguments.wrapMode();
            DecorationMode decorationMode = MySQLJsonQueryFunction.determineDecorationMode(arguments, walker, wrapMode);
            if (decorationMode == DecorationMode.WRAP) {
                sqlAppender.appendSql("concat('[',");
            } else if (decorationMode == DecorationMode.TRIM) {
                sqlAppender.appendSql("cast(trim(leading '[' from trim(trailing ']' from ");
            }
            sqlAppender.appendSql("nullif(json_extract(");
            arguments.jsonDocument().accept(walker);
            sqlAppender.appendSql(",");
            JsonPathPassingClause passingClause = arguments.passingClause();
            if (passingClause == null) {
                arguments.jsonPath().accept(walker);
            } else {
                JsonPathHelper.appendJsonPathConcatPassingClause(sqlAppender, arguments.jsonPath(), passingClause, walker);
            }
            sqlAppender.appendSql("),cast('null' as json))");
            if (decorationMode == DecorationMode.WRAP) {
                sqlAppender.appendSql(",']')");
            } else if (decorationMode == DecorationMode.TRIM) {
                sqlAppender.appendSql(")) as json)");
            }
        }
    }

    private static DecorationMode determineDecorationMode(JsonQueryFunction.JsonQueryArguments arguments, SqlAstTranslator<?> walker, JsonQueryWrapMode wrapMode) {
        if (wrapMode == JsonQueryWrapMode.WITH_WRAPPER) {
            String jsonPath = (String)walker.getLiteralValue(arguments.jsonPath());
            if (jsonPath.indexOf(42) != -1) {
                return DecorationMode.NONE;
            }
            return DecorationMode.WRAP;
        }
        if (wrapMode == JsonQueryWrapMode.WITHOUT_WRAPPER) {
            String jsonPath = (String)walker.getLiteralValue(arguments.jsonPath());
            if (jsonPath.indexOf(42) != -1) {
                return DecorationMode.TRIM;
            }
            return DecorationMode.NONE;
        }
        return DecorationMode.NONE;
    }

    static enum DecorationMode {
        NONE,
        WRAP,
        TRIM;

    }
}

